package cn.com.utils.dialog.manager;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;

import cn.com.utils.dialog.constant.Constant;
import cn.com.utils.dialog.enums.DialogOptions;
import cn.com.utils.dialog.interfaces.AskDialogEventListener;

public class DialogObserver implements Constant {


    private AskDialogEventListener mAskDialogEventListener = null;

    private Observer mObserver = new Observer();

    private Context mContext = null;

    private int mReqCode = -1;

    public DialogObserver(Context context, AskDialogEventListener askDialogEventListener) {

        mContext = context;

        mAskDialogEventListener = askDialogEventListener;
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION);
        mContext.registerReceiver(mObserver, filter);
    }

    public void setReqCode(int reqCode) {

        mReqCode = reqCode;
    }

    private void onDestroy() {

        if (mContext != null && mObserver != null) {
            mContext.unregisterReceiver(mObserver);
        }
    }

    private class Observer extends BroadcastReceiver {

        @Override
        public void onReceive(Context context, Intent intent) {

            String action = intent.getAction();
            int reqCode = intent.getIntExtra("reqCode", -1);
            int dialogOptions = intent.getIntExtra("dialogOptions", -1);
            if (action.equals(ACTION) && reqCode != -1 && dialogOptions != -1 && reqCode == mReqCode && mAskDialogEventListener != null) {
                if (dialogOptions == 1) {
                    mAskDialogEventListener.onAskDialogEvent(DialogOptions.CONFIRM);
                } else if (dialogOptions == 0) {
                    mAskDialogEventListener.onAskDialogEvent(DialogOptions.CANCEL);
                }
                onDestroy();
            }
        }
    }
}
