package cn.com.utils.dialog.manager;

import android.content.Context;
import android.content.Intent;

import cn.com.utils.dialog.constant.Constant;
import cn.com.utils.dialog.enums.DialogOptions;
import cn.com.utils.dialog.interfaces.AskDialogEventListener;
import cn.com.utils.dialog.utils.DialogUtils;

import android.os.Bundle;

public class DialogManager implements Constant {


    private Context mApplicationContext = null;

    private static volatile DialogManager mDialogManager = null;

    private DialogManager(Context context) {

        if (mApplicationContext == null) {
            mApplicationContext = context.getApplicationContext();
        }
    }


    public static DialogManager getInstance(Context context) {

        if (mDialogManager == null) {
            mDialogManager = new DialogManager(context);
        }
        return mDialogManager;
    }

    public void openReqDialog(int time, String tips, boolean anim) {

        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        bundle.putInt(TIME, time);
        bundle.putString(TIPS, tips);
        bundle.putBoolean(ANIM, anim);
        intent.putExtras(bundle);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
        intent.setAction(DialogUtils.getOpenReqActivityAction(mApplicationContext));
        intent.addCategory(DialogUtils.getOpenReqActivityCategory(mApplicationContext));
        mApplicationContext.startActivity(intent);
    }

    public void closeReqDialog() {

        Intent intent = new Intent();
        intent.setAction(DialogUtils.getCloseReqActivityAction(mApplicationContext));
        mApplicationContext.sendBroadcast(intent);
    }

    public void openAskDialog(int time, String tips, DialogOptions defaultBtn, AskDialogEventListener askDialogEventListener) {

        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        bundle.putInt(TIME, time);
        bundle.putString(TIPS, tips);
        if (defaultBtn == DialogOptions.CONFIRM) {
            bundle.putInt(DEFAULT, 1);
        } else if (defaultBtn == DialogOptions.CANCEL) {
            bundle.putInt(DEFAULT, 0);
        }
        bundle.putInt(KEY, askDialogEventListener.hashCode());
        intent.putExtras(bundle);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        AskDialogTransfer.getInstance().addInterface(askDialogEventListener);
        intent.setAction(DialogUtils.getOpenAskActivityAction(mApplicationContext));
        intent.addCategory(DialogUtils.getOpenAskActivityCategory(mApplicationContext));
        mApplicationContext.startActivity(intent);
    }

    public void openAskDialog(int time, String tips, DialogOptions defaultBtn, DialogObserver dialogObserver) {

        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        bundle.putInt(TIME, time);
        bundle.putString(TIPS, tips);
        if (defaultBtn == DialogOptions.CONFIRM) {
            bundle.putInt(DEFAULT, 1);
        } else if (defaultBtn == DialogOptions.CANCEL) {
            bundle.putInt(DEFAULT, 0);
        }

        bundle.putInt(REQ_CODE, dialogObserver.hashCode());
        dialogObserver.setReqCode(dialogObserver.hashCode());
        intent.putExtras(bundle);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.setAction(DialogUtils.getOpenAskActivityAction(mApplicationContext));
        intent.addCategory(DialogUtils.getOpenAskActivityCategory(mApplicationContext));
        mApplicationContext.startActivity(intent);
    }

    public void closeAskDialog() {

        Intent intent = new Intent();
        intent.setAction(DialogUtils.getCloseAskActivityAction(mApplicationContext));
        mApplicationContext.sendBroadcast(intent);
    }
}


/*

 <activity
            android:name="cn.com.utils.dialog.activity.ReqDialogActivity"
            android:enabled="true"
            android:exported="true"
            android:launchMode="singleTask"
            android:theme="@style/dialog">
            <intent-filter>
                <action android:name="(your package name).open.req.dialog.activity.action" />

                <category android:name="(your package name).open.req.dialog.activity.category" />
                <category android:name="android.intent.category.DEFAULT" />
            </intent-filter>
        </activity>
        <activity
            android:name="cn.com.utils.dialog.activity.AskDialogActivity"
            android:enabled="true"
            android:exported="true"
            android:theme="@style/dialog">
            <intent-filter>
                <action android:name="(your package name).open.ask.dialog.activity.action" />

                <category android:name="(your package name).open.ask.dialog.activity.category" />
                <category android:name="android.intent.category.DEFAULT" />
            </intent-filter>
        </activity>
 */
