package cn.com.utils.dialog.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import android.widget.Toast;

import cn.com.utils.dialog.R;

public abstract class BaseDialogActivity extends Activity implements Runnable {

    private int mCountDown = 3;

    protected final int HANDLE_UPDATE_TIMER = 0x01;

    protected final int HANDLE_TODO_NEXT = 0x02;

    protected boolean mRunning = true;

    private Handler mHandler = null;

    private Thread mThread = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);
        overridePendingTransition(R.anim.dialog_enter, R.anim.dialog_exit);
        initHandler();
    }

    public abstract void initView();

    public abstract void initParam(boolean startThread, Intent intent);

    public void setActivityWidthHeight(int width, int height) {

        WindowManager.LayoutParams layoutParams = getWindow().getAttributes();
        layoutParams.width = width;
        layoutParams.height = height;
        layoutParams.alpha = 1.0f;
        getWindow().setAttributes(layoutParams);

    }

    public int getScreenWidth(double multiple) {

        DisplayMetrics displayMetrics = new DisplayMetrics();
        getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        int nScreenWidth = displayMetrics.widthPixels;
        int nScreenHeight = displayMetrics.heightPixels;
        if (nScreenWidth > nScreenHeight) {
            return (int) (nScreenHeight * multiple);
        } else {
            return (int) (nScreenWidth * multiple);
        }
    }

    private void initHandler() {

        mThread = new Thread(this);
        mHandler = new Handler(new Handler.Callback() {

            @Override
            public boolean handleMessage(Message msg) {

                try {
                    BaseDialogActivity.this.handleMessage(msg);
                } catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }
        });
    }

    public void setCountdown(int countDown) {

        mCountDown = countDown;
    }

    public Thread getThread() {

        return mThread;
    }

    public Handler getHandler() {

        return mHandler;
    }

    private void handleMessage(Message message) {

        int nWhat = message.what;
        if (nWhat == HANDLE_UPDATE_TIMER) {

            if (mCountDownCallback != null) {
                mCountDownCallback.onCountDownEvent(mCountDown);
            }

            if (mCountDown >= 1) {
                mCountDown--;

            } else {
                mHandler.sendEmptyMessage(HANDLE_TODO_NEXT);
            }

        } else if (nWhat == HANDLE_TODO_NEXT) {
            mRunning = false;
            toDoNext();
        }

    }

    /**
     * to do next when activity finish ,you can override this method
     */
    protected void toDoNext() {

        finish();
    }

    @Override
    protected void onDestroy() {

        mRunning = false;
        super.onDestroy();
    }

    @Override
    public void run() {

        while (mRunning) {
            try {
                mHandler.sendEmptyMessage(HANDLE_UPDATE_TIMER);
                Thread.sleep(1000);
            } catch (Exception e) {
                mRunning = false;
                Toast.makeText(getApplicationContext(), "Exception：" + e.toString(), Toast.LENGTH_SHORT).show();
            }
        }

    }

    @Override
    public void finish() {

        super.finish();
        overridePendingTransition(R.anim.dialog_enter, R.anim.dialog_exit);
    }

    public interface CountDownCallback {

        void onCountDownEvent(int countDown);

    }

    private CountDownCallback mCountDownCallback = null;

    public void setCountDownCallback(CountDownCallback countDownCallback) {

        mCountDownCallback = countDownCallback;
    }
}
