package cn.com.utils.dialog.activity;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import cn.com.utils.dialog.constant.Constant;
import cn.com.utils.dialog.enums.DialogOptions;
import cn.com.utils.dialog.interfaces.AskDialogEventListener;
import cn.com.utils.dialog.manager.AskDialogTransfer;

import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import cn.com.utils.dialog.R;
import cn.com.utils.dialog.utils.DialogUtils;

public class AskDialogActivity extends BaseDialogActivity implements Constant, View.OnClickListener, BaseDialogActivity.CountDownCallback {

    private AskDialogEventListener mAskDialogEventListener = null;

    private AskDialogTransfer mAskDialogTransfer = null;

    private TextView mTipText = null;

    private int mKey = -1;

    private int mDefault = -1;

    private int mReqCode = -1;

    private TextView mTextViewConfirmButton = null;

    private TextView mTextViewCancelButton = null;

    private String mButtonTips = null;

    private LinearLayout mConfirmLinearLayout = null;

    private LinearLayout mCancelLinearLayout = null;

    private BroadcastReceiver mCloseAskActivityReceiver = new BroadcastReceiver() {

        @Override
        public void onReceive(Context context, Intent intent) {

            String action = intent.getAction();
            if (DialogUtils.getCloseAskActivityAction(context).equals(action)) {
                finish();
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);
        if (mAskDialogTransfer == null) {
            mAskDialogTransfer = AskDialogTransfer.getInstance();
        }
        setContentView(R.layout.ask_dialog);
        setActivityWidthHeight(getScreenWidth(0.8), getScreenWidth(0.4));
        registerBroadcastAction(true);
        initView();
        initParam(true, getIntent());
        setCountDownCallback(this);
    }

    @Override
    protected void onDestroy() {

        mKey = -1;
        mDefault = -1;
        mReqCode = -1;
        registerBroadcastAction(false);
        super.onDestroy();
    }

    @Override
    public void initView() {

        if (mConfirmLinearLayout == null) {
            mConfirmLinearLayout = (LinearLayout) findViewById(R.id.dialog_confirm_lin);
            mConfirmLinearLayout.setOnClickListener(this);
        }
        if (mCancelLinearLayout == null) {
            mCancelLinearLayout = (LinearLayout) findViewById(R.id.dialog_cancel_lin);
            mCancelLinearLayout.setOnClickListener(this);
        }
        if (mTipText == null) {
            mTipText = (TextView) findViewById(R.id.dialog_tips);
        }
        if (mTextViewConfirmButton == null) {
            mTextViewConfirmButton = (TextView) findViewById(R.id.dialog_confirm_tv);
        }
        if (mTextViewCancelButton == null) {
            mTextViewCancelButton = (TextView) findViewById(R.id.dialog_cancel_tv);
        }
    }

    @Override
    public void initParam(boolean startThread, Intent intent) {

        if (intent == null) {
            return;
        }
        Bundle data = intent.getExtras();
        if (data == null) {
            return;
        }

        if (data.containsKey(TIME)) {
            int nTime = data.getInt(TIME);
            setCountdown(nTime);
        } else {
            setCountdown(3);
        }

        if (data.containsKey(TIPS)) {
            String sTips = data.getString(TIPS);
            mTipText.setText(sTips);
        } else {
            mTipText.setText("wait");
        }
        if (data.containsKey(KEY)) {
            mKey = data.getInt(KEY);
        }
        if (data.containsKey(REQ_CODE)) {
            mReqCode = data.getInt(REQ_CODE);
        }
        if (mAskDialogTransfer != null && mKey != -1) {
            mAskDialogEventListener = mAskDialogTransfer.getInterface(mKey);
        }
        if (data.containsKey(DEFAULT)) {
            mDefault = data.getInt(DEFAULT);
            if (mDefault == 1) {
                mButtonTips = mTextViewConfirmButton.getText().toString();
            } else if (mDefault == 0) {
                mButtonTips = mTextViewCancelButton.getText().toString();
            }
        } else {
            mButtonTips = mTextViewCancelButton.getText().toString();
        }
        if (startThread) {
            getThread().start();
        }
    }

    @Override
    public void onClick(View v) {

        int key = v.getId();
        finish();
        if (key == R.id.dialog_confirm_lin) {
            if (mAskDialogEventListener != null) {
                mAskDialogEventListener.onAskDialogEvent(DialogOptions.CONFIRM);
            }
            sendDialogOptions(DialogOptions.CONFIRM);

        } else if (key == R.id.dialog_cancel_lin) {
            if (mAskDialogEventListener != null) {
                mAskDialogEventListener.onAskDialogEvent(DialogOptions.CANCEL);
            }
            sendDialogOptions(DialogOptions.CANCEL);
        }
        if (mAskDialogTransfer != null) {
             mAskDialogTransfer.removeInterface(mKey);
        }
    }

    private void sendDialogOptions(DialogOptions dialogOptions) {

        Intent intent = new Intent();
        intent.setAction(ACTION);
        if (dialogOptions == DialogOptions.CONFIRM) {
            intent.putExtra("dialogOptions", 1);

        } else if (dialogOptions == DialogOptions.CANCEL) {
            intent.putExtra("dialogOptions", 0);
        }
        if (mReqCode != -1) {
            intent.putExtra("reqCode", mReqCode);
            sendBroadcast(intent);
        }
    }

    @Override
    public void finish() {

        super.finish();
    }

    @Override
    protected void toDoNext() {

        super.toDoNext();
        if (mDefault == 1) {
            if (mAskDialogEventListener != null) {
                mAskDialogEventListener.onAskDialogEvent(DialogOptions.CONFIRM);
            }
            sendDialogOptions(DialogOptions.CONFIRM);
        } else {
            if (mAskDialogEventListener != null) {
                mAskDialogEventListener.onAskDialogEvent(DialogOptions.CANCEL);
            }
            sendDialogOptions(DialogOptions.CANCEL);
        }
        if (mAskDialogTransfer != null) {
            mAskDialogTransfer.removeInterface(mKey);
        }
    }

    @Override
    public void onCountDownEvent(int countDown) {

        if (countDown > 0) {
            String tips = mButtonTips + "(" + countDown + ")";
            if (mDefault == 1) {
                mTextViewConfirmButton.setText(tips);
            } else {
                mTextViewCancelButton.setText(tips);
            }

        } else {
            if (mDefault == 1) {
                mTextViewConfirmButton.setText(mButtonTips);
            } else {
                mTextViewCancelButton.setText(mButtonTips);
            }
        }
    }

    private void registerBroadcastAction(boolean register) {

        IntentFilter filter = new IntentFilter();
        if (register) {
            filter.addAction(DialogUtils.getCloseAskActivityAction(getApplicationContext()));
            filter.setPriority(Integer.MAX_VALUE);
            getApplicationContext().registerReceiver(mCloseAskActivityReceiver, filter);
        } else {
            getApplicationContext().unregisterReceiver(mCloseAskActivityReceiver);
        }
    }
}