package cn.com.utils.dialog.manager;

import cn.com.utils.dialog.interfaces.AskDialogEventListener;

import java.util.HashMap;
import java.util.Map;

public class AskDialogTransfer {

    private static AskDialogTransfer mAskDialogTransfer = null;

    private Map<Integer, AskDialogEventListener> askDialogEventListenerMap = new HashMap<>();

    private AskDialogTransfer() {

    }

    public static synchronized AskDialogTransfer getInstance() {

        if (mAskDialogTransfer == null) {
            mAskDialogTransfer = new AskDialogTransfer();
        }

        return mAskDialogTransfer;
    }

    public void addInterface(AskDialogEventListener askDialogEventListener) {

        askDialogEventListenerMap.put(askDialogEventListener.hashCode(), askDialogEventListener);
    }

    public void removeInterface(int askDialogKey) {

        askDialogEventListenerMap.remove(askDialogKey);
    }

    public AskDialogEventListener getInterface(int askDialogKey) {

        return askDialogEventListenerMap.get(askDialogKey);
    }
}