package cn.com.utils.dialog.activity;


import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

import cn.com.utils.dialog.constant.Constant;
import cn.com.utils.dialog.manager.DialogManager;

import android.os.Bundle;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;

import cn.com.utils.dialog.R;
import cn.com.utils.dialog.utils.DialogUtils;

public class ReqDialogActivity extends BaseDialogActivity implements Constant {

    public TextView mTips = null;

    private ProgressBar mLoadingProgressBar = null;

    private BroadcastReceiver mCloseReqActivityReceiver = new BroadcastReceiver() {

        @Override
        public void onReceive(Context context, Intent intent) {

            String action = intent.getAction();
            if (DialogUtils.getCloseReqActivityAction(context).equals(action)) {
                finish();
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);
        setContentView(R.layout.req_dialog);
        setActivityWidthHeight(getScreenWidth(0.8), getScreenWidth(0.2));
        registerBroadcastAction(true);
        initView();
        initParam(true, getIntent());
    }

    @Override
    protected void onDestroy() {

        super.onDestroy();
        registerBroadcastAction(false);
    }

    @Override
    public void initView() {

        if (mTips == null) {
            mTips = (TextView) findViewById(R.id.req_dialog_tips);
        }
        if (mLoadingProgressBar == null) {
            mLoadingProgressBar = (ProgressBar) findViewById(R.id.req_dialog_loading);
        }
    }

    @Override
    public void initParam(boolean startThread, Intent intent) {

        if (intent == null) {
            return;
        }

        Bundle data = intent.getExtras();
        if (data == null) {
            return;
        }
        if (data.containsKey(TIME)) {
            int time = data.getInt(TIME);
            setCountdown(time);
        } else {
            setCountdown(3);
        }
        if (data.containsKey(TIPS)) {
            String sTips = data.getString(TIPS);
            mTips.setText(sTips);
        } else {
            mTips.setText("wait a moment");
        }
        if (data.containsKey(ANIM)) {
            boolean bAnim = data.getBoolean(ANIM);
            if (bAnim) {
                mLoadingProgressBar.setVisibility(View.VISIBLE);
            } else {
                mLoadingProgressBar.setVisibility(View.GONE);
            }
        } else {
            mLoadingProgressBar.setVisibility(View.GONE);
        }
        if (startThread) {
            getThread().start();
        }
    }

    @Override
    protected void onNewIntent(Intent intent) {

        super.onNewIntent(intent);
        initParam(false, intent);
    }

    @Override
    protected void toDoNext() {

        super.toDoNext();
    }

    private void registerBroadcastAction(boolean register) {

        IntentFilter filter = new IntentFilter();
        if (register) {
            filter.addAction(DialogUtils.getCloseReqActivityAction(getApplicationContext()));
            filter.setPriority(Integer.MAX_VALUE);
            getApplicationContext().registerReceiver(mCloseReqActivityReceiver, filter);
        } else {
            getApplicationContext().unregisterReceiver(mCloseReqActivityReceiver);
        }
    }
}