package cn.com.utils.dialog.activity;

import android.content.Intent;

import cn.com.utils.dialog.constant.Constant;
import cn.com.utils.dialog.enums.DialogOptions;
import cn.com.utils.dialog.interfaces.AskDialogEventListener;
import cn.com.utils.dialog.manager.AskDialogTransfer;

import android.os.Bundle;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import cn.com.utils.dialog.R;

public class AskDialogActivity extends BaseDialogActivity implements Constant, View.OnClickListener, BaseDialogActivity.CountDownCallback {

    private AskDialogEventListener mAskDialogEventListener = null;

    private AskDialogTransfer mAskDialogTransfer = null;

    private TextView mTipText = null;

    private int nKey = -1;

    private int nDefault = -1;

    private TextView mTextViewConfirmButton = null;

    private TextView mTextViewCancelButton = null;

    private String mButtonTips = null;

    private LinearLayout mConfirmLinearLayout = null;

    private LinearLayout mCancelLinearLayout = null;


    @Override
    protected void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);
        if (mAskDialogTransfer == null) {
            mAskDialogTransfer = AskDialogTransfer.getInstance();
        }
        setContentView(R.layout.ask_dialog);
        setActivityWidthHeight(getScreenWidth(0.8), getScreenWidth(0.4));
        initView();
        initParam(true, getIntent());
        setCountDownCallback(this);
    }

    @Override
    public void initView() {

        if (mConfirmLinearLayout == null) {
            mConfirmLinearLayout = (LinearLayout) findViewById(R.id.dialog_confirm_lin);
            mConfirmLinearLayout.setOnClickListener(this);
        }
        if (mCancelLinearLayout == null) {
            mCancelLinearLayout = (LinearLayout) findViewById(R.id.dialog_cancel_lin);
            mCancelLinearLayout.setOnClickListener(this);
        }
        if (mTipText == null) {
            mTipText = (TextView) findViewById(R.id.dialog_tips);
        }
        if (mTextViewConfirmButton == null) {
            mTextViewConfirmButton = (TextView) findViewById(R.id.dialog_confirm_tv);
        }
        if (mTextViewCancelButton == null) {
            mTextViewCancelButton = (TextView) findViewById(R.id.dialog_cancel_tv);
        }
    }

    @Override
    public void initParam(boolean startThread, Intent intent) {

        if (intent == null) {
            return;
        }
        Bundle data = intent.getExtras();
        if (data == null) {
            return;
        }

        if (data.containsKey(TIME)) {
            int nTime = data.getInt(TIME);
            setCountdown(nTime);
        } else {
            setCountdown(3);
        }

        if (data.containsKey(TIPS)) {
            String sTips = data.getString(TIPS);
            mTipText.setText(sTips);
        } else {
            mTipText.setText("wait");
        }
        if (data.containsKey(KEY)) {
            nKey = data.getInt(KEY);
        }
        if (mAskDialogTransfer != null) {
            mAskDialogEventListener = mAskDialogTransfer.getInterface(nKey);
        }
        if (data.containsKey(DEFAULT)) {
            nDefault = data.getInt(DEFAULT);
            if (nDefault == 1) {
                mButtonTips = mTextViewConfirmButton.getText().toString();
            } else if (nDefault == 0) {
                mButtonTips = mTextViewCancelButton.getText().toString();
            }
        } else {
            mButtonTips = mTextViewCancelButton.getText().toString();
        }
        if (startThread) {
            getThread().start();
        }
    }

    @Override
    public void onClick(View v) {

        int key = v.getId();
        finish();
        if (key == R.id.dialog_confirm_lin) {
            if (mAskDialogEventListener != null) {
                mAskDialogEventListener.onAskDialogEvent(DialogOptions.CONFIRM);
            }
        } else if (key == R.id.dialog_cancel_lin) {
            if (mAskDialogEventListener != null) {
                mAskDialogEventListener.onAskDialogEvent(DialogOptions.CANCEL);
            }
        }
        if (mAskDialogTransfer != null) {
            mAskDialogTransfer.removeInterface(key);
        }
    }


    @Override
    public void finish() {

        super.finish();
    }

    @Override
    protected void toDoNext() {

        super.toDoNext();
        if (nDefault == 1) {
            if (mAskDialogEventListener != null) {
                mAskDialogEventListener.onAskDialogEvent(DialogOptions.CONFIRM);
            }
        } else {
            if (mAskDialogEventListener != null) {
                mAskDialogEventListener.onAskDialogEvent(DialogOptions.CANCEL);
            }
        }
    }

    @Override
    public void onCountDownEvent(int countDown) {

        if (countDown > 0) {
            String tips = mButtonTips + "(" + countDown + ")";
            if (nDefault == 1) {
                mTextViewConfirmButton.setText(tips);
            } else {
                mTextViewCancelButton.setText(tips);
            }

        } else {
            if (nDefault == 1) {
                mTextViewConfirmButton.setText(mButtonTips);
            } else {
                mTextViewCancelButton.setText(mButtonTips);
            }
        }
    }
}
