/*
 * Copyright 2015 YAN KA KA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.com.utils.data.utils;

import android.text.TextUtils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionUtil {

    private static final String TAG = "ReflectionUtil";

    public static Object getValue(Object instance, String fieldName) {

        try {
            Field field = instance.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(instance);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean setValue(Object instance, String fieldName, String value) {

        try {
            if (instance == null || TextUtils.isEmpty(fieldName)) {
                return false;
            }
            Class modelClass = instance.getClass();
            if (!isExistField(modelClass, fieldName)) {
                return false;
            }
            Field field = modelClass.getDeclaredField(fieldName);
            if (field == null) {
                return false;
            }
            field.setAccessible(true);
            Class<?> type = field.getType();
            String typeName = type.getName();
            if ("int".equals(typeName)) {
                field.set(instance, value == null ? -1 : Integer.parseInt(value));
            } else if ("double".equals(typeName)) {
                field.set(instance, value == null ? -1 : Double.parseDouble(value));
            } else if ("java.lang.String".equals(typeName)) {
                field.set(instance, value);
            } else if ("float".equals(typeName)) {
                field.set(instance, value == null ? -1 : Float.parseFloat(value));
            } else if ("long".equals(typeName)) {
                field.set(instance, value == null ? -1 : Long.parseLong(value));
            } else if ("boolean".equals(typeName)) {
                field.set(instance, Boolean.parseBoolean(value));
            } else {
                return false;
            }
            return true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static boolean isExistField(Class modelClass, String fieldName) {

        Field[] fields = modelClass.getDeclaredFields();
        for (Field field : fields) {
            if (field.getName().equals(fieldName)) {
                return true;
            }
        }
        return false;
    }

    public static Object callMethod(Object instance, String methodName, Class[] classes, Object[] objects) throws Exception {

        Method method = instance.getClass().getDeclaredMethod(methodName, classes);
        method.setAccessible(true);
        return method.invoke(instance, objects);
    }
}


