/*
 * Copyright 2015 YAN KA KA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.com.utils.data.utils;

import cn.com.utils.data.exceptions.NewClassException;

import android.util.Log;

public class DataLog {

    private static final String TAG = "Data";

    private static boolean isShow = false;

    private DataLog() {

        throw new NewClassException(NewClassException.NEW_CLASS_IS_PROHIBIT);
    }

    public static void showLogCat(boolean show) {

        isShow = show;
    }

    public static void d(String tagName, String message) {

        if (isShow) {
            Log.d(TAG, tagName + "->" + message);
        }
    }

    public static void e(String tagName, String message) {

        if (isShow) {
            Log.e(TAG, tagName + "->" + message);
        }
    }
}
