/*
 * Copyright 2015 YAN KA KA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.com.utils.data.provider;

import android.content.ContentValues;
import android.net.Uri;

class DataArguments {

    Uri mUri = null;

    String mTableName = null;

    String[] mProjection = null;

    String mSelection = null;

    String[] mSelectionArgs = null;

    String mSortOrder = null;

    ContentValues mContentValues = null;

    DataArguments(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {

        mTableName = getTableNameFromUri(uri);
        mProjection = projection;
        mSelection = selection;
        mSelectionArgs = selectionArgs;
        mSortOrder = sortOrder;
    }

    DataArguments(Uri uri, ContentValues contentValues) {

        mTableName = getTableNameFromUri(uri);
        mContentValues = contentValues;
    }

    DataArguments(Uri uri, ContentValues contentValues, String selection, String[] selectionArgs) {

        mTableName = getTableNameFromUri(uri);
        mContentValues = contentValues;
        mSelection = selection;
        mSelectionArgs = selectionArgs;
    }

    DataArguments(Uri uri, String selection, String[] selectionArgs) {

        mTableName = getTableNameFromUri(uri);
        mSelection = selection;
        mSelectionArgs = selectionArgs;
    }

    DataArguments(Uri uri) {

        mTableName = getTableNameFromUri(uri);
    }

    private String getTableNameFromUri(Uri uri) {

        mUri = uri;
        String tableName = "default_table_name";
        if (uri != null && uri.getPathSegments().size() == 1) {
            tableName = uri.getPathSegments().get(0);
        }
        return tableName.toLowerCase();
    }

}
