/*
 * Copyright 2015 YAN KA KA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.com.utils.data.manager;

import cn.com.utils.data.utils.DataLog;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;

public class DataObserver extends ContentObserver {

    private static final String TAG = "DataObserver";

    private Handler mHandler = null;

    private int mWhat = -1;

    public DataObserver(Handler handler) {

        super(handler);
        mHandler = handler;
    }

    public DataObserver(Handler handler, int what) {

        super(handler);
        mHandler = handler;
        mWhat = what;
    }

    public void setHandlerWhat(int what) {

        mWhat = what;
    }

    @Override
    public void onChange(boolean selfChange) {

        super.onChange(selfChange);
        DataLog.e(TAG, "data on change");
        if ((mHandler != null) && (mWhat != -1)) {
            mHandler.sendEmptyMessage(mWhat);
        }
    }

    @Override
    public void onChange(boolean selfChange, Uri uri) {

        super.onChange(selfChange, uri);
        DataLog.e(TAG, "data on change,uri=" + uri);
    }
}
