/*
 * Copyright 2015 YAN KA KA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.com.utils.data.database;

import cn.com.utils.data.config.DataGlobalConfig;
import cn.com.utils.data.utils.DataLog;
import cn.com.utils.data.utils.DataUtils;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;

import java.util.List;

public class DataGlobalHelper extends DataBaseHelper implements DataGlobalConfig {

    private static final String TAG = "DataGlobalHelper";

    private static volatile DataGlobalHelper mDataGlobalHelper = null;

    private DataGlobalHelper(Context context) {

        super(context, GLOBAL_DATABASE_NAME, GLOBAL_DATABASE_VERSION);
    }

    public static DataGlobalHelper getInstance(Context context) {

        synchronized (DataGlobalHelper.class) {
            if (mDataGlobalHelper == null) {
                mDataGlobalHelper = new DataGlobalHelper(context);
            }
            return mDataGlobalHelper;
        }
    }

    @Override
    public void onCreate(SQLiteDatabase db) {

        DataLog.e(TAG, "create " + db.getPath() + " Version:" + db.getVersion());
        addDefaultKeyVal("name", "yankaka");
        createDatabaseTable(db, GLOBAL_KEY_VAL_TABLE_NAME, KEY_NAME, VALUE_NAME, GLOBAL_KEY_VAL_INDEX);
        loadDefaultKeyVal(db, GLOBAL_KEY_VAL_TABLE_NAME, KEY_NAME, VALUE_NAME,DATE_TIME);
        createDatabaseBlobTable(db,GLOBAL_SERIALIZABLE_TABLE_NAME,KEY_NAME, VALUE_NAME,GLOBAL_SERIALIZABLE_INDEX);
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {

        DataLog.e(TAG, "--onUpgrade oldVersion" + oldVersion);
        DataLog.e(TAG, "--onUpgrade newVersion" + newVersion);
        List<String> tableNames = DataUtils.findAllTableNames(db);
        for (int i = 0; i < tableNames.size(); i++) {
            if (!"android_metadata".equals(tableNames.get(i)) && !"sqlite_sequence".equals(tableNames.get(i))) {
                db.execSQL("DROP TABLE IF EXISTS " + tableNames.get(i));
            }
        }
        onCreate(db);
    }

    @Override
    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {

        DataLog.e(TAG, "--onDowngrade oldVersion" + oldVersion);
        DataLog.e(TAG, "--onDowngrade newVersion" + newVersion);
        super.onDowngrade(db, oldVersion, newVersion);
    }

}
