package cn.com.startai.scansdk.bean;

import java.io.Serializable;
import java.util.List;

/**
 * Created by Robin on 2019/9/19.
 * 419109715@qq.com 彬影
 */
public class TakePhotoConfig implements Serializable {
    private int sourceType; // 1 拍照 2 相册
    private int sizeType; //1 原图 2 压缩
    private int count; //数量
    private int isCrop;//是否裁剪
    private String tempPathDir;// 临时存放文件的路径
    private List<FileBean> files; //文件列表

    public TakePhotoConfig(int sourceType, int sizeType, int count, int isCrop, String tempPathDir, List<FileBean> files) {
        this.sourceType = sourceType;
        this.sizeType = sizeType;
        this.count = count;
        this.isCrop = isCrop;
        this.tempPathDir = tempPathDir;
        this.files = files;
    }

    @Override
    public String toString() {
        return "TakePhotoConfig{" +
                "sourceType=" + sourceType +
                ", sizeType=" + sizeType +
                ", count=" + count +
                ", isCrop=" + isCrop +
                ", tempPathDir='" + tempPathDir + '\'' +
                ", files=" + files +
                '}';
    }

    public void setTempPathDir(String tempPathDir) {
        this.tempPathDir = tempPathDir;
    }

    public String getTempPathDir() {
        return tempPathDir;
    }

    public List<FileBean> getFiles() {
        return files;
    }

    public void setFiles(List<FileBean> files) {
        this.files = files;
    }

    public TakePhotoConfig() {
    }

    public TakePhotoConfig(int sourceType, int sizeType, int count, int isCrop) {
        this.sourceType = sourceType;
        this.sizeType = sizeType;
        this.count = count;
        this.isCrop = isCrop;
    }

    private TakePhotoConfig(Builder builder) {
        setSourceType(builder.sourceType);
        setSizeType(builder.sizeType);
        setCount(builder.count);
        setIsCrop(builder.isCrop);
        setTempPathDir(builder.tempPathDir);
        setFiles(builder.files);
    }

    public int getSizeType() {
        return sizeType;
    }

    public void setSizeType(int sizeType) {
        this.sizeType = sizeType;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getIsCrop() {
        return isCrop;
    }

    public void setIsCrop(int isCrop) {
        this.isCrop = isCrop;
    }


    public int getSourceType() {
        return sourceType;
    }

    public void setSourceType(int sourceType) {
        this.sourceType = sourceType;
    }


    public static final class Builder {
        private int sourceType;
        private int sizeType;
        private int count;
        private int isCrop;
        private String tempPathDir;
        private List<FileBean> files;

        public Builder() {
        }

        public Builder sourceType(int val) {
            sourceType = val;
            return this;
        }

        public Builder sizeType(int val) {
            sizeType = val;
            return this;
        }

        public Builder count(int val) {
            count = val;
            return this;
        }

        public Builder isCrop(int val) {
            isCrop = val;
            return this;
        }

        public Builder tempPathDir(String val) {
            tempPathDir = val;
            return this;
        }



        public Builder files(List<FileBean> val) {
            files = val;
            return this;
        }

        public TakePhotoConfig build() {
            return new TakePhotoConfig(this);
        }
    }


    public static class FileBean implements Serializable {
        private String path;
        private long size;


        public FileBean() {
        }

        public FileBean(String path, long size) {
            this.path = path;
            this.size = size;
        }

        @Override
        public String toString() {
            return "FileBean{" +
                    "path='" + path + '\'' +
                    ", size=" + size +
                    '}';
        }

        public String getPath() {
            return path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public long getSize() {
            return size;
        }

        public void setSize(long size) {
            this.size = size;
        }
    }
}
