package cn.com.startai.scansdk.bean;

import java.io.Serializable;
import java.util.Objects;

/**
 * Created by Robin on 2019/6/5.
 * 419109715@qq.com 彬影
 */
public class ResultBean implements ICodeType, Serializable {

    private int codeType;
    private String data;
    private int count;


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ResultBean that = (ResultBean) o;
        return Objects.equals(data, that.data);
    }

    @Override
    public int hashCode() {

        return Objects.hash(codeType, data, count);
    }

    public ResultBean(int codeType, String data, int count) {
        this.codeType = codeType;
        this.data = data;
        this.count = count;
    }

    @Override
    public String toString() {
        return "ResultBean{" +
                "codeType=" + codeType +
                ", data='" + data + '\'' +
                ", count=" + count +
                '}';
    }

    public int getCodeType() {
        return codeType;
    }

    public void setCodeType(int codeType) {
        this.codeType = codeType;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }
}
