package cn.com.startai.scansdk;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.util.Log;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.Toast;
import android.widget.ToggleButton;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.google.zxing.client.result.ParsedResult;
import com.mylhyl.zxing.scanner.ScannerOptions;
import com.mylhyl.zxing.scanner.ScannerView;

import cn.com.startai.common.utils.permission.CPermissionHelper;


/**
 * Created by Robin on 2018/3/1.
 * qq: 419109715 彬影
 */

public class ScanScanActivity extends BaseScanActivity {


    @Override
    protected void initEventAndData() {

        ToggleButton toggleButton = (ToggleButton) findViewById(R.id.toggleButton);
        toggleButton.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                mScannerView.toggleLight(isChecked);
            }
        });

        findViewById(R.id.button4).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                CPermissionHelper.requestStorage(new CPermissionHelper.OnPermissionGrantedListener() {
                    @Override
                    public void onPermissionGranted() {
                        //选择相册
                        chooseFromAlbum();
                    }
                }, new CPermissionHelper.OnPermissionDeniedListener() {
                    @Override
                    public void onPermissionDenied() {

                    }
                });
            }
        });

    }

    @Override
    protected ScannerOptions.Builder getScanBuilder() {

        ScannerOptions.Builder builder = new ScannerOptions.Builder();
        builder.setFrameSize(256, 256)
                .setFrameCornerLength(22)
                .setFrameCornerWidth(2)
                .setFrameCornerInside(true)
                .setLaserStyle(ScannerOptions.LaserStyle.RES_LINE, R.mipmap.wx_scan_line)
                .setFrameCornerColor(Color.parseColor("#FF99cc33"))//扫描框颜色
                .setScanFullScreen(false)
                .setFrameHide(true) //扫描框边线
                .setMediaResId(R.raw.baidu_beep)
                .setScanMode(BarcodeFormat.QR_CODE)
                .setTipText("将二维码放入框内")
                .setTipTextSize(16)
                .setTipTextColor(getResources().getColor(R.color.color_gray))
        ;
        return builder;
    }

    @Override
    protected ImageView getIvBack() {
        return findViewById(R.id.iv_back);
    }

    @Override
    protected int getLayout() {
        return R.layout.activity_scanner;
    }

    @Override
    protected ScannerView getScannerView() {
        return findViewById(R.id.scanner_view);
    }

    public static void showActivityForResult(final Activity act, final int requestCode) {

        CPermissionHelper.requestCamera(new CPermissionHelper.OnPermissionGrantedListener() {
            @Override
            public void onPermissionGranted() {
                Intent intent = new Intent(act, ScanScanActivity.class);
                act.startActivityForResult(intent, requestCode);
            }
        }, new CPermissionHelper.OnPermissionDeniedListener() {
            @Override
            public void onPermissionDenied() {

            }
        });

    }

}
