package cn.com.startai.scansdk;

import java.io.Serializable;

import cn.com.startai.scansdk.bean.IScanType;

/**
 * Created by Robin on 2019/2/20.
 * qq: 419109715 彬影
 */

public class ScanConfig implements Serializable {

    private int scanPeroid = 2000;//扫描类型为 多次扫描时有效，两次扫描之前的间隔 ms
    private int scanType = IScanType.TYPE_SINLE; //1 单次扫描 2 多次扫描
    private int resBackIcon = R.drawable.ic_arrow_back;
    private int resScanLine = R.mipmap.wx_scan_line_yellow;
    private String scanHexColor = "#FFF5D822";
    private int resScanColor = R.color.colorPrimary;
    private int resTitleText = R.string.empty;
    private int resTitleTextColor = R.color.colorPrimary;
    private int resFlashlightOff = R.drawable.flashlight_off_charger;
    //闪光灯
    private int resFlashlightOn = R.drawable.flashlight_on_charger;
    //扫描提示文字
    private int resTextScanDesc = R.string.please_scan;
    private int resTextScanDescColor = R.color.color_gray;

    public ScanConfig() {
    }

    @Override
    public String toString() {
        return "ScanConfig{" +
                "scanPeroid=" + scanPeroid +
                ", scanType=" + scanType +
                ", resBackIcon=" + resBackIcon +
                ", resScanLine=" + resScanLine +
                ", scanHexColor='" + scanHexColor + '\'' +
                ", resScanColor=" + resScanColor +
                ", resTitleText=" + resTitleText +
                ", resTitleTextColor=" + resTitleTextColor +
                ", resFlashlightOff=" + resFlashlightOff +
                ", resFlashlightOn=" + resFlashlightOn +
                ", resTextScanDesc=" + resTextScanDesc +
                ", resTextScanDescColor=" + resTextScanDescColor +
                '}';
    }

    public int getResTextScanDescColor() {
        return resTextScanDescColor;
    }

    public void setResTextScanDescColor(int resTextScanDescColor) {
        this.resTextScanDescColor = resTextScanDescColor;
    }

    public int getResTitleText() {
        return resTitleText;
    }

    public void setResTitleText(int resTitleText) {
        this.resTitleText = resTitleText;
    }

    public int getResTitleTextColor() {
        return resTitleTextColor;
    }

    public void setResTitleTextColor(int resTitleTextColor) {
        this.resTitleTextColor = resTitleTextColor;
    }

    public int getResScanColor() {
        return resScanColor;
    }

    public void setResScanColor(int resScanColor) {
        this.resScanColor = resScanColor;
    }

    public int getScanPeroid() {
        return scanPeroid;
    }

    public void setScanPeroid(int scanPeroid) {
        this.scanPeroid = scanPeroid;
    }

    public int getScanType() {
        return scanType;
    }

    public void setScanType(int scanType) {
        this.scanType = scanType;
    }

    public int getResBackIcon() {
        return resBackIcon;
    }

    public void setResBackIcon(int resBackIcon) {
        this.resBackIcon = resBackIcon;
    }

    public int getResScanLine() {
        return resScanLine;
    }

    public void setResScanLine(int resScanLine) {
        this.resScanLine = resScanLine;
    }

    public String getScanHexColor() {
        return scanHexColor;
    }

    public void setScanHexColor(String scanHexColor) {
        this.scanHexColor = scanHexColor;
    }

    public int getResFlashlightOff() {
        return resFlashlightOff;
    }

    public void setResFlashlightOff(int resFlashlightOff) {
        this.resFlashlightOff = resFlashlightOff;
    }

    public int getResFlashlightOn() {
        return resFlashlightOn;
    }

    public void setResFlashlightOn(int resFlashlightOn) {
        this.resFlashlightOn = resFlashlightOn;
    }

    public int getResTextScanDesc() {
        return resTextScanDesc;
    }

    public void setResTextScanDesc(int resTextScanDesc) {
        this.resTextScanDesc = resTextScanDesc;
    }

    private ScanConfig(Builder builder) {
        setScanPeroid(builder.scanPeroid);
        setScanType(builder.scanType);
        setResBackIcon(builder.resBackIcon);
        setResScanLine(builder.resScanLine);
        setScanHexColor(builder.scanHexColor);
        setResScanColor(builder.resScanColor);
        setResTitleText(builder.resTitleText);
        setResTitleTextColor(builder.resTitleTextColor);
        setResFlashlightOff(builder.resFlashlightOff);
        setResFlashlightOn(builder.resFlashlightOn);
        setResTextScanDesc(builder.resTextScanDesc);
        setResTextScanDescColor(builder.resTextScanDescColor);
    }

    public static final class Builder {
        private int scanPeroid = 2000;
        private int scanType = IScanType.TYPE_SINLE; //1 单次扫描 2 多次扫描
        private int resBackIcon = R.drawable.ic_arrow_back;
        private int resScanLine = R.mipmap.wx_scan_line_yellow;
        private String scanHexColor = "#FFF5D822";
        private int resScanColor = R.color.colorPrimary;
        private int resTextScanDescColor = R.color.color_gray;
        private int resTitleText = R.string.empty;
        private int resTitleTextColor = R.color.colorPrimary;
        private int resFlashlightOff = R.drawable.flashlight_off_charger;
        //闪光灯
        private int resFlashlightOn = R.drawable.flashlight_on_charger;
        //扫描提示文字
        private int resTextScanDesc = R.string.please_scan;

        public Builder() {
        }

        public Builder scanType(int val) {
            scanType = val;
            return this;
        }

        public Builder resBackIcon(int val) {
            resBackIcon = val;
            return this;
        }

        public Builder resScanLine(int val) {
            resScanLine = val;
            return this;
        }

        public Builder scanHexColor(String val) {
            scanHexColor = val;
            return this;
        }

        public Builder resScanColor(int val) {
            resScanColor = val;
            return this;
        }

        public Builder resTitleText(int val) {
            resTitleText = val;
            return this;
        }

        public Builder resTitleTextColor(int val) {
            resTitleTextColor = val;
            return this;
        }

        public Builder resFlashlightOff(int val) {
            resFlashlightOff = val;
            return this;
        }

        public Builder resFlashlightOn(int val) {
            resFlashlightOn = val;
            return this;
        }

        public Builder resTextScanDesc(int val) {
            resTextScanDesc = val;
            return this;
        }

        public Builder resTextScanDescColor(int val) {
            resTextScanDescColor = val;
            return this;
        }

        public Builder scanPeroid(int val) {
            scanPeroid = val;
            return this;
        }

        public ScanConfig build() {
            return new ScanConfig(this);
        }

    }
}
