package cn.com.startai.scansdk;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.ToggleButton;

import com.google.zxing.BarcodeFormat;
import com.mylhyl.zxing.scanner.ScannerOptions;
import com.mylhyl.zxing.scanner.ScannerView;

import cn.com.startai.common.utils.permission.CPermissionHelper;


/**
 * Created by Robin on 2018/3/1.
 * qq: 419109715 彬影
 */

public class HDTrainScanScanActivity extends BaseScanActivity {
    public static final String EXTRA_SCAN_CONFIG = "scanConfig";
    private ToggleButton toggleButton;



    @Override
    protected ScannerOptions.Builder getScanBuilder() {
        ScannerOptions.Builder builder = new ScannerOptions.Builder();
        builder.setFrameSize(256, 256)
                .setFrameCornerLength(22)
                .setFrameCornerWidth(2)
                .setFrameCornerInside(false)
                .setLaserStyle(ScannerOptions.LaserStyle.RES_LINE, scanConfig.getResScanLine())//自定义图片
                .setFrameCornerColor(Color.parseColor(scanConfig.getScanHexColor()))//扫描框颜色
                .setScanFullScreen(true) //全屏扫描  -但显示扫描框
                .setFrameHide(false)  //全屏扫描  -但显示扫描框
                .setFrameCornerHide(false) //全屏扫描  -但显示扫描框
                .setLaserMoveFullScreen(false) //全屏扫描  -但显示扫描框
//                .setTipTextToFrameTop(true)
                .setMediaResId(R.raw.beep)
                .setTipText(getResources().getString(scanConfig.getResTextScanDesc()))
                .setTipTextSize(16)
                .setTipTextColor(getResources().getColor(R.color.color_gray));
        return builder;
    }


    @Override
    protected void finishThis() {
        closeLight();

        Intent intent = getIntent();
        intent.putExtra("result", getScanResultJson());
        setResult(RESULT_OK, intent);

        super.finishThis();
    }

    private void closeLight() {
        toggleButton.setChecked(false);
        toggleButton.setBackgroundDrawable(getResources().getDrawable(scanConfig.getResFlashlightOff()));
        mScannerView.toggleLight(false);
    }


    @Override
    protected ImageView getIvBack() {
        return findViewById(R.id.iv_back_hd);
    }

    @Override
    protected void initEventAndData() {


        toggleButton = findViewById(R.id.toggleButton_hd);

        toggleButton.setBackgroundDrawable(getResources().getDrawable(scanConfig.getResFlashlightOff()));

        toggleButton.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {

                mScannerView.toggleLight(isChecked);
                if (isChecked) {
                    buttonView.setBackgroundDrawable(getResources().getDrawable(scanConfig.getResFlashlightOn()));
                } else {
                    buttonView.setBackgroundDrawable(getResources().getDrawable(scanConfig.getResFlashlightOff()));
                }


            }
        });
    }

    @Override
    protected int getLayout() {
        return R.layout.activity_scanner_hd;
    }

    @Override
    protected ScannerView getScannerView() {
        return findViewById(R.id.scanner_view_hd);
    }


    public static void showActivityForResult(final Activity act, final int requestCode, final ScanConfig scanConfig) {

        CPermissionHelper.requestCamera(new CPermissionHelper.OnPermissionGrantedListener() {
            @Override
            public void onPermissionGranted() {
                Intent intent = new Intent(act, HDTrainScanScanActivity.class);
                intent.putExtra(EXTRA_SCAN_CONFIG, scanConfig);
                act.startActivityForResult(intent, requestCode);
            }
        }, new CPermissionHelper.OnPermissionDeniedListener() {
            @Override
            public void onPermissionDenied() {

            }
        });

    }

    public static void showActivityForResult(final Activity act, final int requestCode) {

        CPermissionHelper.requestCamera(new CPermissionHelper.OnPermissionGrantedListener() {
            @Override
            public void onPermissionGranted() {
                Intent intent = new Intent(act, HDTrainScanScanActivity.class);
                act.startActivityForResult(intent, requestCode);
            }
        }, new CPermissionHelper.OnPermissionDeniedListener() {
            @Override
            public void onPermissionDenied() {

            }
        });

    }

}
