package cn.com.startai.scansdk;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.Nullable;
import android.text.TextUtils;

import org.devio.takephoto.app.TakePhoto;
import org.devio.takephoto.app.TakePhotoActivity;
import org.devio.takephoto.compress.CompressConfig;
import org.devio.takephoto.model.CropOptions;
import org.devio.takephoto.model.LubanOptions;
import org.devio.takephoto.model.TImage;
import org.devio.takephoto.model.TResult;
import org.devio.takephoto.model.TakePhotoOptions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import cn.com.startai.common.utils.CFileUtils;
import cn.com.startai.common.utils.TAndL;
import cn.com.startai.scansdk.bean.ISizeType;
import cn.com.startai.scansdk.bean.ISourceType;
import cn.com.startai.scansdk.bean.TakePhotoConfig;

/**
 * Created by Robin on 2019/9/19.
 * 419109715@qq.com 彬影
 */
public class GetPicActivity extends TakePhotoActivity {
    TakePhotoConfig takePhotoConfig;
    public static final String EXTRA_TAKEPHOTO_CONFIG = "takePhotoConfig";


    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Intent intent = getIntent();
        takePhotoConfig = (TakePhotoConfig) intent.getSerializableExtra(EXTRA_TAKEPHOTO_CONFIG);
        TAndL.L("takePhotoConfig = " + takePhotoConfig);
        if (takePhotoConfig == null) {
            takePhotoConfig = new TakePhotoConfig();
        }
        take(getTakePhoto());

    }

    private void take(TakePhoto takePhoto) {


        String tempPathDir = takePhotoConfig.getTempPathDir();
        if (TextUtils.isEmpty(tempPathDir)) {
            tempPathDir = Environment.getExternalStorageDirectory() + "/temp";
        }
        if (!tempPathDir.endsWith("/")) {
            tempPathDir = tempPathDir + "/";
        }
        File file = new File(tempPathDir + System.currentTimeMillis() + ".jpg");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        Uri imageUri = Uri.fromFile(file);

        configCompress(takePhoto);
        configTakePhotoOption(takePhoto);

        int sourceType = takePhotoConfig.getSourceType();
        int isCrop = takePhotoConfig.getIsCrop();
        int count = takePhotoConfig.getCount();

        switch (sourceType) {
            case ISourceType.TYPE_ALBUM: //从相册
                if (count > 1) { //选多张
                    if (isCrop == 1) { //需要裁剪
                        takePhoto.onPickMultipleWithCrop(count, getCropOptions());
                    } else {
                        takePhoto.onPickMultiple(count);
                    }
                } else { //选单张
                    if (isCrop == 1) { //需要裁剪
                        takePhoto.onPickFromGalleryWithCrop(imageUri, getCropOptions());
                    } else {
                        takePhoto.onPickFromGallery();
                    }
                }
                break;
            case ISourceType.TYPE_CAMERA:  //拍照
                if (isCrop == 1) { //需要裁剪
                    takePhoto.onPickFromCaptureWithCrop(imageUri, getCropOptions());
                } else {
                    takePhoto.onPickFromCapture(imageUri);
                }
                break;
            default:
                break;
        }

    }

    private CropOptions getCropOptions() {
        int isCrop = takePhotoConfig.getIsCrop();
        if (isCrop == 0) {
            return null;
        }

        int height = 800;
        int width = 800;
        boolean withWonCrop = true;
        CropOptions.Builder builder = new CropOptions.Builder()
                .setOutputX(width)
                .setOutputY(height)
                .setWithOwnCrop(withWonCrop);

        return builder.create();
    }


    private void configTakePhotoOption(TakePhoto takePhoto) {
        TakePhotoOptions.Builder builder = new TakePhotoOptions.Builder();
        builder.setWithOwnGallery(true); //从tokephoto自带相册选择图片
        builder.setCorrectImage(false);//纠正拍照的照片旋转角度
        takePhoto.setTakePhotoOptions(builder.create());
    }

    private void configCompress(TakePhoto takePhoto) {
        int sizeType = takePhotoConfig.getSizeType();
        if (sizeType == ISizeType.TYPE_ORIGINAL) {
            takePhoto.onEnableCompress(null, false);
            return;
        }

        int maxSize = 512 * 1024;// 512K
        int width = 800;
        int height = 800;
        boolean showProgressBar = false;
        boolean enableRawFile = true;
        CompressConfig config;
        config = new CompressConfig.Builder().setMaxSize(maxSize)
                .setMaxPixel(width >= height ? width : height)
                .enableReserveRaw(enableRawFile)
                .create();
        takePhoto.onEnableCompress(config, showProgressBar);
    }


    @Override
    public void takeSuccess(TResult result) {
        super.takeSuccess(result);

        ArrayList<TImage> images = result.getImages();
        List<TakePhotoConfig.FileBean> files = new ArrayList<>();
        for (TImage tImage : images) {
            TAndL.L("images = " + tImage.getCompressPath() + " " + tImage.getOriginalPath());
            String path;
            if (takePhotoConfig.getSizeType() == ISizeType.TYPE_COMPRESSED) {
                path = tImage.getCompressPath();
            } else {
                path = tImage.getOriginalPath();
            }
            files.add(new TakePhotoConfig.FileBean(path, CFileUtils.getFileLength(path)));
        }
        takePhotoConfig.setFiles(files);
        finish();
    }

    @Override
    public void takeFail(TResult result, String msg) {
        super.takeFail(result, msg);
        finish();
    }

    @Override
    public void takeCancel() {
        super.takeCancel();
        finish();
    }


    @Override
    public void finish() {

        Intent intent = getIntent();
        intent.putExtra("result", takePhotoConfig);
        setResult(RESULT_OK, intent);
        super.finish();
    }
}
