package cn.com.startai.scansdk;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ToggleButton;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.oned.CodaBarReader;
import com.mylhyl.zxing.scanner.OnScannerCompletionListener;
import com.mylhyl.zxing.scanner.ScannerOptions;
import com.mylhyl.zxing.scanner.ScannerView;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import cn.com.startai.common.CommonSDKInterface;
import cn.com.startai.common.utils.CBarUtils;
import cn.com.startai.common.utils.CLog;
import cn.com.startai.common.utils.CScreenUtils;
import cn.com.startai.common.utils.TAndL;
import cn.com.startai.common.utils.permission.CPermissionHelper;
import cn.com.startai.scansdk.bean.ICodeType;
import cn.com.startai.scansdk.bean.ResultBean;


/**
 * Created by Robin on 2018/3/1.
 * qq: 419109715 彬影
 */

public class CommonScanActivity extends AppCompatActivity implements OnScannerCompletionListener {
    public static final String EXTRA_SCAN_CONFIG = "scanConfig";
    private ToggleButton mToggleButton;
    protected List<ResultBean> mScanResultList = new ArrayList<>();
    ;
    protected ScannerView mScannerView;
    protected ScanConfig mScanConfig;
    protected Toolbar mToolbar;
    private String mScanResult;
    private String TAG = CommonSDKInterface.TAG;
    protected AlertDialog mAlertDialog;
    private TextView mTvTitle;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        CLog.d(TAG, "CommonScanActivity onCreate");
        setContentView(R.layout.activity_scanner_common);
        initIntentData();
        initViewAndData();

    }

    private void initIntentData() {
        Intent intent = getIntent();
        mScanConfig = (ScanConfig) intent.getSerializableExtra(EXTRA_SCAN_CONFIG);
        CLog.d(TAG, "mScanConfig = " + mScanConfig);
        if (mScanConfig == null) {
            mScanConfig = new ScanConfig.Builder().build();
        }
    }

    protected void showCameraInitFailedDialog() {
        if (mAlertDialog == null) {
            mAlertDialog = new AlertDialog.Builder(this).create();
        } else {
            if (mAlertDialog.isShowing()) {
                mAlertDialog.dismiss();
            }
        }
        mAlertDialog.setMessage(getResources().getString(R.string.camera_init_failed));
        mAlertDialog.show();
    }


    @Override
    protected void onResume() {
        try {
            mScannerView.onResume();
        } catch (Exception e) {
            e.printStackTrace();
            Log.e(TAG, "camera init failed");
            showCameraInitFailedDialog();
        }

        super.onResume();
    }

    @Override
    protected void onPause() {
        try {
            mScannerView.onPause();
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onPause();
    }


    private void initViewAndData() {


        mToolbar = findViewById(R.id.tb_scanner_common);
        mToolbar.setTitle("");
        setSupportActionBar(mToolbar);
        mToolbar.setBackgroundColor(getResources().getColor(android.R.color.transparent));
        mToolbar.setNavigationIcon(mScanConfig.getResBackIcon());
        mToolbar.setNavigationOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finishThis();
            }
        });

        mTvTitle = findViewById(R.id.tv_common_title);
        mTvTitle.setText(mScanConfig.getResTitleText());
        mTvTitle.setTextColor(getResources().getColor(mScanConfig.getResTitleTextColor()));

        mScannerView = findViewById(R.id.scanner_view_common);
        mScannerView.setOnScannerCompletionListener(this);
        mScannerView.setScannerOptions(getScanBuilder().build());

        mToggleButton = findViewById(R.id.tgb_common);

        mToggleButton.setBackgroundDrawable(getResources().getDrawable(mScanConfig.getResFlashlightOff()));

        mToggleButton.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {

                mScannerView.toggleLight(isChecked);
                if (isChecked) {
                    buttonView.setBackgroundDrawable(getResources().getDrawable(mScanConfig.getResFlashlightOn()));
                } else {
                    buttonView.setBackgroundDrawable(getResources().getDrawable(mScanConfig.getResFlashlightOff()));
                }


            }
        });
    }

    protected ScannerOptions.Builder getScanBuilder() {
        ScannerOptions.Builder builder = new ScannerOptions.Builder();
        builder.setFrameSize(256, 256)
                .setFrameCornerLength(22)
                .setFrameCornerWidth(2)
                .setFrameCornerInside(false)
                .setLaserStyle(ScannerOptions.LaserStyle.RES_LINE, mScanConfig.getResScanLine())//自定义图片
                .setFrameCornerColor(getResources().getColor(mScanConfig.getResScanColor()))//扫描框颜色
                .setScanFullScreen(true) //全屏扫描  -但显示扫描框
                .setFrameHide(false)  //全屏扫描  -但显示扫描框
                .setFrameCornerHide(false) //全屏扫描  -但显示扫描框
                .setLaserMoveFullScreen(false) //全屏扫描  -但显示扫描框
//                .setTipTextToFrameTop(true)
                .setMediaResId(R.raw.beep)
                .setTipText(getResources().getString(mScanConfig.getResTextScanDesc()))
                .setTipTextSize(16)
                .setTipTextColor(getResources().getColor(mScanConfig.getResTextScanDescColor()));
        return builder;
    }

    @Override
    public void onBackPressed() {
        finishThis();
    }

    protected void finishThis() {
        closeLight();
        Intent intent = getIntent();
        intent.putExtra("result", getScanResultJson());
        setResult(RESULT_OK, intent);
        finish();
    }

    private void closeLight() {
        mToggleButton.setChecked(false);
        mToggleButton.setBackgroundDrawable(getResources().getDrawable(mScanConfig.getResFlashlightOff()));
        mScannerView.toggleLight(false);
    }


    public static void showActivityForResult(final Activity act, final int requestCode, final ScanConfig scanConfig) {

        CPermissionHelper.requestCamera(new CPermissionHelper.OnPermissionGrantedListener() {
            @Override
            public void onPermissionGranted() {
                Intent intent = new Intent(act, CommonScanActivity.class);
                intent.putExtra(EXTRA_SCAN_CONFIG, scanConfig);
                act.startActivityForResult(intent, requestCode);
            }
        }, new CPermissionHelper.OnPermissionDeniedListener() {
            @Override
            public void onPermissionDenied() {

            }
        });

    }

    public static void showActivityForResult(final Activity act, final int requestCode) {

        CPermissionHelper.requestCamera(new CPermissionHelper.OnPermissionGrantedListener() {
            @Override
            public void onPermissionGranted() {
                Intent intent = new Intent(act, CommonScanActivity.class);
                act.startActivityForResult(intent, requestCode);
            }
        }, new CPermissionHelper.OnPermissionDeniedListener() {
            @Override
            public void onPermissionDenied() {

            }
        });

    }

    @Override
    public void onScannerCompletion(Result rawResult, ParsedResult parsedResult, Bitmap barcode) {

        if (rawResult == null) {
            Toast.makeText(this, "no result", Toast.LENGTH_SHORT).show();
            finish();
            return;
        }
        mScanResult = rawResult.getText();
        Log.i(TAG, "  scanResult = " + mScanResult);

        int codeType = ICodeType.TYPE_ONE;
        if (rawResult.getBarcodeFormat() == BarcodeFormat.QR_CODE) {
            codeType = ICodeType.TYPE_TWO;
        }

        if (mScanConfig.getScanType() == 1) { //单次扫描

            Intent intent = getIntent();
            intent.putExtra("result", mScanResult);
            setResult(RESULT_OK, intent);

            mScanResultList.add(new ResultBean(codeType, mScanResult, 1));

            finishThis();

        } else { //多次扫描


            boolean isContains = false;

            for (ResultBean scanResultBean : mScanResultList) {
                if (mScanResult.equals(scanResultBean.getData())) {
                    int count = scanResultBean.getCount();
                    scanResultBean.setCount(++count);
                    isContains = true;
                    break;
                }
            }

            if (!isContains) {
                mScanResultList.add(new ResultBean(codeType, mScanResult, 1));
            }

            restartPreviewAfterDelay(mScanConfig.getScanPeroid());

        }

    }

    protected String getScanResultJson() {

        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = null;
        for (ResultBean bean : mScanResultList) {
            try {
                jsonObject = new JSONObject();
                jsonObject.put("data", bean.getData());
                jsonObject.put("codeType", bean.getCodeType());
                jsonObject.put("count", bean.getCount());
            } catch (JSONException e) {
                e.printStackTrace();
            }
            jsonArray.put(jsonObject);
        }
        return jsonArray.toString();
    }

    private void restartPreviewAfterDelay(long delayMS) {
        mScannerView.restartPreviewAfterDelay(delayMS);
    }

}
