package cn.com.startai.scansdk;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.util.Log;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.ToggleButton;

import com.google.zxing.BarcodeFormat;
import com.mylhyl.zxing.scanner.ScannerOptions;
import com.mylhyl.zxing.scanner.ScannerView;

import cn.com.startai.common.utils.permission.CPermissionHelper;


/**
 * Created by Robin on 2018/3/1.
 * qq: 419109715 彬影
 */

public class ChargerScanScanActivity extends BaseScanActivity {

    private ToggleButton toggleButton;

    @Override
    protected ScannerOptions.Builder getScanBuilder() {
        ScannerOptions.Builder builder = new ScannerOptions.Builder();
        builder.setFrameSize(256, 256)
                .setFrameCornerLength(22)
                .setFrameCornerWidth(2)
                .setFrameCornerInside(false)
                .setLaserStyle(ScannerOptions.LaserStyle.RES_LINE, scanConfig.getResScanLine())
                .setFrameCornerColor(Color.parseColor(scanConfig.getScanHexColor()))//扫描框颜色
                .setScanFullScreen(false)
                .setFrameHide(true) //扫描框边线
                .setTipTextToFrameTop(true)
                .setMediaResId(R.raw.baidu_beep)
                .setTipText(getString(R.string.please_scan))
                .setTipTextSize(16)
                .setScanMode(BarcodeFormat.QR_CODE)
                .setTipTextColor(getResources().getColor(R.color.color_gray));

        return builder;
    }


    private void closeLight() {
        toggleButton.setChecked(false);
        toggleButton.setBackgroundDrawable(getResources().getDrawable(scanConfig.getResFlashlightOff()));
        mScannerView.toggleLight(false);
    }

    @Override
    protected ImageView getIvBack() {
        return findViewById(R.id.iv_back_charger);
    }

    @Override
    public void finish() {
        closeLight();
        super.finish();
    }

    @Override
    protected void initEventAndData() {

        toggleButton = (ToggleButton) findViewById(R.id.toggleButton_charger);

        toggleButton.setBackgroundDrawable(getResources().getDrawable(scanConfig.getResFlashlightOff()));


        toggleButton.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {

                mScannerView.toggleLight(isChecked);
                if (isChecked) {
                    buttonView.setBackgroundDrawable(getResources().getDrawable(scanConfig.getResFlashlightOn()));
                } else {
                    buttonView.setBackgroundDrawable(getResources().getDrawable(scanConfig.getResFlashlightOff()));
                }


            }
        });


    }

    @Override
    protected int getLayout() {
        return R.layout.activity_scanner_charger;
    }

    @Override
    protected ScannerView getScannerView() {
        return findViewById(R.id.scanner_view_charger);
    }

    public static void showActivityForResult(final Activity act, final int requestCode, final ScanConfig scanConfig) {

        CPermissionHelper.requestCamera(new CPermissionHelper.OnPermissionGrantedListener() {
            @Override
            public void onPermissionGranted() {
                Intent intent = new Intent(act, ChargerScanScanActivity.class);
                intent.putExtra(EXTRA_SCAN_CONFIG, scanConfig);
                act.startActivityForResult(intent, requestCode);
            }
        }, new CPermissionHelper.OnPermissionDeniedListener() {
            @Override
            public void onPermissionDenied() {

            }
        });

    }

    public static void showActivityForResult(final Activity act, final int requestCode) {

        CPermissionHelper.requestCamera(new CPermissionHelper.OnPermissionGrantedListener() {
            @Override
            public void onPermissionGranted() {
                Intent intent = new Intent(act, ChargerScanScanActivity.class);
                act.startActivityForResult(intent, requestCode);
            }
        }, new CPermissionHelper.OnPermissionDeniedListener() {
            @Override
            public void onPermissionDenied() {

            }
        });

    }

}
