package cn.com.startai.scansdk;

import android.app.Activity;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.Toast;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.google.zxing.client.result.ParsedResult;
import com.mylhyl.zxing.scanner.OnScannerCompletionListener;
import com.mylhyl.zxing.scanner.ScannerOptions;
import com.mylhyl.zxing.scanner.ScannerView;
import com.mylhyl.zxing.scanner.decode.QRDecode;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import cn.com.startai.scansdk.bean.ICodeType;
import cn.com.startai.scansdk.bean.ResultBean;

/**
 * Created by Robin on 2019/4/3.
 * 419109715@qq.com 彬影
 */
public abstract class BaseScanActivity extends AppCompatActivity implements OnScannerCompletionListener {

    public static final String EXTRA_SCAN_CONFIG = "scanConfig";

    protected ScanConfig scanConfig;
    protected AlertDialog alertDialog;
    protected String TAG = "scan";
    protected ScannerView mScannerView;

    protected String scanResult;
    protected List<ResultBean> scanResultList;


    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(getLayout());

        scanResult = "";
        scanResultList = new ArrayList<>();

        Intent intent = getIntent();
        scanConfig = (ScanConfig) intent.getSerializableExtra(EXTRA_SCAN_CONFIG);
        if (scanConfig == null) {
            scanConfig = new ScanConfig();
        }

        Log.i(TAG, "oncreate()");

        ImageView ivBack = getIvBack();
        ivBack.setImageResource(scanConfig.getResBackIcon());
        ivBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finishThis();
            }
        });

        mScannerView = getScannerView();
        mScannerView.setOnScannerCompletionListener(this);

        mScannerView.setScannerOptions(getScanBuilder().build());

        initEventAndData();
    }

    protected void finishThis() {

        finish();
    }

    protected abstract ScannerOptions.Builder getScanBuilder();

    @Override
    public void onBackPressed() {
        finishThis();
    }

    @Override
    protected void onResume() {
        try {

            mScannerView.onResume();
        } catch (Exception e) {
            e.printStackTrace();
            Log.e(TAG, "camera init failed");
            showCameraInitFailedDialog();
        }

        super.onResume();
    }

    @Override
    protected void onPause() {
        try {
            mScannerView.onPause();
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onPause();
    }

    private void restartPreviewAfterDelay(long delayMS) {
        mScannerView.restartPreviewAfterDelay(delayMS);
    }

    protected abstract ImageView getIvBack();

    protected abstract void initEventAndData();

    protected abstract int getLayout();

    protected abstract ScannerView getScannerView();

    protected void showCameraInitFailedDialog() {
        if (alertDialog == null) {
            alertDialog = new AlertDialog.Builder(this).create();
        } else {
            if (alertDialog.isShowing()) {
                alertDialog.dismiss();
            }
        }
        alertDialog.setMessage(getResources().getString(R.string.camera_init_failed));
        alertDialog.show();
    }


    /**
     * 选择完相册图片返回
     *
     * @param requestCode
     * @param resultCode
     * @param data
     */
    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode != Activity.RESULT_CANCELED && resultCode == Activity.RESULT_OK) {
            if (requestCode == 1) {
                String photo_path = "";
                String[] proj = {MediaStore.Images.Media.DATA};
                // 获取选中图片的路径
                Cursor cursor = getContentResolver().query(data.getData(), proj, null,
                        null, null);

                if (cursor.moveToFirst()) {

                    int column_index = cursor
                            .getColumnIndexOrThrow(MediaStore.Images.Media.DATA);
                    photo_path = cursor.getString(column_index);
                    if (photo_path == null) {
                        photo_path = Utils.getPath(getApplicationContext(),
                                data.getData());
                        Log.i("123path  Utils", photo_path);
                    }
                    Log.i("123path", photo_path);

                }
                cursor.close();

                QRDecode.decodeQR(photo_path, this);
            }
        }
    }


    /**
     * 从相册选择二维码图片
     */
    protected void chooseFromAlbum() {

        Intent innerIntent = new Intent(); // "android.intent.action.GET_CONTENT"
        // 在android 4.4 以后的系统版本中 打开系统相册的意图有改动，此处要作判断
        if (Build.VERSION.SDK_INT < 19) {
            innerIntent.setAction(Intent.ACTION_GET_CONTENT);
        } else {
            innerIntent.setAction(Intent.ACTION_OPEN_DOCUMENT);
        }

        innerIntent.setType("image/*");

        Intent wrapperIntent = Intent.createChooser(innerIntent, "选择二维码图片");

        startActivityForResult(wrapperIntent, 1);

    }


    @Override
    public void onScannerCompletion(Result rawResult, ParsedResult parsedResult, Bitmap barcode) {

        if (rawResult == null) {
            Toast.makeText(this, "no result", Toast.LENGTH_SHORT).show();
            finish();
            return;
        }
        scanResult = rawResult.getText();
        Log.i(TAG, "  scanResult = " + scanResult);

        int codeType = ICodeType.TYPE_ONE;
        if (rawResult.getBarcodeFormat() == BarcodeFormat.QR_CODE) {
            codeType = ICodeType.TYPE_TWO;
        }

        if (scanConfig.getScanType() == 1) { //单次扫描

            Intent intent = getIntent();
            intent.putExtra("result", scanResult);
            setResult(RESULT_OK, intent);

            scanResultList.add(new ResultBean(codeType, scanResult, 1));

            finishThis();

        } else { //多次扫描



            boolean isContains = false;

            for (ResultBean scanResultBean : scanResultList) {
                if (scanResult.equals(scanResultBean.getData())) {
                    int count = scanResultBean.getCount();
                    scanResultBean.setCount(++count);
                    isContains = true;
                    break;
                }
            }

            if (!isContains) {
                scanResultList.add(new ResultBean(codeType, scanResult, 1));
            }

            restartPreviewAfterDelay(scanConfig.getScanPeroid());

        }

    }

    protected String getScanResultJson() {

        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = null;
        for (ResultBean bean : scanResultList) {
            try {
                jsonObject = new JSONObject();
                jsonObject.put("data", bean.getData());
                jsonObject.put("codeType", bean.getCodeType());
                jsonObject.put("count", bean.getCount());
            } catch (JSONException e) {
                e.printStackTrace();
            }
            jsonArray.put(jsonObject);
        }
        return jsonArray.toString();
    }

}
