package cn.com.startai.qxcommon.utils.location;


import android.text.TextUtils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.ScheduledExecutorService;

import cn.com.startai.common.utils.CLog;
import cn.com.startai.common.utils.CThreadPoolUtils;
import cn.com.startai.qxcommon.utils.gson.QXJsonUtils;
import cn.com.startai.qxcommon.utils.QXSpController;

import static cn.com.startai.qxcommon.QXCommon.TAG;

/**
 * Created by Robin on 2019/4/1.
 * 419109715@qq.com 彬影
 */
public class QXLocationManager {

    public static final String url = "http://ip-api.com/json/";

    private AreaLocation location;

    private static QXLocationManager instance;

    public static QXLocationManager getInstance() {
        if (instance == null) {
            instance = new QXLocationManager();
        }
        return instance;
    }


    private QXLocationManager() {

    }


    public synchronized void getLocation(final LocationCallback callback) {
        if (location != null) {
            CLog.d(TAG, "get location by cache");
            callback.onLocationSuccess(location);
        } else {

            location = QXSpController.getInstance().getLocation();
            if (location != null) {
                CLog.d(TAG, "get location by sp");
                callback.onLocationSuccess(location);
            } else {
                CLog.d(TAG, "get location by api");
                getLocationByApi(callback);
            }
        }
    }


    private void getLocationByApi(final LocationCallback callback) {
        ScheduledExecutorService threadPool = CThreadPoolUtils.getInstance().getWorkThreadPool();
        if (threadPool != null) {
            threadPool.execute(new Runnable() {
                @Override
                public void run() {
                    InputStream inStream = null;
                    HttpURLConnection httpConnection = null;
                    BufferedReader reader = null;

                    try {
                        URL infoUrl = new URL(url);
                        URLConnection urlConnection = infoUrl.openConnection();
                        urlConnection.setConnectTimeout(4000);
                        urlConnection.setReadTimeout(4000);
                        httpConnection = (HttpURLConnection) urlConnection;

                        int responseCode = httpConnection.getResponseCode();
                        if (responseCode != 200) {
                            callback.onLocationFailed();
                            return;
                        }

                        inStream = httpConnection.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(inStream, "utf-8"));
                        StringBuilder strber = new StringBuilder();
                        String line;

                        while ((line = reader.readLine()) != null) {
                            strber.append(line + "\n");
                        }
                        inStream.close();

                        CLog.d(TAG, "LBS result = " + strber.toString());
                        if (!TextUtils.isEmpty(strber.toString())) {
                            location = QXJsonUtils.fromJson(strber.toString(), AreaLocation.class);
                            if (location != null) {
                                QXSpController.getInstance().setLocation(location);
                                callback.onLocationSuccess(location);
                                return;
                            }
                        }
                        callback.onLocationFailed();

                    } catch (Exception e) {
                        e.printStackTrace();
                        callback.onLocationFailed();
                    } finally {
                        try {
                            if (reader != null) {
                                reader.close();
                                reader = null;
                            }

                            if (inStream != null) {
                                inStream.close();
                                inStream = null;
                            }

                            if (httpConnection != null) {
                                httpConnection.disconnect();
                                httpConnection = null;
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                    }

                }
            });
        }
    }


    public void release() {
        CLog.d(TAG, "QXLocationManager release");
        this.location = null;
    }

    public void onNetworkChange() {
        this.location = null;
        QXSpController.getInstance().setLocation(null);
    }


    public interface LocationCallback {
        void onLocationSuccess(AreaLocation location);

        void onLocationFailed();
    }
}
