package cn.com.startai.qxcommon.utils;

import android.text.TextUtils;

import cn.com.startai.common.utils.CAppUtils;
import cn.com.startai.common.utils.CDeviceInfoUtils;
import cn.com.startai.common.utils.CLog;
import cn.com.startai.common.utils.CMD5;

import static cn.com.startai.qxcommon.QXCommon.TAG;

/**
 * Created by Robin on 2019/5/12.
 * 419109715@qq.com 彬影
 */
public class SnUtils {


    private SnUtils() {
    }

    public static SnUtils getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }


    private static class SingleTonHoulder {
        private static final SnUtils singleTonInstance = new SnUtils();
    }


    private long sn;

    /**
     * 获取sn
     *
     * @return
     */
    public long getSn() {

        if (sn == 0) {
            sn = QXSpController.getInstance().getSn();
            if (sn == 0) {
                String str = "";
                String mac = CDeviceInfoUtils.getMAC();
                if (TextUtils.isEmpty(mac)) {
                    String androidId = CDeviceInfoUtils.getAndroidID();
                    String serial = CDeviceInfoUtils.getCpuSerial();//cpu序列号
                    str = androidId + serial;
                } else {
                    str = mac;
                }

                sn = getQXEncodeHash(str + CAppUtils.getAppPackageName());
                QXSpController.getInstance().setSn(sn);
            }
            CLog.d(TAG, "sn = " + sn);
        }

        return sn;
    }


    public long getQXEncodeHash(String oriString) {

        long hash = oriString.hashCode();

        hash = getUnSignNum(hash);

        char[] chars = oriString.toCharArray();
        long oriStrChar = 0;
        for (char c : chars) {
            oriStrChar += c;
        }
        long l = Long.parseLong(oriStrChar + "" + hash);
        return l;
    }

    public long getUnSignNum(long num) {
        if (num < 0) {
            num = (num << 32) >>> 32;
        }
        return num;
    }
}
