package cn.com.startai.qxcommon.protocol;

import android.os.Build;

import cn.com.startai.common.utils.CDeviceInfoUtils;
import cn.com.startai.common.utils.CLog;
import cn.com.startai.qxcommon.global.ParamManager;
import cn.com.startai.qxcommon.link.BaseData;
import cn.com.startai.qxcommon.link.mqtt.TopicManager;
import cn.com.startai.qxcommon.link.mqtt.busi.bean.ActivateReq;
import cn.com.startai.qxcommon.link.mqtt.busi.bean.GetBrokerHostReq;
import cn.com.startai.qxcommon.link.mqtt.busi.bean.UpdateDeviceInfoReq;
import cn.com.startai.qxcommon.utils.gson.QXJsonUtils;

import static cn.com.startai.qxcommon.QXCommon.TAG;


/**
 * Created by Robin on 2019/3/25.
 * 419109715@qq.com 彬影
 */
public class QXDataCreater {



    protected static void logParamEmpty(String param) {
        CLog.e(TAG, "send failed : ' " + param + " ' is emtpy");
    }

    public static BaseData getCloudBaseData(QXMessage qxMessage) {

        String s = QXJsonUtils.toJson(qxMessage);
        BaseData data = new BaseData.Builder()
                .topicCloud()
                .channelMqtt()
                .data(s.getBytes())
                .build();
        return data;

    }

    public static BaseData getThirdCloudBaseData(QXMessage qxMessage) {
        String s = QXJsonUtils.toJson(qxMessage);
        BaseData data = new BaseData.Builder()
                .topicThirdCloud()
                .channelMqtt()
                .data(s.getBytes())
                .build();
        return data;
    }

    public static BaseData getClientBaseData(QXMessage qxMessage) {
        String s = QXJsonUtils.toJson(qxMessage);
        BaseData data = new BaseData.Builder()
                .topicClient(qxMessage.getTo())
                .channelMqtt()
                .data(s.getBytes())
                .build();
        return data;
    }

    public static QXMessage getApp2Cloud2ThirdCloudSetQXMsg(int session, boolean isDistribute, QXBaseContent baseContent) {
        return getQXMessage(IDeveloper.MsgTw.TW_APP_CLOUD_THIRDCLOUD_SET, session, isDistribute, ParamManager.getInstance().getThirdCloudAppid(), baseContent);
    }

    public static QXMessage getAPP2Cloud2ThirdCloudQueryQXMsg(int session, boolean isDistribute, QXBaseContent baseContent) {
        return getQXMessage(IDeveloper.MsgTw.TW_APP_CLOUD_THIRDCLOUD_QUERY, session, isDistribute, ParamManager.getInstance().getThirdCloudAppid(), baseContent);
    }

    public static QXMessage getAPP2Cloud2ThirdCloudReportQXMsg(int session, boolean isDistribute, QXBaseContent baseContent) {
        return getQXMessage(IDeveloper.MsgTw.TW_APP_CLOUD_THIRDCLOUD_REPORT, session, isDistribute, ParamManager.getInstance().getThirdCloudAppid(), baseContent);
    }

    public static QXMessage getApp2CloudSetQXMsg(int session, boolean isDistribute, QXBaseContent baseContent) {
        return getQXMessage(IDeveloper.MsgTw.TW_APP_CLOUD_SET, session, isDistribute, ParamManager.getInstance().getTagToService(), baseContent);
    }

    public static QXMessage getAPP2CloudQueryQXMsg(int session, boolean isDistribute, QXBaseContent baseContent) {
        return getQXMessage(IDeveloper.MsgTw.TW_APP_CLOUD_QUERY, session, isDistribute, ParamManager.getInstance().getTagToService(), baseContent);
    }

    public static QXMessage getAPP2CloudReportQXMsg(int session, boolean isDistribute, QXBaseContent baseContent) {
        return getQXMessage(IDeveloper.MsgTw.TW_APP_CLOUD_REPORT, session, isDistribute, ParamManager.getInstance().getTagToService(), baseContent);
    }

    public static QXMessage getAppSetQXMsg(int session, QXBaseContent baseContent) {
        return getQXMessage(IDeveloper.MsgTw.TW_APP_SET, session, false, ParamManager.getInstance().getSn(), baseContent);
    }

    public static QXMessage getAppQueryQXMsg(int session, QXBaseContent baseContent) {
        return getQXMessage(IDeveloper.MsgTw.TW_APP_QUERY, session, false, ParamManager.getInstance().getSn(), baseContent);
    }

    public static QXMessage getAppReportQXMsg(int session, QXBaseContent baseContent) {
        return getQXMessage(IDeveloper.MsgTw.TW_APP_REPORT, session, false, ParamManager.getInstance().getSn(), baseContent);
    }


    public static QXMessage getQXMessage(int msgtw, int session, boolean isDistribute, long to, QXBaseContent baseContent) {

        long from;
        if (isDistribute) {
            from = ParamManager.getInstance().getUserId();
        } else {
            from = ParamManager.getInstance().getSn();
        }
        if (from == 0) {
            from = ParamManager.getInstance().getSn();
        }

        baseContent.setProduct(ParamManager.getInstance().getProduct());
        baseContent.setCustom(ParamManager.getInstance().getCustom());

        QXMessage qxMessage = new QXMessage().new Builder()
                .ver(IDeveloper.Ver.VER_2)
                .msgtw(msgtw)
                .session(session)
                .ts(System.currentTimeMillis())
                .to(to)
                .from(from)
                .appid(ParamManager.getInstance().getAppid())
                .content(baseContent)
                .build();
        return qxMessage;
    }

    public static QXMessage<GetBrokerHostReq> getBrokerHostQXMsg(GetBrokerHostReq req) {
        return getQXMessage(IDeveloper.MsgTw.TW_APP_CLOUD_SET, 0, false, ParamManager.getInstance().getTagToService(), req);
    }

    public static QXMessage<UpdateDeviceInfoReq> getUpdateDeviceInfoQXMsg(UpdateDeviceInfoReq req) {
        return getQXMessage(IDeveloper.MsgTw.TW_APP_CLOUD_SET, 0, false, ParamManager.getInstance().getTagToService(), req);
    }


    public static QXMessage<ActivateReq> getActivateQXMsg(ActivateReq req) {
        if (req == null) {
            req = new ActivateReq();
            req.setAppid(ParamManager.getInstance().getAppid());
            req.setClientid(ParamManager.getInstance().getSn() + "");
            req.setSn(ParamManager.getInstance().getSn());
            ActivateReq.FirmwareParamBean firmwareParamBean = new ActivateReq.FirmwareParamBean();
            firmwareParamBean.setImei(CDeviceInfoUtils.getImei());
            firmwareParamBean.setFirmwareVersion(CDeviceInfoUtils.getFirmwareVersion());
            firmwareParamBean.setINetMac(CDeviceInfoUtils.getEthernetMacFromFile());
            firmwareParamBean.setWifiMac(CDeviceInfoUtils.getWifiMac());
            firmwareParamBean.setScreenSize(CDeviceInfoUtils.getScreenSize());
            firmwareParamBean.setSysVersion(CDeviceInfoUtils.getSysVersion());
            firmwareParamBean.setProduct(Build.PRODUCT);
            firmwareParamBean.setCpuSerial(CDeviceInfoUtils.getCpuSerial());
            firmwareParamBean.setAndroidId(CDeviceInfoUtils.getAndroidID());
            firmwareParamBean.setBluetoothMac(CDeviceInfoUtils.getBluetoothMac());
            firmwareParamBean.setModelNumber(CDeviceInfoUtils.getModel());
            req.setFirmwareParam(firmwareParamBean);
        } else {
            if (req.getActivateType() == 0) {
                req.setActivateType(2);
            }
        }
        return getQXMessage(IDeveloper.MsgTw.TW_APP_CLOUD_SET, 0, false, ParamManager.getInstance().getTagToService(), req);

    }


}
