package cn.com.startai.qxcommon.event;

import java.util.ArrayList;
import java.util.List;

import cn.com.startai.qxcommon.link.BaseData;

/**
 * Created by Robin on 2019/5/12.
 * 419109715@qq.com 彬影
 */
public class QXEventDispatcher implements IQXCommonListener {


    private QXEventDispatcher() {
    }

    public static QXEventDispatcher getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }


    private static class SingleTonHoulder {
        private static final QXEventDispatcher singleTonInstance = new QXEventDispatcher();
    }


    private List<IQXCommonListener> commonListeners = new ArrayList<>();

    public void addQXCommonListener(IQXCommonListener listener) {
        if (listener != null && !commonListeners.contains(listener)) {
            commonListeners.add(listener);
        }
    }

    public void removeQXCommonListener(IQXCommonListener listener) {
        if (listener != null && commonListeners.contains(listener)) {
            commonListeners.remove(listener);
        }
    }

    public void clearAll() {
        commonListeners.clear();
    }


//    @Override
//    public void onInitSuccess(HDInitResp initCtnResp) {
//        for (IQXCommonListener listener : commonListeners) {
//            listener.onInitSuccess(initCtnResp);
//        }
//    }

    @Override
    public void onServerConnected(String host) {
        for (IQXCommonListener listener : commonListeners) {
            listener.onServerConnected(host);
        }
    }

    @Override
    public void onServerDisconnected(int errorCode) {
        for (IQXCommonListener listener : commonListeners) {
            listener.onServerDisconnected(errorCode);
        }
    }

    @Override
    public void onMessageArrived(BaseData baseData) {
        for (IQXCommonListener listener : commonListeners) {
            listener.onMessageArrived(baseData);
        }
    }

}
