package cn.com.startai.qxcommon.busi.qx;

import android.app.Application;
import android.content.Intent;
import android.net.NetworkInfo;
import android.text.TextUtils;

import java.util.List;

import cn.com.startai.common.channel.CErrorCode;
import cn.com.startai.common.channel.ICallListener;
import cn.com.startai.common.channel.mqtt.MqttConnectState;
import cn.com.startai.common.utils.CActivityUtils;
import cn.com.startai.common.utils.CLog;
import cn.com.startai.common.utils.CUtils;
import cn.com.startai.common.utils.TAndL;
import cn.com.startai.common.utils.network.CNetworkManager;
import cn.com.startai.common.utils.permission.CPermissionHelper;
import cn.com.startai.qxcommon.QXCommonInitParam;
import cn.com.startai.qxcommon.R;
import cn.com.startai.qxcommon.busi.CommonBusi;
import cn.com.startai.qxcommon.busi.qx.bean.QXCameraCodeScanReq;
import cn.com.startai.qxcommon.busi.qx.bean.QXCameraCodeScanResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDInitReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDLogoutResp;
import cn.com.startai.qxcommon.busi.qx.bean.QXNetworkStateResp;
import cn.com.startai.qxcommon.busi.qx.bean.QXServerConnectStateResp;
import cn.com.startai.qxcommon.busi.qx.bean.QXTakePhotoReq;
import cn.com.startai.qxcommon.busi.qx.bean.QXTakePhotoResp;
import cn.com.startai.qxcommon.busi.qx.file.QXFileDirManager;
import cn.com.startai.qxcommon.db.UserBean;
import cn.com.startai.qxcommon.global.DeveloperParam;
import cn.com.startai.qxcommon.global.ParamManager;
import cn.com.startai.qxcommon.global.QXUserManager;
import cn.com.startai.qxcommon.link.BaseData;
import cn.com.startai.qxcommon.link.mqtt.QXMqttManager;
import cn.com.startai.qxcommon.link.mqtt.TopicManager;
import cn.com.startai.qxcommon.protocol.IDeveloper;
import cn.com.startai.qxcommon.protocol.QXMessage;
import cn.com.startai.qxcommon.protocol.QXMessageConverter;
import cn.com.startai.qxcommon.utils.QXSpController;
import cn.com.startai.qxcommon.utils.gson.QXJsonUtils;
import cn.com.startai.scansdk.BaseScanActivity;
import cn.com.startai.scansdk.GetPicActivity;
import cn.com.startai.scansdk.HDTrainScanScanActivity;
import cn.com.startai.scansdk.ScanConfig;
import cn.com.startai.scansdk.bean.ResultBean;
import cn.com.startai.scansdk.bean.TakePhotoConfig;

import static cn.com.startai.qxcommon.QXCommon.TAG;

/**
 * Created by Robin on 2019/5/23.
 * 419109715@qq.com 彬影
 */
public class QX extends CommonBusi implements IQXBusi, IDeveloper.MsgTw, QXCmd {

    private boolean hasCallbackInit;

    public boolean isHasCallbackInit() {
        return hasCallbackInit;
    }

    public void setHasCallbackInit(boolean hasCallbackInit) {
        this.hasCallbackInit = hasCallbackInit;
    }

    public QX() {
        hasCallbackInit = false;
    }

    protected AQXBusiListener qxBusiListener;

    public AQXBusiListener getQxBusiListener() {
        return qxBusiListener;
    }

    public void setQxBusiListener(AQXBusiListener qxBusiListener) {
        this.qxBusiListener = qxBusiListener;
        qxBusiListener.setQx(this);
    }

    @Override
    public void init(Application application, QXCommonInitParam initParam, AQXBusiListener commonListener) {
        this.qxBusiListener = commonListener;
        qxBusiListener.setQx(this);
        CNetworkManager.getInstance().addNetworkListener(qxBusiListener);
        super.init(application, initParam, qxBusiListener);
    }


    @Override
    public void release() {
        setHasCallbackInit(false);
        CNetworkManager.getInstance().removeNetworkListener(qxBusiListener);
        super.release();
        qxBusiListener.setQx(null);
        this.qxBusiListener = null;
    }

    @Override
    public synchronized void doSend(final String data) {

        CLog.d(TAG, "QX doSend data = " + data);

        if (getApplication() == null) {
            CLog.e(TAG, "please call init first");
            return;
        }
        if (data == null) {
            CLog.e(TAG, "data == null");
            return;
        }

        long cmd = QXMessageConverter.getInstance().getCmdFromJson(data);
        int msgtw = QXMessageConverter.getInstance().getMsgTwFromJson(data);

        if (cmd <= 0 || msgtw <= 0) {
            CLog.e(TAG, "error msg : " + cmd);
            if (qxBusiListener != null) {
                qxBusiListener.onSendFailed(data, CErrorCode.ERROR_SEND_PARAM_INVALIBLE);
            }
            return;

        }


        if (cmd == SDK_INIT) {

            QXMessage<HDInitReq> qxMessage = QXJsonUtils.fromJsonToQXMessage(data, HDInitReq.class);
            init(getApplication(), new QXCommonInitParam.Builder().appid(qxMessage.getContent().getAppid()).build(), qxBusiListener);

            if (QXSpController.getInstance().getIsActivite()) {
                if (qxBusiListener != null && !hasCallbackInit) {

                    qxMessage = QXMessageConverter.getInstance().getBackQxMsgByFromQxMsg(qxMessage);


                    DeveloperParam content = ParamManager.getInstance();
                    content.setResult(IDeveloper.Result.SUCCESS);


                    if (content.getUserId() != 0) {
                        UserBean userBean = getUserBean();
                        long userId = userBean.getUserId();
                        if (userId != 0) {
                            boolean expired = userBean.isExpired(30 * 24 * 60 * 60 * 1000L);
                            if (expired) {
                                //失效
                                CLog.e(TAG, "user login is expired ");
                                QXUserManager.getInstance().onLogout();
                                content.setUserId(0);
                            } else {
                                CLog.d(TAG, "user login is normal ");
                            }
                        }
                    }

                    qxMessage.setContent(content);
                    qxBusiListener.onQXMessageArrived(qxMessage.toJson());
                    hasCallbackInit = true;
                }
            }


        } else if (cmd == SDK_RELEASE) {
            release();
        } else if (cmd == SDK_LOGOUT) {
            logout();

            QXMessage<HDLogoutResp> qxMessage = QXJsonUtils.fromJsonToQXMessage(data, HDLogoutResp.class);
            qxMessage.getContent().setResult(IDeveloper.Result.SUCCESS);
            if (qxBusiListener != null) {
                qxBusiListener.onQXMessageArrived(qxMessage.toJson());
            }

        } else if (cmd == SDK_SERVER_CONNECT_STATE) {
            CLog.d(TAG, "cmd = SDK_SERVER_CONNECT_STATE");

            QXMessage<QXServerConnectStateResp> qxMessage = QXJsonUtils.fromJsonToQXMessage(data, QXServerConnectStateResp.class);
            qxMessage = QXMessageConverter.getInstance().getBackQxMsgByFromQxMsg(qxMessage);
            MqttConnectState serverConnectState = getServerConnectState();

            QXServerConnectStateResp content = qxMessage.getContent();
            content.setServerConnectState(serverConnectState.name());
            content.setResult(IDeveloper.Result.SUCCESS);
            if (qxBusiListener != null) {
                qxBusiListener.onQXMessageArrived(qxMessage.toJson());
            }
        } else if (cmd == SDK_NETWORK_STATE) {

            NetworkInfo.State networkState = getNetworkState();
            String networkType = getNetworkType();

            QXMessage<QXNetworkStateResp> qxMessage = QXJsonUtils.fromJsonToQXMessage(data, QXNetworkStateResp.class);
            qxMessage = QXMessageConverter.getInstance().getBackQxMsgByFromQxMsg(qxMessage);
            QXNetworkStateResp content = qxMessage.getContent();
            content.setResult(IDeveloper.Result.SUCCESS);
            content.setNetworkState(networkState.name());
            content.setNetworkType(networkType);
            if (qxBusiListener != null) {
                qxBusiListener.onQXMessageArrived(qxMessage.toJson());
            }

        } else if (cmd == SDK_TEXT_SPEAKER) {

        } else if (cmd == SDK_CAMERA_CODE_SCAN) {

            QXMessage<QXCameraCodeScanResp> qxMessage = QXJsonUtils.fromJsonToQXMessage(data, QXCameraCodeScanResp.class);
            final QXMessage<QXCameraCodeScanResp> qxMessageFinal = QXMessageConverter.getInstance().getBackQxMsgByFromQxMsg(qxMessage);
            final QXCameraCodeScanResp content = qxMessageFinal.getContent();
            cameraCodeScan(content, new CameraCodeScanCallback() {
                @Override
                public void onResult(String data) {

                    int result;
                    if (TextUtils.isEmpty(data)) {
                        result = 0x1002;
                    } else {
                        result = IDeveloper.Result.SUCCESS;
                    }

                    content.setResult(result);

                    List<ResultBean> scanResult = QXJsonUtils.fromJsonToList(data, ResultBean.class);
                    content.setScanResult(scanResult);

                    if (qxBusiListener != null) {
                        qxBusiListener.onQXCameraCodeScanResult(qxMessageFinal);
                    }

                }
            });

        } else if (cmd == SDK_CAMERA_PHOTO) {

            QXMessage<QXTakePhotoResp> qxMessage = QXJsonUtils.fromJsonToQXMessage(data, QXTakePhotoResp.class);
            final QXMessage<QXTakePhotoResp> qxMessageFinal = QXMessageConverter.getInstance().getBackQxMsgByFromQxMsg(qxMessage);
            final QXTakePhotoResp content = qxMessageFinal.getContent();
            takePhoto(content, new TakePhotoCallback() {
                @Override
                public void onResult(List<TakePhotoConfig.FileBean> files) {
                    int result;
                    if (files == null) {
                        result = 0x1002;
                    } else {
                        result = IDeveloper.Result.SUCCESS;
                    }

                    content.setResult(result);
                    content.setFiles(files);
                    if (qxBusiListener != null) {
                        qxBusiListener.onQXTakePhotoResult(qxMessageFinal);
                    }
                }
            });

        } else {
            BaseData baseData = new BaseData.Builder()
                    .channelMqtt()
                    .topic(TopicManager.getInstance().getCloudPubTopic())
                    .data(data.getBytes())
                    .build();
            doSend(baseData, new ICallListener() {
                @Override
                public void onSuccess() {

                }

                @Override
                public void onFailed(int error) {
                    if (qxBusiListener != null) {
                        qxBusiListener.onSendFailed(data, error);
                    }
                }
            });
        }

    }


    @Override
    public void logout() {

        QXUserManager.getInstance().onLogout();
        if (qxBusiListener != null) {
            qxBusiListener.onQXLogoutResult(true);
        }


    }

    @Override
    public void cameraCodeScan(final QXCameraCodeScanReq req, final CameraCodeScanCallback callback) {

        CPermissionHelper.requestCamera(new CPermissionHelper.OnPermissionGrantedListener() {
            @Override
            public void onPermissionGranted() {

                Intent intent = new Intent(getApplication(), HDTrainScanScanActivity.class);
                ScanConfig config = new ScanConfig.Builder()
                        .scanPeroid(1500)
                        .scanType(req.getScanType())
                        .resTextScanDesc(R.string.scan_text)
                        .build();
                intent.putExtra(BaseScanActivity.EXTRA_SCAN_CONFIG, config);

                CActivityUtils.startActivityForResult(intent, new CActivityUtils.ResultCallback() {
                    @Override
                    public void onActivityResult(Intent data) {
                        String result = "";
                        if (data != null) {
                            result = data.getStringExtra("result");
                        }
                        CLog.d(TAG, "onActivityResult scan result = " + result);
                        callback.onResult(result);

                    }

                });


            }
        }, new CPermissionHelper.OnPermissionDeniedListener() {
            @Override
            public void onPermissionDenied() {
                callback.onResult(null);
            }
        });
    }


    @Override
    public void takePhoto(final QXTakePhotoReq req, final TakePhotoCallback callback) {
        Intent intent = new Intent(CUtils.get().getApp(), GetPicActivity.class);
        TakePhotoConfig config = new TakePhotoConfig.Builder()
                .count(req.getCount())
                .isCrop(req.getIsCrop())
                .sizeType(req.getSizeType())
                .sourceType(req.getSourceType())
                .tempPathDir(QXFileDirManager.getInstance().getTempPath().getAbsolutePath())
                .build();

        intent.putExtra(GetPicActivity.EXTRA_TAKEPHOTO_CONFIG, config);
        CActivityUtils.startActivityForResult(intent, new CActivityUtils.ResultCallback() {
            @Override
            public void onActivityResult(Intent data) {

                TakePhotoConfig result = (TakePhotoConfig) data.getSerializableExtra("result");
                if (result.getFiles() == null || result.getFiles().size() == 0) {
                    TAndL.L("cancel");
                    callback.onResult(null);
                } else {
                    TAndL.L(result.toString());
                    callback.onResult(result.getFiles());
                }

            }
        });
    }


    @Override
    public MqttConnectState getServerConnectState() {
        return QXMqttManager.getInstance().getMqttConnectState();
    }

    @Override
    public NetworkInfo.State getNetworkState() {
        return CNetworkManager.getInstance().getState();
    }

    @Override
    public String getNetworkType() {
        return CNetworkManager.getInstance().getNetworkType();
    }

    @Override
    public UserBean getUserBean() {
        return QXUserManager.getInstance().getUserBean();
    }


}
