package cn.com.startai.qxcommon.busi.qx;

import android.app.Application;
import android.net.NetworkInfo;

import java.nio.file.Files;
import java.util.List;

import cn.com.startai.common.channel.mqtt.MqttConnectState;
import cn.com.startai.qxcommon.QXCommonInitParam;
import cn.com.startai.qxcommon.busi.ICommonBusi;
import cn.com.startai.qxcommon.busi.qx.bean.QXCameraCodeScanReq;
import cn.com.startai.qxcommon.busi.qx.bean.QXTakePhotoReq;
import cn.com.startai.qxcommon.db.UserBean;
import cn.com.startai.scansdk.bean.TakePhotoConfig;

/**
 * Created by Robin on 2019/5/23.
 * 419109715@qq.com 彬影
 */
public interface IQXBusi extends ICommonBusi {


    /**
     * 初始化 会自动连接 服务器
     *
     * @param application
     * @param initParam      中的appid为0是 初始化后不会自动连接服务器
     * @param commonListener
     */
    void init(Application application, QXCommonInitParam initParam, AQXBusiListener commonListener);


    /**
     * 协议消息发送
     *
     * @param data
     */
    void doSend(String data);

    /**
     * 获取与服务器的连接状态
     */
    MqttConnectState getServerConnectState();

    /**
     * 获取当前网络类型
     */
    NetworkInfo.State getNetworkState();

    /**
     * 获取当前网络连接状态
     *
     * @return
     */
    String getNetworkType();


    /**
     * 获取当前登录的用户，如果没有登录会返回null
     *
     * @return
     */
    UserBean getUserBean();

    /**
     * 登出
     */
    void logout();

    /**
     * 条形码 二维码扫描
     *
     * @param req
     */
    void cameraCodeScan(QXCameraCodeScanReq req, CameraCodeScanCallback callback);

    /**
     * 拍照或从相册选择图片返回
     *
     * @param req
     * @param callback
     */
    void takePhoto(QXTakePhotoReq req, TakePhotoCallback callback);

    interface TakePhotoCallback {
        void onResult(List<TakePhotoConfig.FileBean> files);
    }

    interface CameraCodeScanCallback {
        void onResult(String result);
    }
}
