package cn.com.startai.qxcommon.busi.qx;


import android.net.NetworkInfo;

import org.json.JSONObject;

import cn.com.startai.common.channel.mqtt.MqttConnectState;
import cn.com.startai.common.utils.CLog;
import cn.com.startai.common.utils.network.INetworkListener;
import cn.com.startai.qxcommon.busi.qx.bean.QXCameraCodeScanResp;
import cn.com.startai.qxcommon.busi.qx.bean.QXNetworkStateResp;
import cn.com.startai.qxcommon.busi.qx.bean.QXServerConnectStateResp;
import cn.com.startai.qxcommon.busi.qx.bean.QXTakePhotoResp;
import cn.com.startai.qxcommon.event.IQXCommonListener;
import cn.com.startai.qxcommon.global.DeveloperParam;
import cn.com.startai.qxcommon.global.ParamManager;
import cn.com.startai.qxcommon.link.BaseData;
import cn.com.startai.qxcommon.protocol.IDeveloper;
import cn.com.startai.qxcommon.protocol.MiofTag;
import cn.com.startai.qxcommon.protocol.QXDataCreater;
import cn.com.startai.qxcommon.protocol.QXMessage;
import cn.com.startai.qxcommon.protocol.QXMessageConverter;
import cn.com.startai.qxcommon.utils.QXSpController;

import static cn.com.startai.qxcommon.QXCommon.TAG;

/**
 * Created by Robin on 2019/5/23.
 * 419109715@qq.com 彬影
 */
public abstract class AQXBusiListener implements INetworkListener, IQXCommonListener {

    private QX qx;
    private int msgtw;
    private long cmd;
    private String json;

    public void setQx(QX qx) {
        this.qx = qx;
    }

    public String getJson() {
        return json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public int getMsgtw() {
        return msgtw;
    }

    public void setMsgtw(int msgtw) {
        this.msgtw = msgtw;
    }

    public long getCmd() {
        return cmd;
    }

    public void setCmd(long cmd) {
        this.cmd = cmd;
    }


    // ---------- INetworkListener start ----------
    @Override
    public void onWifiConnected() {

    }

    @Override
    public void onMobileConnected() {

    }

    @Override
    public void onEthernetConnected() {

    }

    @Override
    public void onUnkownNetwork() {

    }

    @Override
    public void onNetworkStateChange(String networkType, NetworkInfo.State netwrokState) {

        QXNetworkStateResp content = new QXNetworkStateResp(networkType, netwrokState.name());
        content.setResult(QXServerConnectStateResp.SUCCESS);
        QXMessage qxMessage = QXDataCreater.getAppReportQXMsg(0, content);
        onQXMessageArrived(qxMessage.toJson());
    }

    @Override
    public void onServerConnected(String host) {
        if (QXSpController.getInstance().getIsActivite()) {
            if (qx != null && !qx.isHasCallbackInit()) {
                onInitSuccess(ParamManager.getInstance());
                qx.setHasCallbackInit(true);
            }
            callbackServerConnectState(MqttConnectState.CONNECTED);
        }
    }

    @Override
    public void onServerDisconnected(int errorCode) {
        callbackServerConnectState(MqttConnectState.DISCONNECTED);
    }

    public void onInitSuccess(DeveloperParam content) {
        content.setCmd(QXCmd.SDK_INIT);
        content.setResult(IDeveloper.Result.SUCCESS);
        QXMessage qxMessage = QXDataCreater.getAppReportQXMsg(0, content);
        onQXMessageArrived(qxMessage.toJson());
    }

    public void callbackServerConnectState(MqttConnectState mqttConnectState) {
        QXServerConnectStateResp content = new QXServerConnectStateResp(mqttConnectState.name());
        content.setResult(QXServerConnectStateResp.SUCCESS);
        QXMessage qxMessage = QXDataCreater.getAppReportQXMsg(0, content);
        onQXMessageArrived(qxMessage.toJson());
    }
    // ---------- INetworkListener end ----------

    @Override
    public void onMessageArrived(BaseData baseData) {

        json = new String(baseData.getData());
        cmd = QXMessageConverter.getInstance().getCmdFromJson(json);
        msgtw = QXMessageConverter.getInstance().getMsgTwFromJson(json);
        CLog.d(TAG, "cmd = " + cmd + " msgtw = " + msgtw);

        if (getCmd() > 0 && getMsgtw() > 0) {
            String json = getJson();
            onQXMessageArrived(json);
        } else {
            CLog.e(TAG, "error data formate");
        }

    }

    /**
     * 拍照或相册选择图片返回
     *
     * @param qxMessage
     */
    void onQXTakePhotoResult(QXMessage<QXTakePhotoResp> qxMessage) {
        onQXMessageArrived(qxMessage.toJson());
    }

    /**
     * 条形码 二维码扫描
     */
    protected void onQXCameraCodeScanResult(QXMessage<QXCameraCodeScanResp> qxMessage) {
        onQXMessageArrived(qxMessage.toJson());
    }

    public void onSendFailed(String data, int error) {
        try {
            JSONObject jsonObject = new JSONObject(data);
            JSONObject jsonContent = jsonObject.getJSONObject(MiofTag.TAG_CONTENT);
            jsonContent.put(MiofTag.TAG_RESULT, error);
            onQXMessageArrived(jsonObject.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract void onQXLogoutResult(boolean result);

    public abstract void onQXMessageArrived(String json);
}
