package cn.com.startai.qxcommon.busi.huadian.icbc;

import android.os.Bundle;

import java.lang.reflect.Field;

import cn.com.startai.common.utils.CReflectUtils;

/**
 * Created by Robin on 2019/9/2.
 * 419109715@qq.com 彬影
 */
public class MultiPurchaseResp  {

    /**
     * 用户在可选页面上最终选择的付款方式。
     * 输出的是由大写英文组成的交易类型。	"PURCHASE"：银行卡消费
     * "QRPURCHASE"：二维码消费
     * "INTEGRAL_PURCHASE"：积分消费
     * "INSTALLMENT"：分期付款
     */
    public String PAY_TYPE;
    /**
     * 交易金额（人民币），单位：分。
     */
    public Long AMOUNT;
    /**
     * 清算金额（人民币），单位：分。
     * 工行主机返回的实际扣款金额（受优惠、小费等因素影响）。
     */
    public Long RET_AMT;
    /**
     * 银行卡消费 小费金额（人民币），单位：分。
     * 消费者额外支付的小费。
     * 银行卡消费时在用户读卡界面可手动输入消费。
     * 注意：部分终端有可能被工行主机参数配置成不支持小费输入。
     */
    public Long FEE_AMT;
    /**
     * 结账POS 批次号。
     */
    public String BATCH_NUM;

    /**
     * 工行主机返回的检索参考号。
     */
    public String REF_NO;
    /**
     * 终端流水号
     */
    public String TRACE_NO;
    /**
     * 主机有返回 工行主机返回的授权号，根据实际交易情况，该值不一定会返回。
     */
    public String AUTH_ID;
    /**
     * 二维码消费 用户付款二维码种类。
     * 1:工银二维码
     * 2:银联二维码
     * 3:微信支付
     * 4:支付宝支付
     */
    public Long QR_TYPE;
    /**
     * 二维码消费 用于做二维码退款交易。
     * 工行主机返回二维码订单号（即手机收到支付平台返回的条形码商户订单号）。
     */
    public String QRCODE_ORDER;
    /**
     * 微信支付宝 二维码平台自身的支付订单号。
     * 见手机账单详情页面，微信支付为"交易单号"，支付宝为"订单号"。该单号无法用于退款。
     */
    public String QR_TRANS_ID;
    /**
     * 微信支付宝 微信支付宝的用户标识
     */
    public String QR_USER_ID;
    /**
     * 支付宝支付 支付宝的付款账号
     */
    public String ALIPAY_LOGON_ID;
    /**
     * 微信支付 用户在微信公众号下的唯一标识
     */
    public String WECHAT_SUBOPENID;
    /**
     * 微信支付 微信付款方式的数据字典(如零钱、工商银行卡等)
     */
    public String WECHAT_BANKTYPE;

    /**
     * 二维码消费且折扣优惠 折扣优惠（百分比）。二维码优惠，同一交易只会有一种优惠方式。如果都没有返回表示没有优惠。示例：
     * 88表示88%
     */
    public Long QR_DISSCOUNT;
    /**
     * 二维码消费且抵用优惠 抵用券优惠（人民币），单位：分。
     */
    public Long QR_VOUCHER;
    /**
     * 积分消费 消费积分。在积分消费中所使用的积分，将会抵扣部分金额。
     */
    public Long INTEGRAL;
    /**
     * 积分消费 积分抵扣金额（人民币），单位：分。
     */
    public Long INTEGRAL_AMOUNT;
    /**
     * 分期付款 分期付款的期数。
     */
    public Long INS_TIMES;
    /**
     * 分期付款 分期付款的还款币种（货币代码）。示例：
     * "RMB":人民币
     * "HKD":港币
     * "USD":美元
     */
    public String INS_CUR_TYPE;
    /**
     * 分期付款 分期付款首付金额（使用上面字段INS_CUR_TYPE作为币种），单位：分。
     */
    public Long INS_FIRST_PAY;
    /**
     * 分期付款且交易卡由工行发行 分期付款每期付款金额（使用上面字段INS_CUR_TYPE作为币种），单位：分。
     */
    public Long INS_EVERY_PAY;
    /**
     * 分期付款 分期付款手续费支付方式。    1:一次性支付
     * 2:分期支付
     */
    public Long INS_FEE_TYPE;
    /**
     * 分期付款且一次性支付手续费 一次性支付手续费的金额（使用上面字段INS_CUR_TYPE作为币种），单位：分。
     */
    public Long INS_ONCE_FEE;
    /**
     * 分期付款且分期支付手续费 首期手续费金额（使用上面字段INS_CUR_TYPE作为币种），单位：分。
     */
    public Long INS_FIRST_FEE;
    /**
     * 分期付款且分期支付手续费 每期手续费金额（使用上面字段INS_CUR_TYPE作为币种），单位：分。
     */
    public Long INS_EVERY_FEE;

    @Override
    public String toString() {
        return "MultiPurchaseResp{" +
                "PAY_TYPE='" + PAY_TYPE + '\'' +
                ", AMOUNT=" + AMOUNT +
                ", RET_AMT=" + RET_AMT +
                ", FEE_AMT=" + FEE_AMT +
                ", BATCH_NUM='" + BATCH_NUM + '\'' +
                ", REF_NO='" + REF_NO + '\'' +
                ", TRACE_NO='" + TRACE_NO + '\'' +
                ", AUTH_ID='" + AUTH_ID + '\'' +
                ", QR_TYPE=" + QR_TYPE +
                ", QRCODE_ORDER='" + QRCODE_ORDER + '\'' +
                ", QR_TRANS_ID='" + QR_TRANS_ID + '\'' +
                ", QR_USER_ID='" + QR_USER_ID + '\'' +
                ", ALIPAY_LOGON_ID='" + ALIPAY_LOGON_ID + '\'' +
                ", WECHAT_SUBOPENID='" + WECHAT_SUBOPENID + '\'' +
                ", WECHAT_BANKTYPE='" + WECHAT_BANKTYPE + '\'' +
                ", QR_DISSCOUNT=" + QR_DISSCOUNT +
                ", QR_VOUCHER=" + QR_VOUCHER +
                ", INTEGRAL=" + INTEGRAL +
                ", INTEGRAL_AMOUNT=" + INTEGRAL_AMOUNT +
                ", INS_TIMES=" + INS_TIMES +
                ", INS_CUR_TYPE='" + INS_CUR_TYPE + '\'' +
                ", INS_FIRST_PAY=" + INS_FIRST_PAY +
                ", INS_EVERY_PAY=" + INS_EVERY_PAY +
                ", INS_FEE_TYPE=" + INS_FEE_TYPE +
                ", INS_ONCE_FEE=" + INS_ONCE_FEE +
                ", INS_FIRST_FEE=" + INS_FIRST_FEE +
                ", INS_EVERY_FEE=" + INS_EVERY_FEE +
                '}';
    }

}
