package cn.com.startai.qxcommon.busi.huadian.icbc;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;

import java.util.ArrayList;

import cn.com.startai.common.utils.CActivityUtils;
import cn.com.startai.common.utils.CAppUtils;

/**
 * Created by Robin on 2019/8/2.
 * 419109715@qq.com 彬影
 */
public class ICBCUtils {
    public static final int VALUE_BANKPAY_VAR = 1020100;
    public static String VALUE_APP_NAME = "";

    //完整支付类接口
    public static final String ACTION_STARTTRANS = "com.icbc.smartpos.transservice.startTrans";
    //交易流程类接口
    public static final String ACTION_STRANSFLOWS = "com.icbc.smartpos.transservice.transFlows";
    //维护管理类接口
    public static final String ACTION_MANAGER = "com.icbc.smartpos.transservice.manager";
    //设备使用类接口
    public static final String ACTION_DEVICES = "com.icbc.smartpos.transservice.devices";


    /**
     * 银行卡收款
     *
     * @param amount
     * @param orderNum
     * @param callback
     */
    public static void multiPurchaseWithBankCard(long amount, String orderNum, final ICBCCallback callback) {
        multiPurchase(amount, orderNum, IPosPayType.PURCHASE, callback);
    }

    /**
     * 二维码收款
     *
     * @param amount
     * @param orderNum
     * @param callback
     */
    public static void multiPurchaseWithQRCode(long amount, String orderNum, final ICBCCallback callback) {
        multiPurchase(amount, orderNum, IPosPayType.QRPURCHASE, callback);
    }

    /**
     * 收款
     *
     * @param callback
     */
    public static void multiPurchase(long amount, String orderNum, String payType, final ICBCCallback callback) {

        Intent intent = new Intent(ACTION_STARTTRANS);

        Bundle transData = new Bundle();
        transData.putLong("AMOUNT", amount);
        ArrayList<String> list = new ArrayList<>();
//        list.add("QRPURCHASE");
        list.add(payType);
        transData.putStringArrayList("TRANS_LIST", list);
        transData.putString("BILL_INFO", orderNum);

        intent.putExtra("transType", "MULTI_PURCHASE");

        intent.putExtra("ctrlData", getCtrlData(orderNum, true));

        intent.putExtra("transData", transData);

        startActivityForResult(intent, callback);

    }

    /**
     * 当日撤销
     * @param refNo
     * @param orderSn
     * @param callback
     */
    public static void posVoid(  String refNo, String orderSn,ICBCCallback callback) {

        Intent intent = new Intent(ACTION_STARTTRANS);

        Bundle transData = new Bundle();
        transData.putString("OLD_REF_NO", refNo);
        transData.putString("BILL_INFO", orderSn);

        intent.putExtra("transType", "POS_VOID");
        intent.putExtra("ctrlData", getCtrlData(null, true));
        intent.putExtra("transData", transData);

        startActivityForResult(intent, callback);
    }

    /**
     * 二维码 退款
     *
     * @param amount
     * @param callback
     */
    public static void qrRefund(long amount, String qrCodeOrder, String orderSn, ICBCCallback callback) {
        Intent intent = new Intent(ACTION_STARTTRANS);

        Bundle transData = new Bundle();
        transData.putString("OLD_QRCODE_ORDER", qrCodeOrder);
        transData.putLong("AMOUNT", amount);
        transData.putString("BILL_INFO", orderSn);

        intent.putExtra("transType", "QRREFUND");
        intent.putExtra("ctrlData", getCtrlData(null, true));
        intent.putExtra("transData", transData);

        startActivityForResult(intent, callback);
    }

    /**
     * 签到
     *
     * @param callback
     */
    public static void login(final ICBCCallback callback) {
        Intent intent = new Intent(ACTION_MANAGER);
        intent.putExtra("cmd", "LOGON"); // intent为startActivityForResult中传递的Intent
        intent.putExtra("ctrlData", getCtrlData("", true));
        intent.putExtra("transData", new Bundle());

        startActivityForResult(intent, callback);

    }

    public static void checkUpdate(final ICBCCallback callback){
        Intent intent = new Intent(ACTION_MANAGER);
        intent.putExtra("cmd", "CHECK_UPDATE");
        intent.putExtra("ctrlData", getCtrlData(null, true));
        Bundle tranData = new Bundle();
        tranData.putString("APP_PACKAGE",CAppUtils.getAppPackageName());
        tranData.putLong("TYPE",2);
        intent.putExtra("transData", tranData);

        startActivityForResult(intent, callback);
    }

    /**
     * 获取终端信息
     *
     * @param callback
     */
    public static void terminalInfo(final ICBCCallback callback) {

        Intent intent = new Intent(ACTION_MANAGER);
        intent.putExtra("cmd", "TERMINAL_INFO");
        intent.putExtra("ctrlData", getCtrlData(null, true));
        intent.putExtra("transData", new Bundle());

        startActivityForResult(intent, callback);
    }

    /**
     * 查询最近一次交易记录
     *
     * @param extOrderNo 查询的外部订单号，不填表示查询最近的一次
     */
    public static void queryTransRec(String extOrderNo, ICBCCallback callback) {
//8d419d6b4747466eb1b346c8c3e513b0
        Intent intent = new Intent(ACTION_MANAGER);
        intent.putExtra("cmd", "QUERY_TRANS_REC");
        intent.putExtra("ctrlData", getCtrlData(null, true));
        Bundle transData = new Bundle();
        if (!TextUtils.isEmpty(extOrderNo)) {
            transData.putString("OLD_EXT_ORDER_NO", extOrderNo);
        }
        intent.putExtra("transData", transData);

        startActivityForResult(intent, callback);
    }


    /**
     * 执行请求
     *
     * @param intent
     * @param callback
     */
    private static void startActivityForResult(Intent intent, final ICBCCallback callback) {
        CActivityUtils.startActivityForResult(intent, new CActivityUtils.ResultCallback() {
            @Override
            public void onActivityResult(Intent data) {
                callback.onResult(data);

            }
        });
    }

    /**
     * 获取 ctrlData
     *
     * @param orderNum
     * @param isUnique
     * @return
     */
    private static Bundle getCtrlData(String orderNum, boolean isUnique) {
        Bundle ctrlData = new Bundle();
        if (TextUtils.isEmpty(VALUE_APP_NAME)) {
            VALUE_APP_NAME = CAppUtils.getAppName();
        }
        ctrlData.putString("APP_NAME", VALUE_APP_NAME);
        ctrlData.putLong("BANKPAY_VER", VALUE_BANKPAY_VAR);
        if (!TextUtils.isEmpty(orderNum)) {
            ctrlData.putString("EXT_ORDER_NO", orderNum);
        }
        ctrlData.putBoolean("IS_UNIQUE", isUnique);
        return ctrlData;
    }



    public interface ICBCCallback {
        void onResult(Intent data);
    }


}
