package cn.com.startai.qxcommon.busi.huadian.icbc;

/**
 * Created by Robin on 2019/9/3.
 * 419109715@qq.com 彬影
 */
public class ExtraInfo {

    /**
     * M	交易介质输入方式。	1：刷卡
     * 2：插卡
     * 3：挥卡
     * 4：手输卡号
     * 5：二维码
     */
    public Long INPUT_MODE;
    /**
     * 特定交易且手输卡号	手输卡号时的输入证件类型。
     * 只在以下交易生效：
     * 银行卡消费、分期付款、积分消费、预授权
     * <p>
     * 只有在用户输入了有效证件编码的时候才会有返回。	0：身份证
     * 1：护照
     * 2：军官证
     * 3：士兵证
     * 4：港澳通行证
     * 5：临时身份证
     * 6：户口本
     * 9：警官证
     * 12：外国人居住证
     */
    public Long ID_TYPE;
    /**
     * 银行卡交易	部分屏蔽的卡号。
     * 用于卡号展示时请尽量使用该值，完整卡号的输出需工行审核。
     */
    public String SHILDED_PAN;
    /**
     * 银行卡交易且具备输出敏感信息权限	完整的银行卡号。
     * 该数据返回受特别权限控制，如果不具备输出敏感信息签名权限将不会输出该信息。
     */
    public String PAN;
    /**
     * 银行卡交易且具备输出敏感信息权限	卡有效期。格式：MMYY。
     * 该数据返回受特别权限控制，如果不具备输出敏感信息签名权限将不会输出该信息。
     */
    public String EXP_DATE;
    /**
     * IC卡交易	卡序列号。
     */
    public String CARD_SN;
    /**
     * 银行卡交易	银行卡对应的卡种信息。
     */
    public String CARD_NAME;
    /**
     * 发卡行名称。
     */
    public String CARD_ISSUER;
    /**
     * 不是二维码消费	银行卡的卡组织名称。
     */
    public String CARD_ORG;
    /**
     * 银行卡插卡交易	银行卡插卡交易成功时，卡片应用的TC证书。
     */
    public String TC;
    /**
     * 银行卡交易	银行卡插卡交易的终端验证结果数据。
     */
    public String TVR;
    /**
     * 银行卡交易	银行卡插卡交易的交易状态信息。
     */
    public String TSI;
    /**
     * 银行卡交易	EMV数据交易计数器。
     */
    public String ATC;
    /**
     * 银行卡交易	EMV数据应用标识。
     */
    public String AID;
    /**
     * 银行卡交易	EMV数据应用标签
     */
    public String APP_LABEL;
    /**
     * 银行卡交易	EMV数据应用首选名称
     */
    public String APP_PREFNAME;
    /**
     * 银行卡交易	是否为简易流程的EMV交易
     */
    public Boolean EMV_SIMPLEMODE;
    /**
     * 工行主机应答的完整检索参考号(共23位)。
     * 该字段并无实际意义，请注意与REF_NO字段区分(8位)。
     * 在所有接口命令中需要用到检索参考号的都是使用REF_NO字段。
     */
    public String REF_NO_FULL;
    /**
     * 他行卡交易	银联商户号。
     */
    public String UPI_CUST_NO;
    /**
     * 外卡交易	外卡商户名称。	执行外卡交易时将可能会返回这些信息。
     */
    public String FOREIGN_CUST_NAME;
    /**
     * 外卡交易	外卡商户号。
     */
    public String FOREIGN_CUST_NO;
    /**
     * 外卡交易	外卡流水号。
     */
    public String FOREIGN_TRACENUM;
    /**
     * 用户选择了DCC转换	DCC币种。	部分交易会提示用户是否进行汇率转换，如果用户选择了是将会返回DCC相关信息。
     * <p>
     * DCC只对以下交易有效：
     * 银行卡消费、积分消费、预授权确认。	示例：
     * "RMB": 人民币
     * "HKD": 港币
     * "USD": 美元
     */
    public String DCC_CUR_TYPE;

    /**
     * 用户选择了DCC转换	DCC金额，以DCC_CUR_TYPE作为为币种，单位：分。
     */
    public Long DCC_AMT;
    /**
     * 用户选择了DCC转换	DCC汇率。
     * 该整型数值为实际汇率扩大了10000倍。		示例：
     * 12345为1.2345
     * 1585为0.1585
     * DCC_MARK_UP	Long	C
     * 用户选择了DCC转换	DCC汇率上浮（万分比）。		示例：
     * 10000为100%
     * 120为1.2%
     */
    public Long DCC_EX_RATE;
    /**
     * 交易存在立减	银行立减（人民币），单位：分。	两者之和为消费立减。
     * 只对以下交易有效：
     * 银行卡消费、积分消费、预授权确认。
     */
    public Long BANK_REDUCE_AMT;
    /**
     * 交易存在立减	商户立减（人民币），单位：分。
     */
    public Long CUST_REDUCE_AMT;

    /**
     * 商户中奖	商户中奖信息。	部分交易成功后商户有可能会中奖，此时将输出相应的中奖信息。如果字段未输出则表明未中奖。
     */
    public String CUST_AWARD_INFO;
    /**
     * 商户中奖 商户中奖等级;。
     */
    public String CUST_AWARD_LEVEL;


    /**
     * 持卡人中奖 中奖活动名称;。部分交易成功后消费者有可能会中奖，此时将输出相应的中奖信息。如果字段未输出则表明未中奖。
     */
    public String AWARD_PRJ_NAME;
    /**
     * 持卡人中奖 中奖活动编号;。
     */
    public String AWARD_PRJ_ID;
    /**
     * 持卡人中奖 中奖序号;。可通过在有奖消费兑奖交易中使用该序号兑奖。
     */
    public String AWARD_NO;
    /**
     * 持卡人中奖 奖品信息;。
     */
    public String AWARD_NAME;

    /**
     * M 电子签名标识;，标识着客户是否执行了电子签名。    true:是
     * false:否
     */
    public Boolean E_SIGNATURE;
    /**
     * M 凭条签名标识;，标识着交易凭条是否需要客户签名。    true:
     * <p>
     * 需要签名(含电子签名) {
     * }
     * false:小额免签
     */
    public Boolean REQ_SIGNATURE;

    @Override
    public String toString() {
        return "ExtraInfo{" +
                "INPUT_MODE=" + INPUT_MODE +
                ", ID_TYPE=" + ID_TYPE +
                ", SHILDED_PAN='" + SHILDED_PAN + '\'' +
                ", PAN='" + PAN + '\'' +
                ", EXP_DATE='" + EXP_DATE + '\'' +
                ", CARD_SN='" + CARD_SN + '\'' +
                ", CARD_NAME='" + CARD_NAME + '\'' +
                ", CARD_ISSUER='" + CARD_ISSUER + '\'' +
                ", CARD_ORG='" + CARD_ORG + '\'' +
                ", TC='" + TC + '\'' +
                ", TVR='" + TVR + '\'' +
                ", TSI='" + TSI + '\'' +
                ", ATC='" + ATC + '\'' +
                ", AID='" + AID + '\'' +
                ", APP_LABEL='" + APP_LABEL + '\'' +
                ", APP_PREFNAME='" + APP_PREFNAME + '\'' +
                ", EMV_SIMPLEMODE=" + EMV_SIMPLEMODE +
                ", REF_NO_FULL='" + REF_NO_FULL + '\'' +
                ", UPI_CUST_NO='" + UPI_CUST_NO + '\'' +
                ", FOREIGN_CUST_NAME='" + FOREIGN_CUST_NAME + '\'' +
                ", FOREIGN_CUST_NO='" + FOREIGN_CUST_NO + '\'' +
                ", FOREIGN_TRACENUM='" + FOREIGN_TRACENUM + '\'' +
                ", DCC_CUR_TYPE='" + DCC_CUR_TYPE + '\'' +
                ", DCC_AMT=" + DCC_AMT +
                ", DCC_EX_RATE=" + DCC_EX_RATE +
                ", BANK_REDUCE_AMT=" + BANK_REDUCE_AMT +
                ", CUST_REDUCE_AMT=" + CUST_REDUCE_AMT +
                ", CUST_AWARD_INFO='" + CUST_AWARD_INFO + '\'' +
                ", CUST_AWARD_LEVEL='" + CUST_AWARD_LEVEL + '\'' +
                ", AWARD_PRJ_NAME='" + AWARD_PRJ_NAME + '\'' +
                ", AWARD_PRJ_ID='" + AWARD_PRJ_ID + '\'' +
                ", AWARD_NO='" + AWARD_NO + '\'' +
                ", AWARD_NAME='" + AWARD_NAME + '\'' +
                ", E_SIGNATURE=" + E_SIGNATURE +
                ", REQ_SIGNATURE=" + REQ_SIGNATURE +
                '}';
    }
}
