package cn.com.startai.qxcommon.busi.huadian.icbc;

import android.os.Bundle;

import java.lang.reflect.Field;

import cn.com.startai.common.utils.CReflectUtils;

/**
 * Created by Robin on 2019/9/2.
 * 419109715@qq.com 彬影
 */
public class BaseResult {

    /**
     * 结果类型。
     * 注意1：该值是交易成功与否的唯一标识。
     * 注意2：在做二维码消费交易时，将会有可能返回交易结果未知，此时需要按9.4查本机交易记录进行补录。
     * <p>
     * 0：交易成功
     * 1：交易失败
     * 9：交易结果未知
     */
    public Long RESULT;

    /**
     * 交易描述，交易失败时将会输出对应的失败信息描述。
     */
    public String DESCRIPTION;
    /**
     * 交易命令。
     * 入参transType原值返回。
     */
    public String TRANS_TYPE;
    /**
     * 交易时间。
     * 格式：yyyyMMddHHmmss
     * 如果未收到工行主机处理结果将返回调用时的时间，否则将返回工行主机回送的交易时间。
     */
    public String TRANS_TIME;
    /**
     * 终端对应的商户名称。
     */
    public String CUST_NAME;
    /**
     * 终端对应的12位商户号。
     */
    public String CUST_NO;
    /**
     * 终端对应的15位终端号。
     * 部分交易要求传入原交易的终端号。。
     */
    public String TERM_NO;
    /**
     * 交易顺序号。
     * 由工银收单自身维护的顺序号，可用于本机记录查询及重打印
     */
    public Long TRANS_SEQUENCE;
    /**
     * 当在控制参数ctrlData中有传入EXT_ORDER_NO时，这里将原值返回。第三方应用可通过判断该值的输入与输出是否一致来判断工银收单所返回的数据是否时同一笔交易。
     */
    public String EXT_ORDER_NO;

    @Override
    public String toString() {
        return "BaseResult{" +
                "RESULT=" + RESULT +
                ", DESCRIPTION='" + DESCRIPTION + '\'' +
                ", TRANS_TYPE='" + TRANS_TYPE + '\'' +
                ", TRANS_TIME='" + TRANS_TIME + '\'' +
                ", CUST_NAME='" + CUST_NAME + '\'' +
                ", CUST_NO='" + CUST_NO + '\'' +
                ", TERM_NO='" + TERM_NO + '\'' +
                ", TRANS_SEQUENCE=" + TRANS_SEQUENCE +
                ", EXT_ORDER_NO='" + EXT_ORDER_NO + '\'' +
                '}';
    }

}
