package cn.com.startai.qxcommon.busi.huadian;

import android.app.Application;

import cn.com.startai.common.channel.ICallListener;
import cn.com.startai.qxcommon.busi.huadian.bean.HDCaptainDownTripReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDChangeOrderStateReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDChangeShelvesModeReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDChangeTripModeReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDClearWarehouseStockReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetBranchOfficeReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetDutyRoutingReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetOrderDetailReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetOrderListReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetOrderPayStateReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetRefundDetailReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetRefundListReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTeamInfoReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTrainGoodsListReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTripDetailReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTripRecordReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetUnDoOrderNumReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetUserInfoReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetWarehouseInventoryReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetWarehouseListReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDLoginReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDManualDownTripReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPosCheckUpdateReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPosMultiPurchaseReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPayForOrderReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPlacingOrderReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPosPosVoidReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPosQrRefundReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPosQueryTransRecReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPutOnOffSaleReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDRejectionOrderReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDTrainerReviewRefundReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDUpdateUserLoginPwdReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDUseReq;
import cn.com.startai.qxcommon.busi.huadian.icbc.ICBCUtils;
import cn.com.startai.qxcommon.busi.qx.IQXBusi;

/**
 * Created by Robin on 2019/5/22.
 * 419109715@qq.com 彬影
 */
public interface IHDTrainerBusi extends IQXBusi {

    /**
     * 初始化后不会自动连接服务器
     *
     * @param application
     * @param listener
     */
    void init(Application application, AHDTrainerListener listener);


    /**
     * 华点登录
     *
     * @param req
     * @param callListener
     */
    void hdLogin(HDLoginReq req, ICallListener callListener);

    /**
     * 华点 更新用户登录密码
     *
     * @param req
     * @param callListener
     */
    void hdUpdateUserLoginPwd(HDUpdateUserLoginPwdReq req, ICallListener callListener);

    /**
     * 华点 获取班级信息
     *
     * @param req
     * @param callListener
     */
    void hdGetTeamInfo(HDGetTeamInfoReq req, ICallListener callListener);

    /**
     * 华点 获取出乘记录
     *
     * @param req
     * @param callListener
     */
    void hdGetTripRecord(HDGetTripRecordReq req, ICallListener callListener);

    /**
     * 华点 获取 出乘详情
     *
     * @param req
     * @param callListener
     */
    void hdGetTripDetail(HDGetTripDetailReq req, ICallListener callListener);

    /**
     * 华点 获取用户信息
     *
     * @param req
     * @param callListener
     */
    void hdGetUserInfo(HDGetUserInfoReq req, ICallListener callListener);

    /**
     * 获取用户所属分公司
     *
     * @param req
     * @param callListener
     */
    void hdGetBranchOffice(HDGetBranchOfficeReq req, ICallListener callListener);

    /**
     * 获取值乘交路
     *
     * @param req
     * @param callListener
     */
    void hdGetDutyRouting(HDGetDutyRoutingReq req, ICallListener callListener);

    /**
     * 获取列车商品列表
     *
     * @param req
     * @param callListener
     */
    void hdGetTrainGoodsList(HDGetTrainGoodsListReq req, ICallListener callListener);

    /**
     * 下单
     *
     * @param req
     * @param callListener
     */
    void hdPlacingOrder(HDPlacingOrderReq req, ICallListener callListener);

    /**
     * 获取订单支付状态
     *
     * @param req
     */
    void hdGetOrderPayState(HDGetOrderPayStateReq req, ICallListener callListener);

    /**
     * 获取订单详情
     *
     * @param req
     * @param callListener
     */
    void hdGetOrderDetail(HDGetOrderDetailReq req, ICallListener callListener);

    /**
     * 获取订单列表
     *
     * @param req
     * @param callListener
     */
    void hdGetOrderList(HDGetOrderListReq req, ICallListener callListener);


    /**
     * 修改订单状态
     *
     * @param req
     * @param callListener
     */
    void hdChangeOrderState(HDChangeOrderStateReq req, ICallListener callListener);

    /**
     * 上架 下架货物
     *
     * @param req
     * @param callListener
     */
    void hdPutOnOffSale(HDPutOnOffSaleReq req, ICallListener callListener);



    /**
     * 列车员审核退款申请
     *
     * @param req
     * @param callListener
     */
    void hdTrainerReviewRefund(HDTrainerReviewRefundReq req, ICallListener callListener);

    /**
     * 获取退款单列表
     *
     * @param req
     * @param callListener
     */
    void hdGetRefundList(HDGetRefundListReq req, ICallListener callListener);

    /**
     * 获取退款单详情
     *
     * @param req
     * @param callListener
     */
    void hdGetRefundDetail(HDGetRefundDetailReq req, ICallListener callListener);

    /**
     * 手动下乘
     *
     * @param req
     * @param callListener
     */
    void hdMamualDownTrip(HDManualDownTripReq req, ICallListener callListener);


    /**
     * 切换手|自动模式
     *
     * @param req
     * @param callListener
     */
    void hdChangeTripMode(HDChangeTripModeReq req, ICallListener callListener);


    /**
     * 获取仓库列表
     *
     * @param req
     * @param callListener
     */
    void hdGetWarehouseList(HDGetWarehouseListReq req, ICallListener callListener);

    /**
     * 班级下乘
     *
     * @param req
     * @param callListener
     */
    void hdCaptainDownTrip(HDCaptainDownTripReq req, ICallListener callListener);

    /**
     * 获取仓库库存信息
     *
     * @param req
     * @param callListener
     */
    void hdGetWarehouseInventory(HDGetWarehouseInventoryReq req, ICallListener callListener);

    /**
     * 领用申请
     *
     * @param req
     * @param callListener
     */
    void hdUse(HDUseReq req, ICallListener callListener);

    /**
     * 清库存
     *
     * @param req
     * @param callListener
     */
    void hdClearWarehouseStock(HDClearWarehouseStockReq req, ICallListener callListener);

    /**
     * 修改商品上架模式
     *
     * @param req
     * @param callListener
     */
    void hdChangeShelvesMode(HDChangeShelvesModeReq req, ICallListener callListener);

    /**
     * 列车员拒绝接单
     *
     * @param req
     * @param callListener
     */
    void hdRejectionOrder(HDRejectionOrderReq req, ICallListener callListener);

    /**
     * 获取未处理订单数
     *
     * @param req
     * @param callListener
     */
    void hdGetUnDoOrderNum(HDGetUnDoOrderNumReq req, ICallListener callListener);

    /**
     * 为订单支付
     *
     * @param req
     * @param callListener
     */
    void hdPayForOrder(HDPayForOrderReq req, ICallListener callListener);

    /**
     * pos收款
     *
     * @param req
     */
    void hdPosMultiPurshase(HDPosMultiPurchaseReq req, ICBCUtils.ICBCCallback callback);

    /**
     * pos 查询交易记录
     *
     * @param req
     * @param callback
     */
    void hdPosQueryTransRec(HDPosQueryTransRecReq req, ICBCUtils.ICBCCallback callback);

    /**
     * 当日撤销
     *
     * @param req
     * @param callback
     */
    void hdPosPosVoid(HDPosPosVoidReq req, ICBCUtils.ICBCCallback callback);

    /**
     * 二维码退款
     *
     * @param req
     * @param callback
     */
    void hdPosQrRefund(HDPosQrRefundReq req, ICBCUtils.ICBCCallback callback);

    /**
     * 检查更新
     */
    void hdPosCheckUpdate(HDPosCheckUpdateReq req, ICBCUtils.ICBCCallback callback);


}
