package cn.com.startai.qxcommon.busi.huadian;

import android.app.Application;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;

import cn.com.startai.common.channel.CErrorCode;
import cn.com.startai.common.channel.ICallListener;
import cn.com.startai.common.utils.CAppUtils;
import cn.com.startai.common.utils.CLog;
import cn.com.startai.common.utils.TAndL;
import cn.com.startai.qxcommon.QXCommonInitParam;
import cn.com.startai.qxcommon.busi.huadian.bean.HDCaptainDownTripReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDChangeOrderStateReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDChangeShelvesModeReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDChangeTripModeReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDClearWarehouseStockReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetBranchOfficeReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetDutyRoutingReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetOrderDetailReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetOrderListReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetOrderPayStateReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetRefundDetailReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetRefundListReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTeamInfoReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTrainGoodsListReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTripDetailReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTripRecordReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetUnDoOrderNumReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetUserInfoReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetWarehouseInventoryReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetWarehouseListReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDLoginReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDManualDownTripReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPosCheckUpdateReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPosCheckUpdateResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPosMultiPurchaseReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPosMultiPurchaseResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPayForOrderReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPlacingOrderReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPosPosVoidReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPosPosVoidResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPosQrRefundReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPosQrRefundResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPosQueryTransRecReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPosQueryTransRecResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPutOnOffSaleReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDRejectionOrderReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDTrainerReviewRefundReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDUpdateUserLoginPwdReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDUseReq;
import cn.com.startai.qxcommon.busi.huadian.icbc.BaseResult;
import cn.com.startai.qxcommon.busi.huadian.icbc.BundleUtils;
import cn.com.startai.qxcommon.busi.huadian.icbc.ExtraInfo;
import cn.com.startai.qxcommon.busi.huadian.icbc.ICBCUtils;
import cn.com.startai.qxcommon.busi.huadian.icbc.MultiPurchaseResp;
import cn.com.startai.qxcommon.busi.qx.QX;
import cn.com.startai.qxcommon.protocol.QXMessage;
import cn.com.startai.qxcommon.protocol.QXMessageConverter;
import cn.com.startai.qxcommon.utils.gson.QXJsonUtils;

import static cn.com.startai.qxcommon.QXCommon.TAG;

/**
 * Created by Robin on 2019/5/22.
 * 419109715@qq.com 彬影
 */
public class HDTrainer extends QX implements IHDTrainerBusi, HDCmd {


    private HDTrainer() {
    }

    public static HDTrainer getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }


    private static class SingleTonHoulder {
        private static final HDTrainer singleTonInstance = new HDTrainer();
    }

    private AHDTrainerListener hdListener;

    /**
     * 初始化后不会自动连接服务器
     *
     * @param app
     * @param listener
     */
    @Override
    public void init(Application app, AHDTrainerListener listener) {
        this.hdListener = listener;
        setApplication(app);
        setCommonListener(listener);
        setQxBusiListener(listener);
    }

    @Override
    public void release() {
        super.release();
        this.hdListener = null;
    }

    @Override
    public synchronized void doSend(final String data) {


        CLog.d(TAG, "doSend data = " + data);

        if (getApplication() == null) {
            CLog.e(TAG, "please call init first");
            return;
        }
        if (data == null) {
            CLog.e(TAG, "data == null");
            return;
        }


        long cmd = QXMessageConverter.getInstance().getCmdFromJson(data);
        int msgtw = QXMessageConverter.getInstance().getMsgTwFromJson(data);

        if (cmd <= 0 || msgtw <= 0) {
            CLog.e(TAG, "error msg : " + cmd);
            if (hdListener != null) {
                hdListener.onSendFailed(data, CErrorCode.ERROR_SEND_PARAM_INVALIBLE);
            }
            return;
        }


        if (cmd == SDK_ICBC_POS_MULTI_PURCHASE) {

            QXMessage<HDPosMultiPurchaseResp> qxMessage = QXJsonUtils.fromJsonToQXMessage(data, HDPosMultiPurchaseResp.class);
            qxMessage = QXMessageConverter.getInstance().getBackQxMsgByFromQxMsg(qxMessage);
            final HDPosMultiPurchaseResp content = qxMessage.getContent();
            final QXMessage<HDPosMultiPurchaseResp> finalQxMessage = qxMessage;

            if (!isInsallICBC()) {
                if (hdListener != null) {
                    content.setResult(1001);
                    content.setDesc("不支持的pos机操作");
                    hdListener.onHDPosMultiPurshaesResult(finalQxMessage);
                }
                return;
            }
            hdPosMultiPurshase(content, new ICBCUtils.ICBCCallback() {
                @Override
                public void onResult(Intent data) {

                    Bundle baseBundle = data.getBundleExtra("baseResult");
                    Bundle transBundle = data.getBundleExtra("transResult");
                    Bundle extraInfo = data.getBundleExtra("extraInfo");

                    BaseResult bs = BundleUtils.toBean(baseBundle, BaseResult.class);
                    MultiPurchaseResp tb = BundleUtils.toBean(transBundle, MultiPurchaseResp.class);

                    long result = bs.RESULT;
                    final String extOrderNo = bs.EXT_ORDER_NO;
                    String description = bs.DESCRIPTION;

                    content.setResult(1);
                    TAndL.L("bs = " + bs);
                    TAndL.L("tb = " + tb);
                    content.setPosResult(result);
                    content.setDesc(description);
                    TAndL.L("result = " + result + " description = " + description);
                    if (result == 9) {

                        //调用查询接口 查询真实支付结果
                        new Handler().postDelayed(new Runnable() {
                            @Override
                            public void run() {

                                hdPosQueryTransRec(new HDPosQueryTransRecReq(extOrderNo), new ICBCUtils.ICBCCallback() {
                                    @Override
                                    public void onResult(Intent data) {

                                        Bundle old_base_result = data.getBundleExtra("OLD_BASE_RESULT");
                                        Bundle old_trans_result = data.getBundleExtra("OLD_TRANS_RESULT");

                                        BaseResult baseResult = BundleUtils.toBean(old_base_result, BaseResult.class);
                                        MultiPurchaseResp transResult = BundleUtils.toBean(old_trans_result, MultiPurchaseResp.class);

                                        TAndL.L("baseResult = " + baseResult);
                                        TAndL.L("transResult = " + transResult);

                                        content.setPosResult(baseResult.RESULT);
                                        content.setDesc(baseResult.DESCRIPTION);

                                        if (hdListener != null) {
                                            hdListener.onHDPosMultiPurshaesResult(finalQxMessage);
                                        }
                                    }
                                });
                            }
                        }, 500);
                    } else {
                        if (hdListener != null) {
                            hdListener.onHDPosMultiPurshaesResult(finalQxMessage);
                        }
                    }
                }
            });


        } else if (cmd == SDK_ICBC_POS_QUERY_TRANS_REC) {

            QXMessage<HDPosQueryTransRecResp> qxMessage = QXJsonUtils.fromJsonToQXMessage(data, HDPosQueryTransRecResp.class);
            qxMessage = QXMessageConverter.getInstance().getBackQxMsgByFromQxMsg(qxMessage);
            final HDPosQueryTransRecResp content = qxMessage.getContent();
            final QXMessage<HDPosQueryTransRecResp> finalQxMessage = qxMessage;
            if (!isInsallICBC()) {
                if (hdListener != null) {
                    content.setResult(1001);
                    content.setDesc("不支持的pos机操作");
                    hdListener.onHDPosQueryTransRecResult(finalQxMessage);
                }
                return;
            }
            hdPosQueryTransRec(content, new ICBCUtils.ICBCCallback() {
                @Override
                public void onResult(Intent data) {

                    content.setResult(1);

                    long result = data.getLongExtra("RESULT", 1);
                    String description = data.getStringExtra("DESCRIPTION");
                    TAndL.L("query result = " + result + " query desc = " + description);
                    if (result == 0) {
                        Bundle old_base_result = data.getBundleExtra("OLD_BASE_RESULT");
                        Bundle old_trans_result = data.getBundleExtra("OLD_TRANS_RESULT");
                        Bundle old_extra_info = data.getBundleExtra("OLD_EXTRA_INFO");

                        BaseResult baseResult = BundleUtils.toBean(old_base_result, BaseResult.class);
                        MultiPurchaseResp transResult = BundleUtils.toBean(old_trans_result, MultiPurchaseResp.class);
                        ExtraInfo extraInfo = BundleUtils.toBean(old_extra_info, ExtraInfo.class);

                        TAndL.L("baseResult = " + baseResult);
                        TAndL.L("transResult = " + transResult);
                        TAndL.L("transResult = " + extraInfo);
                        if (baseResult.RESULT == 0) {
                            content.setRefNo(transResult.REF_NO);
                            content.setQrCodeOrder(transResult.QRCODE_ORDER);
                            content.setAmount(transResult.AMOUNT);
                        }
                        content.setPosResult(baseResult.RESULT);
                        content.setDesc(baseResult.DESCRIPTION);

                    } else {
                        content.setPosResult(result);
                        content.setDesc(description);
                    }

                    if (hdListener != null) {
                        hdListener.onHDPosQueryTransRecResult(finalQxMessage);
                    }
                }
            });

        } else if (cmd == SDK_ICBC_POS_POS_VOID) {
            QXMessage<HDPosPosVoidResp> qxMessage = QXJsonUtils.fromJsonToQXMessage(data, HDPosPosVoidResp.class);
            qxMessage = QXMessageConverter.getInstance().getBackQxMsgByFromQxMsg(qxMessage);
            final HDPosPosVoidResp content = qxMessage.getContent();
            final QXMessage<HDPosPosVoidResp> finalQxMessage = qxMessage;
            if (!isInsallICBC()) {
                if (hdListener != null) {
                    content.setResult(1001);
                    content.setDesc("不支持的pos机操作");
                    hdListener.onHDPosVoidResult(finalQxMessage);
                }
                return;
            }
            hdPosPosVoid(content, new ICBCUtils.ICBCCallback() {
                @Override
                public void onResult(Intent data) {


                    Bundle baseResult = data.getBundleExtra("baseResult");
                    long result = baseResult.getLong("RESULT");
                    String description = baseResult.getString("DESCRIPTION");
                    String extOrderNo = baseResult.getString("EXT_ORDER_NO");

                    TAndL.L("result = " + result + " extOrderNo = " + extOrderNo + " description = " + description);

                    content.setResult(1);
                    content.setPosResult(result);
                    content.setDesc(description);

                    if (hdListener != null) {
                        hdListener.onHDPosVoidResult(finalQxMessage);
                    }
                }
            });

        } else if (cmd == SDK_ICBC_POS_QR_REFUND) {
            QXMessage<HDPosQrRefundResp> qxMessage = QXJsonUtils.fromJsonToQXMessage(data, HDPosQrRefundResp.class);
            qxMessage = QXMessageConverter.getInstance().getBackQxMsgByFromQxMsg(qxMessage);
            final HDPosQrRefundResp content = qxMessage.getContent();
            final QXMessage<HDPosQrRefundResp> finalQxMessage = qxMessage;
            if (!isInsallICBC()) {
                if (hdListener != null) {
                    content.setResult(1001);
                    content.setDesc("不支持的pos机操作");
                    hdListener.onHDPosQrRefundResult(finalQxMessage);
                }
                return;
            }
            hdPosQrRefund(content, new ICBCUtils.ICBCCallback() {
                @Override
                public void onResult(Intent data) {

                    Bundle baseResult = data.getBundleExtra("baseResult");


                    long result = baseResult.getLong("RESULT");
                    String description = baseResult.getString("DESCRIPTION");
                    String extOrderNo = baseResult.getString("EXT_ORDER_NO");

                    TAndL.L("result = " + result + " extOrderNo = " + extOrderNo + " description = " + description);

                    content.setResult(1);
                    content.setPosResult(result);
                    content.setDesc(description);

                    if (hdListener != null) {
                        hdListener.onHDPosQrRefundResult(finalQxMessage);
                    }

                }
            });
        } else if (cmd == SDK_ICBC_POS_CHECK_UPDATE) {

            QXMessage<HDPosCheckUpdateResp> qxMessage = QXJsonUtils.fromJsonToQXMessage(data, HDPosCheckUpdateResp.class);
            qxMessage = QXMessageConverter.getInstance().getBackQxMsgByFromQxMsg(qxMessage);
            final HDPosCheckUpdateResp content = qxMessage.getContent();
            final QXMessage<HDPosCheckUpdateResp> finalQxMessage = qxMessage;
            if (!isInsallICBC()) {
                if (hdListener != null) {
                    content.setResult(1001);
                    content.setDesc("不支持的pos机操作");
                    hdListener.onHDPosCheckUpdateResult(finalQxMessage);
                }
                return;
            }
            hdPosCheckUpdate(content, new ICBCUtils.ICBCCallback() {
                @Override
                public void onResult(Intent data) {

                    long result = data.getLongExtra("RESULT", 1);
                    String description = data.getStringExtra("DESCRIPTION");
                    String versionName = data.getStringExtra("VERSION_NAME");
                    long versionCode = data.getLongExtra("VERSION_CODE", 1);

                    TAndL.L("result = " + result + " description = " + description + " versionName = " + versionName + " versionCode = " + versionCode);

                    content.setResult(1);
                    content.setPosResult(result);
                    content.setDesc(description);
                    if (result == 0) {
                        content.setVersionCode(versionCode);
                        content.setVersionName(versionName);
                    }

                    if (hdListener != null) {
                        hdListener.onHDPosCheckUpdateResult(finalQxMessage);
                    }

                }
            });
        } else {
            CLog.e(TAG, "unsupport HD cmd");
            super.doSend(data);
        }

    }


    @Override
    public void hdLogin(HDLoginReq req, ICallListener callListener) {


        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdUpdateUserLoginPwd(HDUpdateUserLoginPwdReq req, ICallListener callListener) {


        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetTeamInfo(HDGetTeamInfoReq req, ICallListener callListener) {


        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetTripRecord(HDGetTripRecordReq req, ICallListener callListener) {

        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetTripDetail(HDGetTripDetailReq req, ICallListener callListener) {

        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetUserInfo(HDGetUserInfoReq req, ICallListener callListener) {

        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetBranchOffice(HDGetBranchOfficeReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetDutyRouting(HDGetDutyRoutingReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetTrainGoodsList(HDGetTrainGoodsListReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdPlacingOrder(HDPlacingOrderReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetOrderPayState(HDGetOrderPayStateReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetOrderDetail(HDGetOrderDetailReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetOrderList(HDGetOrderListReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdChangeOrderState(HDChangeOrderStateReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdPutOnOffSale(HDPutOnOffSaleReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdPosMultiPurshase(HDPosMultiPurchaseReq req, ICBCUtils.ICBCCallback callback) {
        ICBCUtils.multiPurchase(req.getAmount(), req.getOrderSn(), req.getPosPayType(), callback);
    }

    @Override
    public void hdPosQueryTransRec(HDPosQueryTransRecReq req, ICBCUtils.ICBCCallback callback) {
        ICBCUtils.queryTransRec(req.getOrderSn(), callback);
    }

    @Override
    public void hdPosCheckUpdate(HDPosCheckUpdateReq req, ICBCUtils.ICBCCallback callback) {
        ICBCUtils.checkUpdate(callback);
    }


    @Override
    public void hdPosPosVoid(HDPosPosVoidReq req, ICBCUtils.ICBCCallback callback) {
        ICBCUtils.posVoid(req.getRefNo(), req.getOrderSn(), callback);
    }

    @Override
    public void hdPosQrRefund(HDPosQrRefundReq req, ICBCUtils.ICBCCallback callback) {
        ICBCUtils.qrRefund(req.getAmount(), req.getQrCodeOrder(), req.getOrderSn(), callback);
    }

    @Override
    public void hdTrainerReviewRefund(HDTrainerReviewRefundReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetRefundList(HDGetRefundListReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetRefundDetail(HDGetRefundDetailReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdMamualDownTrip(HDManualDownTripReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdChangeTripMode(HDChangeTripModeReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetWarehouseList(HDGetWarehouseListReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdCaptainDownTrip(HDCaptainDownTripReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetWarehouseInventory(HDGetWarehouseInventoryReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);

    }

    @Override
    public void hdUse(HDUseReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);

    }

    @Override
    public void hdClearWarehouseStock(HDClearWarehouseStockReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);

    }

    @Override
    public void hdChangeShelvesMode(HDChangeShelvesModeReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdRejectionOrder(HDRejectionOrderReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetUnDoOrderNum(HDGetUnDoOrderNumReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);

    }

    @Override
    public void hdPayForOrder(HDPayForOrderReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);

    }


    private boolean isInsallICBC() {
        boolean appInstalled = CAppUtils.isAppInstalled("com.icbc.smartpos.bankpay");
        return appInstalled;
    }
}
