package cn.com.startai.qxcommon;

import cn.com.startai.qxcommon.protocol.IDeveloper;

/**
 * Created by Robin on 2019/5/12.
 * 419109715@qq.com 彬影
 */
public class QXCommonInitParam implements IDeveloper {

    private long appid;

    public QXCommonInitParam(long appid) {
        this.appid = appid;
    }


    private QXCommonInitParam(Builder builder) {
        setAppid(builder.appid);
    }

    @Override
    public String toString() {
        return "QXCommonInitParam{" +
                "appid=" + appid +
                '}';
    }

    public long getAppid() {
        return appid;
    }

    public void setAppid(long appid) {
        this.appid = appid;
    }

    public static final class Builder {
        private long appid;

        public Builder() {
        }

        public Builder appid(long val) {
            appid = val;
            return this;
        }

        public Builder huaDianParam() {
            appid = Appid.huadianTrainer;
            return this;
        }

        public QXCommonInitParam build() {
            return new QXCommonInitParam(this);
        }
    }
}
