package cn.com.startai.qxcommon;


import android.app.Application;
import android.util.Log;

import org.xutils.x;


import cn.com.startai.common.CommonSDKInterface;
import cn.com.startai.common.channel.ICallListener;
import cn.com.startai.common.utils.CAppUtils;
import cn.com.startai.common.utils.CLog;
import cn.com.startai.qxcommon.db.QXDBManager;
import cn.com.startai.qxcommon.global.ParamManager;
import cn.com.startai.qxcommon.global.QXUserManager;
import cn.com.startai.qxcommon.link.BaseData;
import cn.com.startai.qxcommon.link.Channel;
import cn.com.startai.qxcommon.link.IOutput;
import cn.com.startai.qxcommon.link.mqtt.QXMqttManager;
import cn.com.startai.qxcommon.utils.QXSpController;

/**
 * Created by Robin on 2019/5/12.
 * 419109715@qq.com 彬影
 */
public class QXCommon implements IOutput {

    public static String TAG;


    private QXCommon() {
    }

    public static QXCommon getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }


    private static class SingleTonHoulder {
        private static final QXCommon singleTonInstance = new QXCommon();
    }

    private Application app;

    private boolean isInit() {
        return app != null;
    }

    public Application getApp() {
        return app;
    }

    public void init(Application app, QXCommonInitParam initParam) {
        if (isInit()) {
            Log.e(TAG, "no need repeat init ");
            return;
        }

        this.app = app;
        x.Ext.init(app);

        QXDBManager.getInstance().init();
        CommonSDKInterface.getInstance().init(app);
        QXSpController.getInstance().init();
        if (TAG == null) {
            TAG = CAppUtils.getAppName();
        }
        CommonSDKInterface.TAG = TAG;

        if (initParam == null || initParam.getAppid() == 0) {
            Log.e(TAG, "QXCommon init failed 'qxInitParam' is empty or 'appid' is empty ");
            return;
        }
        ParamManager.getInstance().init(initParam.getAppid());
        initMqtt();

    }


    public void release() {
        CLog.d(TAG, "QXCommon release");
        releaseMqtt();
        QXDBManager.getInstance().release();
        QXSpController.getInstance().release();
        CommonSDKInterface.getInstance().release();
        app = null;
        ParamManager.getInstance().release();
        QXUserManager.getInstance().release();

    }


    private void initMqtt() {
        QXMqttManager.getInstance().init(getApp());
    }

    private void releaseMqtt() {
        QXMqttManager.getInstance().release();
    }

    @Override
    public void doSend(final BaseData baseData, final ICallListener listener) {


        if (baseData == null) {
            CLog.e(TAG, "baseData = null or baseData.data = null");
            return;
        }

        if (baseData.getChannel() == Channel.MQTT) {
            doSendMqtt(baseData, listener);
            return;
        }

        if (baseData.getChannel() == Channel.UDP) {
            doSendUdp(baseData, listener);
            return;
        }
        if (baseData.getChannel() == Channel.BLE) {
            doSendBle(baseData, listener);
            return;
        }

        if (baseData.getChannel() == Channel.ANY) {
            doSendUdp(baseData, new ICallListener() {
                @Override
                public void onSuccess() {
                    listener.onSuccess();
                }

                @Override
                public void onFailed(int i) {
                    doSendMqtt(baseData, listener);
                }
            });
        }

    }

    @Override
    public void doSendMqtt(BaseData qxMqttData, ICallListener listener) {
        QXMqttManager.getInstance().publish(qxMqttData.getTopic(), qxMqttData.getData(), listener);
    }

    @Override
    public void doSendUdp(BaseData qxudpData, ICallListener listener) {
        listener.onSuccess();
    }

    @Override
    public void doSendBle(BaseData qxbleData, ICallListener listener) {
        listener.onSuccess();
    }
}
