package cn.com.startai.qxcommon.link.mqtt;


import android.net.NetworkInfo;
import android.util.Log;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

import cn.com.startai.common.CommonSDKInterface;
import cn.com.startai.common.channel.CErrorCode;
import cn.com.startai.common.channel.CallbackManager;
import cn.com.startai.common.channel.ICallListener;
import cn.com.startai.common.channel.mqtt.IMqtt;
import cn.com.startai.common.channel.mqtt.MqttConnectState;
import cn.com.startai.common.channel.mqtt.MqttParam;
import cn.com.startai.common.channel.mqtt.event.IMqttListener;
import cn.com.startai.common.utils.CLog;
import cn.com.startai.common.utils.CThreadPoolUtils;
import cn.com.startai.common.utils.network.CNetworkManager;
import cn.com.startai.common.utils.network.INetworkListener;
import cn.com.startai.qxcommon.event.QXEventDispatcher;
import cn.com.startai.qxcommon.global.ParamManager;
import cn.com.startai.qxcommon.global.QXUserManager;
import cn.com.startai.qxcommon.link.ABusiHandler;
import cn.com.startai.qxcommon.link.BaseData;
import cn.com.startai.qxcommon.link.Channel;
import cn.com.startai.qxcommon.link.mqtt.busi.MqttBusiHandler;
import cn.com.startai.qxcommon.link.mqtt.busi.bean.ActivateReq;
import cn.com.startai.qxcommon.link.mqtt.busi.bean.ActivateResp;
import cn.com.startai.qxcommon.link.mqtt.busi.bean.GetBrokerHostReq;
import cn.com.startai.qxcommon.link.mqtt.busi.bean.GetBrokerHostResp;
import cn.com.startai.qxcommon.link.mqtt.busi.bean.UpdateDeviceInfoReq;
import cn.com.startai.qxcommon.link.mqtt.busi.bean.UpdateDeviceInfoResp;
import cn.com.startai.qxcommon.link.mqtt.event.IMqttBusiListener;
import cn.com.startai.qxcommon.link.mqtt.event.MqttHeartListener;
import cn.com.startai.qxcommon.protocol.QXDataCreater;
import cn.com.startai.qxcommon.protocol.QXMessage;
import cn.com.startai.qxcommon.utils.QXSpController;
import cn.com.startai.qxcommon.utils.location.AreaLocation;
import cn.com.startai.qxcommon.utils.location.QXLocationManager;

import static cn.com.startai.qxcommon.QXCommon.TAG;


/**
 * Created by Robin on 2019/5/12.
 * 419109715@qq.com 彬影
 */
public class QXMqttManager implements IMqttListener, INetworkListener, IMqttBusiListener {

    private IMqtt mqtt;
    private ABusiHandler busiHandler;
    private ScheduledExecutorService workThreadPool;
    private ScheduledFuture<?> scheduleCheckThirdCloudAppid;
    private ScheduledFuture<?> scheduleCheckAreNode;
    private ScheduledFuture<?> scheduleReportIp;
    private ScheduledFuture<?> scheduleCheckActivate;
    private ScheduledFuture<?> scheduleSubUserOrSnTopic;
    private MqttHeartListener heartListener;
    private int subCount;


    private QXMqttManager() {
    }

    public static QXMqttManager getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }


    private static class SingleTonHoulder {
        private static final QXMqttManager singleTonInstance = new QXMqttManager();
    }

    public void doSend(BaseData baseData, ICallListener callListener) {

        Channel channel = baseData.getChannel();
        if (channel != Channel.MQTT) {
            CLog.e(TAG, "error channel");
            return;
        }
        publish(baseData.getTopic(), baseData.getData(), callListener);
    }

    public void publish(String topic, byte[] bytes, ICallListener iCallListener) {
        if (mqtt != null) {
            mqtt.publish(topic, bytes, iCallListener);
        } else {
            CallbackManager.callbackCallResult(false, iCallListener, CErrorCode.ERROR_SEND_CLIENT_DISCONNECT);
        }
    }

    public void subscribe(List<String> list, ICallListener iCallListener) {
        if (mqtt != null) {
            mqtt.subscribe(list, iCallListener);
        } else {
            CallbackManager.callbackCallResult(false, iCallListener, CErrorCode.ERROR_SUB_NO_CONN);
        }
    }

    public void subscribeSync(List<String> list, ICallListener iCallListener) {
        if (mqtt != null) {
            mqtt.subscribeSync(list, iCallListener);
        } else {
            CallbackManager.callbackCallResult(false, iCallListener, CErrorCode.ERROR_SUB_NO_CONN);
        }
    }

    public void unSubscribe(List<String> list, ICallListener iCallListener) {
        if (mqtt != null) {
            mqtt.unSubscribe(list, iCallListener);
        } else {
            CallbackManager.callbackCallResult(false, iCallListener, CErrorCode.ERROR_UNSUB_NO_CONN);
        }
    }

    public MqttConnectState getMqttConnectState() {
        if (mqtt != null) {
            return mqtt.getMqttConnectState();
        }
        return MqttConnectState.DISCONNECTED;
    }

    public void init() {

        workThreadPool = CThreadPoolUtils.getInstance().getWorkThreadPool();
        busiHandler = new MqttBusiHandler(this);
        heartListener = new MqttHeartListener();

        workThreadPool.execute(new Runnable() {
            @Override
            public void run() {

                QXMqttHostManager.getInstance().getOptimalHost(new QXMqttHostManager.OnGetOptimalHostListener() {
                    @Override
                    public void onGetOptimalHost(String[] hosts) {
                        toInit(hosts);
                    }
                });
            }
        });
    }

    private void toInit(final String[] hosts) {

        CNetworkManager.getInstance().addNetworkListener(this);

        MqttParam build = new MqttParam.Builder()
                .cleanSession(QXMqttConfig.CLEANSESSION)
                .mqusername(QXMqttConfig.USERNAME)
                .mqpassword(QXMqttConfig.PASSWORD)
                .keepAliveInterval(QXMqttConfig.KEEPALIVEINTERVAL)
                .isCheckCrt(QXMqttConfig.ISCHECKCRT)
                .crtPath(QXMqttConfig.CRTPATH)
                .crtPassword(QXMqttConfig.CRTPASSWORD)
                .connectTimeOut(QXMqttConfig.CONNECTTIMEOUT)
                .clientId(ParamManager.getInstance().getSn() + "")
                .hosts(hosts)
                .mqttListener(this)
                .heartListener(heartListener)
                .build();

        mqtt = CommonSDKInterface.getInstance().initMqtt(build);

    }


    public void release() {
        CLog.d(TAG, "QXMqttManager release");
        if (mqtt != null) {
            mqtt.release();
            mqtt = null;
        }
        QXMqttHostManager.getInstance().release();
        QXLocationManager.getInstance().release();

        if (scheduleCheckThirdCloudAppid != null) {
            scheduleCheckThirdCloudAppid.cancel(true);
            scheduleCheckThirdCloudAppid = null;
        }

        if (scheduleCheckAreNode != null) {
            scheduleCheckAreNode.cancel(true);
            scheduleCheckAreNode = null;
        }

        if (scheduleReportIp != null) {
            scheduleReportIp.cancel(true);
            scheduleReportIp = null;
        }

        if (scheduleCheckActivate != null) {
            scheduleCheckActivate.cancel(true);
            scheduleCheckActivate = null;
        }

        if (scheduleSubUserOrSnTopic != null) {
            scheduleSubUserOrSnTopic.cancel(true);
            scheduleSubUserOrSnTopic = null;
        }

        if (busiHandler != null) {
            busiHandler = null;
        }

    }

    // ---------------------- IMqttListener start ----------------------
    @Override
    public void onMqttConnected(String host, String clientId) {
        boolean isActivite = QXSpController.getInstance().getIsActivite();
        subUserOrSnTopic();
        QXUserManager.getInstance().checkNeedToUnsubUserTopic();
        if (isActivite) {
            doOnMqttConnected(host);
        } else {
            checkActivate();
        }
    }


    @Override
    public void onMqttDisconnected(int errorCode) {
        QXEventDispatcher.getInstance().onServerDisconnected(errorCode);
    }

    @Override
    public void onMqttMessageArrived(String s, byte[] bytes) {
        BaseData baseData = new BaseData.Builder()
                .data(bytes)
                .topic(s)
                .channelMqtt()
                .build();

        if (busiHandler != null && busiHandler.handlerMessage(baseData)) {
            return;
        }
        QXEventDispatcher.getInstance().onMessageArrived(baseData);
    }

    // ---------------------- IMqttListener end ----------------------


    // ---------------------- INetworkListener start ----------------------

    @Override
    public void onWifiConnected() {

    }

    @Override
    public void onMobileConnected() {

    }

    @Override
    public void onEthernetConnected() {

    }

    @Override
    public void onUnkownNetwork() {

    }

    @Override
    public void onNetworkStateChange(String s, NetworkInfo.State state) {
        QXLocationManager.getInstance().onNetworkChange();
    }
    // ---------------------- INetworkListener end ----------------------


    // ---------------------- IMqttBusiListener start ----------------------

    @Override
    public void onActivateResult(QXMessage<ActivateResp> resp) {
        if (resp == null || resp.getContent() == null) {
            CLog.e(TAG, "data error");
            return;
        }
        CLog.e(TAG, "Activate result " + resp.getContent().getResult());
        if (resp.getContent().getResult() == ActivateResp.SUCCESS) {

            ParamManager.getInstance().onActivate(resp.getContent());


            doOnMqttConnected(mqtt.getHost());
        }
    }


    @Override
    public void onUpdateDeviceInfoResult(QXMessage<UpdateDeviceInfoResp> resp) {
        if (resp == null) {
            CLog.e(TAG, "data error");
            return;
        }
        CLog.d(TAG, "update device info result " + resp.getContent().getResult());

    }

    @Override
    public void onGetBrokerHostResult(QXMessage<GetBrokerHostResp> resp) {
        if (resp == null || resp.getContent() == null) {

            CLog.e(TAG, "data error");
            return;
        }
        CLog.d(TAG, "get broker host result " + resp.getContent().getResult());

        if (resp.getContent().getResult() == 1) {
            doOnGetBrokerHostResult(resp.getContent());
        } else {
            CLog.e(TAG, "get broker host failed ");
        }

    }

    // ---------------------- IMqttBusiListener end ----------------------

    private void doOnMqttConnected(String host) {
        QXEventDispatcher.getInstance().onServerConnected(host);
        QXMqttHostManager.getInstance().onServerConnected(host);
        checkAreNode();
        reportIp();
        heartListener.onReset();
    }


    private synchronized void reportIp() {
        cancelScheduledFuture(scheduleReportIp);
        scheduleReportIp = workThreadPool.schedule(new Runnable() {
            @Override
            public void run() {
                QXLocationManager.getInstance().getLocation(new QXLocationManager.LocationCallback() {
                    @Override
                    public void onLocationSuccess(AreaLocation location) {
                        if (location != null) {
                            CLog.d(TAG, "report ip " + location.getQuery());

                            UpdateDeviceInfoReq req = new UpdateDeviceInfoReq(ParamManager.getInstance().getSn(), new UpdateDeviceInfoReq.StatusParam(location.getQuery()));

                            QXMessage<UpdateDeviceInfoReq> updateDeviceInfoQXMsg = QXDataCreater.getUpdateDeviceInfoQXMsg(req);
                            BaseData cloudBaseData = QXDataCreater.getCloudBaseData(updateDeviceInfoQXMsg);
                            doSend(cloudBaseData, null);
                        }
                    }

                    @Override
                    public void onLocationFailed() {

                    }
                });
            }
        }, 100, TimeUnit.MILLISECONDS);


    }


    private void checkActivate() {

        cancelScheduledFuture(scheduleCheckActivate);
        scheduleCheckActivate = workThreadPool.scheduleAtFixedRate(new Runnable() {
            @Override
            public void run() {
                boolean isActivite = QXSpController.getInstance().getIsActivite();
                if (!isActivite) {
                    CLog.e(TAG, "Device is not activate , ready to activate");
                    QXMessage<ActivateReq> activateQXMsg = QXDataCreater.getActivateQXMsg(null);
                    BaseData cloudBaseData = QXDataCreater.getCloudBaseData(activateQXMsg);
                    doSend(cloudBaseData, null);
                } else {
                    CLog.d(TAG, "Device is normal activate");
                    cancelScheduledFuture(scheduleCheckActivate);
                }
            }
        }, 0, 60 * 1000, TimeUnit.MILLISECONDS);


    }

    public String getHost() {
        return mqtt.getHost();
    }

    public void checkAreNode() {
        cancelScheduledFuture(scheduleCheckAreNode);
        scheduleCheckAreNode = workThreadPool.schedule(new Runnable() {
            @Override
            public void run() {

                boolean isNeedToGetBrokerHost = false;
                //获取上次同步 区域节点的时间， 如果 大于 设定值就去同步一下
                long lastTime = QXSpController.getInstance().getLastGetBrokerHostrespTime(); //上次同步时间
                GetBrokerHostResp spBrokerHost = QXMqttHostManager.getInstance().getSpBrokerHost();

                if (lastTime == 0 || spBrokerHost == null) {
                    isNeedToGetBrokerHost = true;
                } else {
                    int syncCycle = spBrokerHost.getCycle() * 1000; //同步周期


                    long peroid = System.currentTimeMillis() - lastTime;
                    CLog.d(TAG, "last get broker host time  = " + lastTime + " , syncCycle = " + syncCycle + " , peroid = " + peroid);
                    if (peroid >= syncCycle) {
                        CLog.d(TAG, "Has get broker host info,but it is time to reGet");
                        isNeedToGetBrokerHost = true;
                    } else {
                        CLog.d(TAG, "Time is not up, no need to synchronization ");
                        long delay = syncCycle - peroid;
                        CLog.d(TAG, "after " + delay + " ms to synchronization");

                        cancelScheduledFuture(scheduleCheckAreNode);
                        scheduleCheckAreNode = workThreadPool.schedule(new Runnable() {
                            @Override
                            public void run() {
                                checkAreNode();
                            }
                        }, delay + 1000, TimeUnit.MILLISECONDS);

                    }
                }


                if (isNeedToGetBrokerHost) {
                    QXLocationManager.getInstance().getLocation(new QXLocationManager.LocationCallback() {
                        @Override
                        public void onLocationSuccess(AreaLocation location) {
                            if (location != null) {

                                QXMessage<GetBrokerHostReq> brokerHostQXMsg = QXDataCreater.getBrokerHostQXMsg(new GetBrokerHostReq(location.getQuery()));
                                BaseData cloudBaseData = QXDataCreater.getCloudBaseData(brokerHostQXMsg);
                                doSend(cloudBaseData, null);
                            }
                        }

                        @Override
                        public void onLocationFailed() {

                        }
                    });

                }

            }
        }, 0, TimeUnit.MILLISECONDS);
    }


    public void changeHost() {

        QXMqttHostManager.getInstance().getOptimalHost(new QXMqttHostManager.OnGetOptimalHostListener() {
            @Override
            public void onGetOptimalHost(String[] hosts) {

                if (mqtt != null && mqtt.getMqttConnectState() == MqttConnectState.CONNECTED) {
                    mqtt.changeHost(hosts, new ICallListener() {
                        @Override
                        public void onSuccess() {
                            CLog.d(TAG, "change host success");
                        }

                        @Override
                        public void onFailed(int i) {
                            CLog.e(TAG, "change host failed " + i);
                        }
                    });
                }
            }
        });
    }


    /**
     * 订阅用户及sn相关主题
     */
    private void subUserOrSnTopic() {

        final List<String> topics = new ArrayList<>();

        if (mqtt != null && mqtt.getMqttConnectState() == MqttConnectState.CONNECTED) {

            String snTopic = TopicManager.getInstance().getSnSubTopic();

            topics.add(snTopic);

            long userId = QXUserManager.getInstance().getUserId();
            if (userId != 0) {
                String userTopic = TopicManager.getInstance().getUserSubTopic(userId);
                topics.add(userTopic);
            }

            if (topics.size() > 0) {
                subscribeSync(topics, new ICallListener() {
                    @Override
                    public void onSuccess() {

                    }

                    @Override
                    public void onFailed(int error) {
                        cancelScheduledFuture(scheduleSubUserOrSnTopic);
                        scheduleSubUserOrSnTopic = workThreadPool.schedule(new Runnable() {
                            @Override
                            public void run() {
                                subCount++;
                                if (subCount < 5) {
                                    subUserOrSnTopic();
                                } else {
                                    subCount = 0;
                                }
                            }
                        }, 3 * 1000, TimeUnit.MILLISECONDS);
                    }
                });
            } else {
                Log.e(TAG, "topics has aready sub ");
            }
        }
    }

    private void cancelScheduledFuture(ScheduledFuture schedule) {
        if (schedule != null && !schedule.isCancelled()) {
            schedule.cancel(true);
        }
    }

    public IMqtt getClient() {
        return mqtt;
    }

    private void doOnGetBrokerHostResult(GetBrokerHostResp areaNodes) {

        int cycle;
        int size = areaNodes.getNode().size();
        if (size == 0) {
            CLog.d(TAG, "Did not get the node information, get again after 60 seconds");
            cycle = 60;
        } else {

            //保存 节点信息
            QXMqttHostManager.getInstance().setSpBrokerHost(areaNodes);
            //保存此次获取节点信息的时候， sdk会在每次重启后去判断这个时间是否大于更新周期，如果大于周期则重新获取
            QXSpController.getInstance().setLastGetBrokerHostrespTime(System.currentTimeMillis());

            cycle = areaNodes.getCycle();
            List<GetBrokerHostResp.NodeBean> nodes = areaNodes.getNode();

            boolean isNeedChangHost = false;

            String currentConnUrl = mqtt.getHost();

            for (GetBrokerHostResp.NodeBean nodeBean : nodes) {
                //当前连接的节点权值已经为0，不可用 需要立即切换节点
                if (nodeBean.getWeight() <= 0 && nodeBean.getServerDomain().equals(currentConnUrl)) {
                    isNeedChangHost = true;
                }
            }

            GetBrokerHostResp cacheAreaNodes = QXMqttHostManager.getInstance().getCacheBrokerHost();
            if (cacheAreaNodes == null) {
                QXMqttHostManager.getInstance().setCacheBrokerHost(areaNodes);
            }

            if (isNeedChangHost) {
                for (GetBrokerHostResp.NodeBean nb : cacheAreaNodes.getNode()) {
                    if (nb.getServerDomain().equals(currentConnUrl)) {
                        nb.setWeight(0);
                        CLog.d(TAG, "current broker host weight is 0 ,  can not use,change node right now");
                        changeHost();
                        break;
                    }
                }
            }
        }

        cancelScheduledFuture(scheduleCheckAreNode);
        scheduleCheckAreNode = workThreadPool.schedule(new Runnable() {
            @Override
            public void run() {
                QXLocationManager.getInstance().getLocation(new QXLocationManager.LocationCallback() {
                    @Override
                    public void onLocationSuccess(AreaLocation location) {
                        if (location != null) {
                            QXMessage<GetBrokerHostReq> brokerHostQXMsg = QXDataCreater.getBrokerHostQXMsg(new GetBrokerHostReq(location.getQuery()));
                            BaseData cloudBaseData = QXDataCreater.getCloudBaseData(brokerHostQXMsg);
                            doSend(cloudBaseData, null);
                        }
                    }

                    @Override
                    public void onLocationFailed() {

                    }
                });

            }
        }, cycle * 1000, TimeUnit.MILLISECONDS);

    }
}
