package cn.com.startai.qxcommon.link;


import cn.com.startai.qxcommon.link.mqtt.TopicManager;

/**
 * Created by Robin on 2019/3/20.
 * 419109715@qq.com 彬影
 */
public class BaseData {

    private String ip;
    private int port;
    private String topic;
    private byte[] data;
    private Channel channel;


    @Override
    public String toString() {
        return "BaseData{" +
                "ip='" + ip + '\'' +
                ", port=" + port +
                ", topic='" + topic + '\'' +
                ", data=" + new String(data) +
                ", channel=" + channel +
                '}';
    }



    public String getIp() {
        return ip;
    }

    public int getPort() {
        return port;
    }

    public String getTopic() {
        return topic;
    }

    public byte[] getData() {
        return data;
    }

    public Channel getChannel() {
        return channel;
    }

    private BaseData(Builder builder) {
        ip = builder.ip;
        port = builder.port;
        topic = builder.topic;
        data = builder.data;
        channel = builder.channel;
    }


    public static final class Builder {
        private String ip;
        private int port;
        private String topic;
        private byte[] data;
        private Channel channel = Channel.ANY;

        public Builder() {
        }

        public Builder ip(String val) {
            ip = val;
            return this;
        }


        public Builder port(int val) {
            port = val;
            return this;
        }

        public Builder topic(String val) {
            topic = val;
            return this;
        }

        public Builder topicThirdCloud() {
            topic = TopicManager.getInstance().getThirdCloudPubTopic();
            return this;
        }

        public Builder topicCloud() {
            topic = TopicManager.getInstance().getCloudPubTopic();
            return this;
        }

        public Builder topicClient(long sn) {
            topic = TopicManager.getInstance().getClientPubTopic(sn);
            return this;
        }


        public Builder data(byte[] val) {
            data = val;
            return this;
        }

        public Builder dataString(String val) {
            data = val.getBytes();
            return this;
        }

        public Builder channel(Channel val) {
            channel = val;
            return this;
        }

        public Builder channelAny() {
            channel = Channel.ANY;
            return this;
        }

        public Builder channelBle() {
            channel = Channel.BLE;
            return this;
        }

        public Builder channelMqtt() {
            channel = Channel.MQTT;
            return this;
        }

        public Builder channelUdp() {
            channel = Channel.UDP;
            return this;
        }


        public BaseData build() {
            return new BaseData(this);
        }
    }
}
