package cn.com.startai.qxcommon.busi.qx;


import cn.com.startai.common.utils.CLog;
import cn.com.startai.common.utils.network.INetworkListener;
import cn.com.startai.qxcommon.event.IQXCommonListener;
import cn.com.startai.qxcommon.link.BaseData;
import cn.com.startai.qxcommon.protocol.QXMessageConverter;

import static cn.com.startai.qxcommon.QXCommon.TAG;

/**
 * Created by Robin on 2019/5/23.
 * 419109715@qq.com 彬影
 */
public abstract class AQXBusiListener implements INetworkListener, IQXCommonListener {


    private int msgtw;
    private long cmd;
    private String json;

    public String getJson() {
        return json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public int getMsgtw() {
        return msgtw;
    }

    public void setMsgtw(int msgtw) {
        this.msgtw = msgtw;
    }

    public long getCmd() {
        return cmd;
    }

    public void setCmd(long cmd) {
        this.cmd = cmd;
    }

    public abstract void onQXLogoutResult(boolean result);

    public abstract void onQXGetUserInfoResult();

    @Override
    public void onMessageArrived(BaseData baseData) {

        json = new String(baseData.getData());
        cmd = QXMessageConverter.getInstance().getCmdFromJson(json);
        msgtw = QXMessageConverter.getInstance().getMsgTwFromJson(json);
        CLog.d(TAG, "cmd = " + cmd + " msgtw = " + msgtw);

    }

    public abstract void onQXActivateResult();

    public abstract void onQXLoginResult();


}
