package cn.com.startai.qxcommon.utils.gson;

import com.google.gson.Gson;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

import cn.com.startai.qxcommon.protocol.QXBaseContent;
import cn.com.startai.qxcommon.protocol.QXMessage;

public class QXJsonUtils {
    static Gson gson = new Gson();

    public QXJsonUtils() {
    }

    public static String toJson(Object obj) {
        try {
            return gson.toJson(obj);
        } catch (Exception var2) {
            var2.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> fromJson(String strJson) {
        try {
            return (Map) gson.fromJson(strJson, Map.class);
        } catch (Exception var2) {
            var2.printStackTrace();
            return null;
        }
    }

    public static <T> T fromJson(String json, Class<T> tClass) {
        try {
            return gson.fromJson(json, tClass);
        } catch (Exception var3) {
            var3.printStackTrace();
            return null;
        }
    }

    public static <T extends QXBaseContent> QXMessage<T> fromJsonToQXMessage(String json, Class<T> tClass) {

        try {
            Type ty = new ParameterizedTypeImpl(QXMessage.class, new Type[]{tClass});
            QXMessage<T> data = gson.fromJson(json, ty);
            return data;
        } catch (Exception var3) {
            var3.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> fromJsonToList(String json, Class<T> tClass) {

        try {
            Type ty = new ParameterizedTypeListImpl(tClass);
            List<T> data = gson.fromJson(json, ty);
            return data;
        } catch (Exception var3) {
            var3.printStackTrace();
            return null;
        }
    }

    public static boolean isCorrectJson(String json, Class tClass) {
        Field[] fs = tClass.getDeclaredFields();

        for (int i = 0; i < fs.length; ++i) {
            String name = fs[i].getName();
            if (!json.contains(name)) {
                return false;
            }
        }

        return true;
    }

}
