package cn.com.startai.qxcommon.protocol;

import android.text.TextUtils;

import java.util.HashMap;
import java.util.Map;

import cn.com.startai.common.utils.CLog;

import static cn.com.startai.qxcommon.QXCommon.TAG;

/**
 * 消息转换类
 * Created by Robin on 2019/5/24.
 * 419109715@qq.com 彬影
 */
public class QXMessageConverter {

    private QXMessageConverter() {
    }

    public static QXMessageConverter getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }


    private static class SingleTonHoulder {
        private static final QXMessageConverter singleTonInstance = new QXMessageConverter();
    }


    public <T extends QXBaseContent> QXMessage<T> getBackQxMsgByFromQxMsg(QXMessage<T> from) {

        QXMessage<T> qxMessage = new QXMessage<T>().new Builder()
                .from(from.getTo())
                .to(from.getFrom())
                .appid(from.getAppid())
                .ver(from.getVer())
                .session(from.getSession())
                .ts(System.currentTimeMillis())
                .msgtw(from.getMsgtw())
                .content(from.getContent())
                .build();

        return qxMessage;
    }


    public long getCmdFromJson(String json) {

        String fromJson = getFromJson(json, MiofTag.TAG_CMD);
        if (TextUtils.isEmpty(fromJson)) {
            return 0;
        } else {
            return Long.parseLong(fromJson);
        }
    }

    public int getMsgTwFromJson(String json) {

        String fromJson = getFromJson(json, MiofTag.TAG_MSGTW);
        if (TextUtils.isEmpty(fromJson)) {
            return 0;
        } else {
            return Integer.parseInt(fromJson);
        }
    }

    public String getFromJson(String json, String tag) {

        String str = "";

        String subTag = "\"" + tag + "\"";

        try {
            String substring = json.substring(json.indexOf(subTag) + subTag.length());
            int endIndex;

            int endIndex1 = substring.indexOf(",");
            int endIndex2 = substring.indexOf("}");

            if (endIndex1 > 0 && endIndex2 > 0) {
                endIndex = Math.min(endIndex1, endIndex2);
            } else {
                endIndex = Math.max(endIndex1, endIndex2);
            }

            str = substring.substring(substring.indexOf(":") + 1, endIndex).trim().replace("\"", "");

        } catch (Exception e) {
            CLog.e(TAG, "get cmd error");
        }
        return str;
    }


}
