package cn.com.startai.qxcommon.global;

import cn.com.startai.qxcommon.link.mqtt.TopicManager;
import cn.com.startai.qxcommon.link.mqtt.busi.bean.ActivateResp;
import cn.com.startai.qxcommon.protocol.IDeveloper;
import cn.com.startai.qxcommon.utils.QXSpController;
import cn.com.startai.qxcommon.utils.SnUtils;

/**
 * Created by Robin on 2019/5/12.
 * 419109715@qq.com 彬影
 */
public class ParamManager extends DeveloperParam implements IDeveloper {


    private ParamManager() {
    }

    public static ParamManager getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }


    private static class SingleTonHoulder {
        private static final ParamManager singleTonInstance = new ParamManager();
    }


    public void init(long appid) {
        initParam(appid);
    }

    public void release() {
        this.appid = 0;
        this.product = 0;
        this.custom = 0;
        this.tagToService = 0;
        this.userId = 0;
        this.sn = 0;
        this.thirdCloudAppid = 0;
    }

    private void initParam(long appid) {
        setAppid(appid);
        setProduct(QXSpController.getInstance().getProduct());
        setCustom(QXSpController.getInstance().getCustom());
        setUserId(QXUserManager.getInstance().getUserId());
        setSn(SnUtils.getInstance().getSn());
        setThirdCloudAppid(QXSpController.getInstance().getThirdCloudAppid());
        setTagToService(SnUtils.getInstance().getQXEncodeHash(TopicManager.CLOUD_TOID));
    }


    public void onActivate(ActivateResp resp) {

        QXSpController.getInstance().setIsActivite(true);

        setProduct(resp.getProduct());
        setCustom(resp.getCustom());
        setThirdCloudAppid(resp.getThirdCloudAppid());

        QXSpController.getInstance().setProduct(product);
        QXSpController.getInstance().setCustom(custom);
        QXSpController.getInstance().setThirdCloudAppid(thirdCloudAppid);
    }


}
