package cn.com.startai.qxcommon.db;

import android.text.TextUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xutils.db.annotation.Column;
import org.xutils.db.annotation.Table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import cn.com.startai.common.utils.CLog;

import static cn.com.startai.qxcommon.QXCommon.TAG;


/**
 * Created by Robin on 2018/10/16.
 * qq: 419109715 彬影
 */

@Table(name = UserBean.TABLE_NAME)
public class UserBean implements Serializable {

    public static final String TABLE_NAME = "UserBean";

    @Column(name = F_ID, isId = true)
    private long _id; //自增 不参与业务
    public static final String F_ID = "_id";

    @Column(name = F_USERID)
    private long userId; //userid
    public static final String F_USERID = "userId";

    @Column(name = F_UPDATETIME)
    private String updateTime;
    public static final String F_UPDATETIME = "updateTime";

    @Column(name = F_CREATETIME)
    private String createTime; //
    public static final String F_CREATETIME = "createTime";

    @Column(name = F_TOKEN)
    private String token; //token
    public static final String F_TOKEN = "token";

    @Column(name = F_EXPIREIN)
    private long expire_in; //expire_in //时效单位 分钟
    public static final String F_EXPIREIN = "expire_in";

    @Column(name = F_TYPE)
    private long type; //type 登录类型
    public static final String F_TYPE = "type";

    @Column(name = F_USERNAME)
    private String userName;
    public static final String F_USERNAME = "userName";

    @Column(name = F_BIRTHDAY)
    private String birthday;
    public static final String F_BIRTHDAY = "birthday";

    @Column(name = F_PROVINCE)
    private String province;
    public static final String F_PROVINCE = "province";

    @Column(name = F_CITY)
    private String city;
    public static final String F_CITY = "city";

    @Column(name = F_TOWN)
    private String town;
    public static final String F_TOWN = "town";

    @Column(name = F_ADDRESS)
    private String address;
    public static final String F_ADDRESS = "address";

    @Column(name = F_NICKNAME)
    private String nickName;
    public static final String F_NICKNAME = "nickName";

    @Column(name = F_HEADPIC)
    private String headPic;
    public static final String F_HEADPIC = "headPic";

    @Column(name = F_SEX)
    private int sex;
    public static final String F_SEX = "sex";

    @Column(name = F_FIRSTNAME)
    private String firstName;
    public static final String F_FIRSTNAME = "firstName";

    @Column(name = F_LASTNAME)
    private String lastName;
    public static final String F_LASTNAME = "lastName";

    @Column(name = F_EMAIL)
    private String email;
    public static final String F_EMAIL = "email";

    @Column(name = F_MOBILE)
    private String mobile;
    public static final String F_MOBILE = "mobile";

    @Column(name = F_ISHAVEPWD)
    private int isHavePwd;
    public static final String F_ISHAVEPWD = "isHavePwd";


    @Column(name = F_LOGINSTATUS)
    private int loginStatus;
    public static final String F_LOGINSTATUS = "loginStatus";

    @Column(name = F_WORKSTATUS)
    private int workStatus;
    public static final String F_WORKSTATUS = "workStatus";

    @Column(name = F_NATION)
    private String nation;
    public static final String F_NATION = "nation";

    @Column(name = F_IDNUMBER)
    private String idNumber;
    public static final String F_IDNUMBER = "idNumber";

    @Column(name = F_ENTRYTIME)
    private String entryTime;
    public static final String F_ENTRYTIME = "entryTime";

    @Column(name = F_AUTHSECRET)
    private String authSecret;
    public static final String F_AUTHSECRET = "authSecret";

    @Column(name = F_CELLPHONENUMBER)
    private String cellPhoneNumber;
    public static final String F_CELLPHONENUMBER = "cellPhoneNumber";

    @Column(name = F_REALNAME)
    private String realName;
    public static final String F_REALNAME = "realName";

    @Column(name = F_REMARKS)
    private String remarks;
    public static final String F_REMARKS = "realName";

    @Column(name = F_UPDATENAME)
    private String updateName;
    public static final String F_UPDATENAME = "updateName";

    @Column(name = F_CREATENAME)
    private String createName;
    public static final String F_CREATENAME = "createName";


    @Column(name = F_ADDTIME)
    private long addTime;
    public static final String F_ADDTIME = "addTime";


    @Column(name = F_JOBNUM)
    private String jobNum;
    public static final String F_JOBNUM = "jobNum";

    @Column(name = F_BRANCHOFFICENAME)
    private String branchOfficeName;
    public static final String F_BRANCHOFFICENAME = "branchOfficeName";

    @Column(name = F_PASSENGERSECTIONNAME)
    private String passengerSectionName;
    public static final String F_PASSENGERSECTIONNAME = "passengerSectionName";

    @Column(name = F_RAILWAYBUREAUNAME)
    private String railwayBureauName;
    public static final String F_RAILWAYBUREAUNAME = "railwayBureauName";

    @Column(name = F_LASTMODIFY)
    private long lastModify;
    public static final String F_LASTMODIFY = "lastModify";

    @Column(name = F_THIRDINFOS)
    private String thirdInfos;
    public static final String F_THIRDINFOS = "thirdInfos";

    @Column(name = F_GRADUATESCHOOL)
    private String graduateSchool;
    public static final String F_GRADUATESCHOOL = "graduateSchool";

    @Column(name = F_EDUCATIONLEVEL)
    private String educationLevel;
    public static final String F_EDUCATIONLEVEL = "educationLevel";

    @Column(name = F_MAJOR)
    private String major;
    public static final String F_MAJOR = "major";

    @Column(name = F_SHELVES_MODE)
    private int shelvesMode;
    public static final String F_SHELVES_MODE = "shelvesMode";

    @Column(name = F_POSTINFOS)
    private String postInfos;
    public static final String F_POSTINFOS = "postInfos";

    private List<PostInfoBean> postInfoList;

    private List<ThirdInfosBean> thirdInfoList;


    @Override
    public String toString() {
        return "UserBean{" +
                "_id=" + _id +
                ", userId=" + userId +
                ", updateTime='" + updateTime + '\'' +
                ", createTime='" + createTime + '\'' +
                ", token='" + token + '\'' +
                ", expire_in=" + expire_in +
                ", type=" + type +
                ", userName='" + userName + '\'' +
                ", birthday='" + birthday + '\'' +
                ", province='" + province + '\'' +
                ", city='" + city + '\'' +
                ", town='" + town + '\'' +
                ", address='" + address + '\'' +
                ", nickName='" + nickName + '\'' +
                ", headPic='" + headPic + '\'' +
                ", sex=" + sex +
                ", firstName='" + firstName + '\'' +
                ", lastName='" + lastName + '\'' +
                ", email='" + email + '\'' +
                ", mobile='" + mobile + '\'' +
                ", isHavePwd=" + isHavePwd +
                ", loginStatus=" + loginStatus +
                ", workStatus=" + workStatus +
                ", nation='" + nation + '\'' +
                ", idNumber='" + idNumber + '\'' +
                ", entryTime='" + entryTime + '\'' +
                ", authSecret='" + authSecret + '\'' +
                ", cellPhoneNumber='" + cellPhoneNumber + '\'' +
                ", realName='" + realName + '\'' +
                ", remarks='" + remarks + '\'' +
                ", updateName='" + updateName + '\'' +
                ", createName='" + createName + '\'' +
                ", addTime=" + addTime +
                ", jobNum='" + jobNum + '\'' +
                ", branchOfficeName='" + branchOfficeName + '\'' +
                ", passengerSectionName='" + passengerSectionName + '\'' +
                ", railwayBureauName='" + railwayBureauName + '\'' +
                ", lastModify=" + lastModify +
                ", thirdInfos='" + thirdInfos + '\'' +
                ", graduateSchool='" + graduateSchool + '\'' +
                ", educationLevel='" + educationLevel + '\'' +
                ", major='" + major + '\'' +
                ", shelvesMode=" + shelvesMode +
                ", postInfos='" + postInfos + '\'' +
                ", postInfoList=" + postInfoList +
                ", thirdInfoList=" + thirdInfoList +
                '}';
    }

    public int getShelvesMode() {
        return shelvesMode;
    }

    public void setShelvesMode(int shelvesMode) {
        this.shelvesMode = shelvesMode;
    }

    public UserBean() {
    }

    public boolean isExpired(long loginExpiredInPeroid) {
        long peroid = System.currentTimeMillis() - addTime;
        CLog.d(TAG, "user isExpired peroid = " + peroid);
        return peroid > loginExpiredInPeroid;
    }

    public String getJobNum() {
        return jobNum;
    }

    public void setJobNum(String jobNum) {
        this.jobNum = jobNum;
    }

    public String getBranchOfficeName() {
        return branchOfficeName;
    }

    public void setBranchOfficeName(String branchOfficeName) {
        this.branchOfficeName = branchOfficeName;
    }

    public String getPassengerSectionName() {
        return passengerSectionName;
    }

    public void setPassengerSectionName(String passengerSectionName) {
        this.passengerSectionName = passengerSectionName;
    }

    public String getRailwayBureauName() {
        return railwayBureauName;
    }

    public void setRailwayBureauName(String railwayBureauName) {
        this.railwayBureauName = railwayBureauName;
    }

    public String getGraduateSchool() {
        return graduateSchool;
    }

    public void setGraduateSchool(String graduateSchool) {
        this.graduateSchool = graduateSchool;
    }

    public String getEducationLevel() {
        return educationLevel;
    }

    public void setEducationLevel(String educationLevel) {
        this.educationLevel = educationLevel;
    }

    public String getMajor() {
        return major;
    }

    public void setMajor(String major) {
        this.major = major;
    }

    private UserBean(Builder builder) {
        set_id(builder._id);
        setUserId(builder.userId);
        setUpdateTime(builder.updateTime);
        setCreateTime(builder.createTime);
        setToken(builder.token);
        setExpire_in(builder.expire_in);
        setType(builder.type);
        setUserName(builder.userName);
        setBirthday(builder.birthday);
        setProvince(builder.province);
        setCity(builder.city);
        setTown(builder.town);
        setAddress(builder.address);
        setNickName(builder.nickName);
        setHeadPic(builder.headPic);
        setSex(builder.sex);
        setFirstName(builder.firstName);
        setLastName(builder.lastName);
        setEmail(builder.email);
        setMobile(builder.mobile);
        setIsHavePwd(builder.isHavePwd);
        setLoginStatus(builder.loginStatus);
        setWorkStatus(builder.workStatus);
        setNation(builder.nation);
        setIdNumber(builder.idNumber);
        setEntryTime(builder.entryTime);
        setAuthSecret(builder.authSecret);
        setCellPhoneNumber(builder.cellPhoneNumber);
        setRealName(builder.realName);
        setRemarks(builder.remarks);
        setUpdateName(builder.updateName);
        setCreateName(builder.createName);
        setAddTime(builder.addTime);
        setJobNum(builder.jobNum);
        setBranchOfficeName(builder.branchOfficeName);
        setPassengerSectionName(builder.passengerSectionName);
        setRailwayBureauName(builder.railwayBureauName);
        setLastModify(builder.lastModify);
        setThirdInfos(builder.thirdInfos);
        setGraduateSchool(builder.graduateSchool);
        setEducationLevel(builder.educationLevel);
        setMajor(builder.major);
        setShelvesMode(builder.shelvesMode);
        setPostInfos(builder.postInfos);
        setPostInfoList(builder.postInfoList);
        setThirdInfoList(builder.thirdInfoList);
    }


    /**
     * 是否只有一个第三方账号绑定，此时不允许解绑
     *
     * @return
     */
    public boolean isOnlyOneThindBind() {
        if (TextUtils.isEmpty(getMobile())
                && TextUtils.isEmpty(getEmail())
                && getThirdInfoList() != null
                && getThirdInfoList().size() == 1) {
            return true;
        }
        return false;
    }


    public String getPostInfos() {
        return postInfos;
    }

    public void setPostInfos(String postInfos) {
        this.postInfos = postInfos;
    }

    public List<PostInfoBean> getPostInfoList() {

        if (postInfoList == null) {
            if (!TextUtils.isEmpty(postInfos)) {
                postInfoList = new ArrayList<>();
                try {
                    JSONArray jsonArray = new JSONArray(postInfos);
                    if (jsonArray.length() > 0) {
                        PostInfoBean postInfoBean = null;
                        for (int i = 0; i < jsonArray.length(); i++) {
                            JSONObject jsonObject = (JSONObject) jsonArray.get(i);
                            postInfoBean = new PostInfoBean();
                            postInfoBean.setPostId(jsonObject.getString("postId"));
                            postInfoBean.setPostName(jsonObject.getString("postName"));
                            postInfoList.add(postInfoBean);
                        }
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return postInfoList;
    }

    public void setPostInfoList(List<PostInfoBean> postInfoList) {
        this.postInfoList = postInfoList;
    }

    public int getLoginStatus() {
        return loginStatus;
    }

    public void setLoginStatus(int loginStatus) {
        this.loginStatus = loginStatus;
    }

    public List<ThirdInfosBean> getThirdInfoList() {
        if (thirdInfoList == null) {
            if (!TextUtils.isEmpty(thirdInfos)) {
                thirdInfoList = new ArrayList<>();
                try {
                    JSONArray jsonArray = new JSONArray(thirdInfos);
                    if (jsonArray.length() > 0) {
                        ThirdInfosBean thirdInfosBean = null;
                        for (int i = 0; i < jsonArray.length(); i++) {
                            JSONObject jsonObject = (JSONObject) jsonArray.get(i);
                            thirdInfosBean = new ThirdInfosBean();
                            thirdInfosBean.setNickName(jsonObject.getString("nickName"));
                            thirdInfosBean.setType(jsonObject.getInt("type"));
                            thirdInfoList.add(thirdInfosBean);
                        }
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return thirdInfoList;
    }

    public void setThirdInfoList(List<ThirdInfosBean> thirdInfoList) {
        this.thirdInfoList = thirdInfoList;
    }

    public int getWorkStatus() {
        return workStatus;
    }

    public void setWorkStatus(int workStatus) {
        this.workStatus = workStatus;
    }

    public String getNation() {
        return nation;
    }

    public void setNation(String nation) {
        this.nation = nation;
    }

    public String getThirdInfos() {
        return thirdInfos;
    }

    public void setThirdInfos(String thirdInfos) {
        this.thirdInfos = thirdInfos;
    }

    public long getAddTime() {
        return addTime;
    }

    public void setAddTime(long addTime) {
        this.addTime = addTime;
    }

    public long get_id() {
        return _id;
    }

    public void set_id(long _id) {
        this._id = _id;
    }

    public long getUserId() {
        return userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getIdNumber() {
        return idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public String getEntryTime() {
        return entryTime;
    }

    public void setEntryTime(String entryTime) {
        this.entryTime = entryTime;
    }

    public String getAuthSecret() {
        return authSecret;
    }

    public void setAuthSecret(String authSecret) {
        this.authSecret = authSecret;
    }

    public String getCellPhoneNumber() {
        return cellPhoneNumber;
    }

    public void setCellPhoneNumber(String cellPhoneNumber) {
        this.cellPhoneNumber = cellPhoneNumber;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getUpdateName() {
        return updateName;
    }

    public void setUpdateName(String updateName) {
        this.updateName = updateName;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public long getLastModify() {
        return lastModify;
    }

    public void setLastModify(long lastModify) {
        this.lastModify = lastModify;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public long getExpire_in() {
        return expire_in;
    }

    public void setExpire_in(long expire_in) {
        this.expire_in = expire_in;
    }

    public long getType() {
        return type;
    }

    public void setType(long type) {
        this.type = type;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getBirthday() {
        return birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getTown() {
        return town;
    }

    public void setTown(String town) {
        this.town = town;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getHeadPic() {
        return headPic;
    }

    public void setHeadPic(String headPic) {
        this.headPic = headPic;
    }

    public int getSex() {
        return sex;
    }

    public void setSex(int sex) {
        this.sex = sex;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public int getIsHavePwd() {
        return isHavePwd;
    }

    public void setIsHavePwd(int isHavePwd) {
        this.isHavePwd = isHavePwd;
    }


    public static class PostInfoBean {
        /**
         * postId : eefe5d7fd9fd35d6
         * postName : 餐吧
         */

        private String postId;
        private String postName;
        private int enableAddWorkTeam;

        @Override
        public String toString() {
            return "PostInfoBean{" +
                    "postId='" + postId + '\'' +
                    ", postName='" + postName + '\'' +
                    ", enableAddWorkTeam=" + enableAddWorkTeam +
                    '}';
        }

        public int getEnableAddWorkTeam() {
            return enableAddWorkTeam;
        }

        public void setEnableAddWorkTeam(int enableAddWorkTeam) {
            this.enableAddWorkTeam = enableAddWorkTeam;
        }

        public String getPostId() {
            return postId;
        }

        public void setPostId(String postId) {
            this.postId = postId;
        }

        public String getPostName() {
            return postName;
        }

        public void setPostName(String postName) {
            this.postName = postName;
        }
    }


    public static class ThirdInfosBean {
        /**
         * nickName : 微信
         * type : 10
         */
        private String nickName;
        private int type;

        @Override
        public String toString() {
            return "ThirdInfosBean{" +
                    "nickName='" + nickName + '\'' +
                    ", type=" + type +
                    '}';
        }

        public String getNickName() {
            return nickName;
        }

        public void setNickName(String nickName) {
            this.nickName = nickName;
        }

        public int getType() {
            return type;
        }

        public void setType(int type) {
            this.type = type;
        }
    }

    public static final class Builder {
        private long _id;
        private long userId;
        private String updateTime;
        private String createTime;
        private String token;
        private long expire_in;
        private long type;
        private String userName;
        private String birthday;
        private String province;
        private String city;
        private String town;
        private String address;
        private String nickName;
        private String headPic;
        private int sex;
        private String firstName;
        private String lastName;
        private String email;
        private String mobile;
        private int isHavePwd;
        private int loginStatus;
        private int workStatus;
        private String nation;
        private String idNumber;
        private String entryTime;
        private String authSecret;
        private String cellPhoneNumber;
        private String realName;
        private String remarks;
        private String updateName;
        private String createName;
        private long addTime;
        private String jobNum;
        private String branchOfficeName;
        private String passengerSectionName;
        private String railwayBureauName;
        private long lastModify;
        private String thirdInfos;
        private String graduateSchool;
        private String educationLevel;
        private String major;
        private int shelvesMode;
        private String postInfos;
        private List<PostInfoBean> postInfoList;
        private List<ThirdInfosBean> thirdInfoList;

        public Builder() {
        }

        public Builder _id(long val) {
            _id = val;
            return this;
        }

        public Builder userId(long val) {
            userId = val;
            return this;
        }

        public Builder updateTime(String val) {
            updateTime = val;
            return this;
        }

        public Builder createTime(String val) {
            createTime = val;
            return this;
        }

        public Builder token(String val) {
            token = val;
            return this;
        }

        public Builder expire_in(long val) {
            expire_in = val;
            return this;
        }

        public Builder type(long val) {
            type = val;
            return this;
        }

        public Builder userName(String val) {
            userName = val;
            return this;
        }

        public Builder birthday(String val) {
            birthday = val;
            return this;
        }

        public Builder province(String val) {
            province = val;
            return this;
        }

        public Builder city(String val) {
            city = val;
            return this;
        }

        public Builder town(String val) {
            town = val;
            return this;
        }

        public Builder address(String val) {
            address = val;
            return this;
        }

        public Builder nickName(String val) {
            nickName = val;
            return this;
        }

        public Builder headPic(String val) {
            headPic = val;
            return this;
        }

        public Builder sex(int val) {
            sex = val;
            return this;
        }

        public Builder firstName(String val) {
            firstName = val;
            return this;
        }

        public Builder lastName(String val) {
            lastName = val;
            return this;
        }

        public Builder email(String val) {
            email = val;
            return this;
        }

        public Builder mobile(String val) {
            mobile = val;
            return this;
        }

        public Builder isHavePwd(int val) {
            isHavePwd = val;
            return this;
        }

        public Builder loginStatus(int val) {
            loginStatus = val;
            return this;
        }

        public Builder workStatus(int val) {
            workStatus = val;
            return this;
        }

        public Builder nation(String val) {
            nation = val;
            return this;
        }

        public Builder idNumber(String val) {
            idNumber = val;
            return this;
        }

        public Builder entryTime(String val) {
            entryTime = val;
            return this;
        }

        public Builder authSecret(String val) {
            authSecret = val;
            return this;
        }

        public Builder cellPhoneNumber(String val) {
            cellPhoneNumber = val;
            return this;
        }

        public Builder realName(String val) {
            realName = val;
            return this;
        }

        public Builder remarks(String val) {
            remarks = val;
            return this;
        }

        public Builder updateName(String val) {
            updateName = val;
            return this;
        }

        public Builder createName(String val) {
            createName = val;
            return this;
        }

        public Builder addTime(long val) {
            addTime = val;
            return this;
        }

        public Builder jobNum(String val) {
            jobNum = val;
            return this;
        }

        public Builder branchOfficeName(String val) {
            branchOfficeName = val;
            return this;
        }

        public Builder passengerSectionName(String val) {
            passengerSectionName = val;
            return this;
        }

        public Builder railwayBureauName(String val) {
            railwayBureauName = val;
            return this;
        }

        public Builder lastModify(long val) {
            lastModify = val;
            return this;
        }

        public Builder thirdInfos(String val) {
            thirdInfos = val;
            return this;
        }

        public Builder graduateSchool(String val) {
            graduateSchool = val;
            return this;
        }

        public Builder educationLevel(String val) {
            educationLevel = val;
            return this;
        }

        public Builder major(String val) {
            major = val;
            return this;
        }

        public Builder shelvesMode(int val) {
            shelvesMode = val;
            return this;
        }

        public Builder postInfos(String val) {
            postInfos = val;
            return this;
        }

        public Builder postInfoList(List<PostInfoBean> val) {
            postInfoList = val;
            return this;
        }

        public Builder thirdInfoList(List<ThirdInfosBean> val) {
            thirdInfoList = val;
            return this;
        }

        public UserBean build() {
            return new UserBean(this);
        }
    }
}
