package cn.com.startai.qxcommon.busi.huadian;

import android.app.Application;
import android.content.Intent;
import android.net.NetworkInfo;
import android.text.TextUtils;

import java.util.List;

import cn.com.startai.common.channel.CErrorCode;
import cn.com.startai.common.channel.ICallListener;
import cn.com.startai.common.channel.mqtt.MqttConnectState;
import cn.com.startai.common.utils.CActivityUtils;
import cn.com.startai.common.utils.CLog;
import cn.com.startai.common.utils.permission.CPermissionHelper;
import cn.com.startai.qxcommon.QXCommonInitParam;
import cn.com.startai.qxcommon.busi.huadian.bean.HDCameraCodeScanReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDCameraCodeScanResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDCaptainDownTripReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDChangeOrderStateReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDChangeShelvesModeReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDChangeTripModeReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDClearWarehouseStockReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetBranchOfficeReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetDutyRoutingReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetOrderDetailReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetOrderListReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetOrderPayStateReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetRefundDetailReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetRefundListReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTeamInfoReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTrainGoodsListReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTripDetailReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTripRecordReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetUnDoOrderNumReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetUserInfoReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetWarehouseInventoryReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetWarehouseListReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDInitReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDLoginReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDLogoutResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDManualDownTripReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDNetworkStateResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPayForOrderReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPlacingOrderReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPutOnOffSaleReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDRejectionOrderReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDServerConnectStateResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDTrainerReviewRefundReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDUpdateUserLoginPwdReq;
import cn.com.startai.qxcommon.busi.huadian.bean.HDUseReq;
import cn.com.startai.qxcommon.busi.qx.QxBusi;
import cn.com.startai.qxcommon.db.UserBean;
import cn.com.startai.qxcommon.global.DeveloperParam;
import cn.com.startai.qxcommon.global.ParamManager;
import cn.com.startai.qxcommon.global.QXUserManager;
import cn.com.startai.qxcommon.link.BaseData;
import cn.com.startai.qxcommon.link.mqtt.TopicManager;
import cn.com.startai.qxcommon.protocol.IDeveloper;
import cn.com.startai.qxcommon.protocol.QXErrorCode;
import cn.com.startai.qxcommon.protocol.QXMessage;
import cn.com.startai.qxcommon.protocol.QXMessageConverter;
import cn.com.startai.qxcommon.utils.QXSpController;
import cn.com.startai.qxcommon.utils.gson.QXJsonUtils;
import cn.com.startai.scansdk.BaseScanActivity;
import cn.com.startai.scansdk.HDTrainScanScanActivity;
import cn.com.startai.scansdk.ScanConfig;
import cn.com.startai.scansdk.bean.ResultBean;

import static cn.com.startai.qxcommon.QXCommon.TAG;

/**
 * Created by Robin on 2019/5/22.
 * 419109715@qq.com 彬影
 */
public class HDTrainer extends QxBusi implements IHDTrainerBusi, IDeveloper.MsgTw, HDCmd {


    private HDTrainer() {
    }

    public static HDTrainer getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }


    private static class SingleTonHoulder {
        private static final HDTrainer singleTonInstance = new HDTrainer();
    }

    private boolean hasCallbackInit;

    public boolean isHasCallbackInit() {
        return hasCallbackInit;
    }

    public void setHasCallbackInit(boolean hasCallbackInit) {
        this.hasCallbackInit = hasCallbackInit;
    }

    private AHDTrainerListener hdListener;

    /**
     * 初始化后不会自动连接服务器
     *
     * @param app
     * @param listener
     */
    @Override
    public void init(Application app, AHDTrainerListener listener) {
        this.hdListener = listener;
        this.application = app;
    }

    @Override
    public void release() {
        super.release();
        this.hdListener = null;
        this.application = null;
        this.commonListener = null;
        this.qxBusiListener = null;
        this.hasCallbackInit = false;
    }

    @Override
    public synchronized void doSend(final String data) {

        CLog.d(TAG, "doSend data = " + data);

        if (application == null) {
            CLog.e(TAG, "please call init first");
            return;
        }
        if (data == null) {
            CLog.e(TAG, "data == null");
            return;
        }


        long cmd = QXMessageConverter.getInstance().getCmdFromJson(data);
        int msgtw = QXMessageConverter.getInstance().getMsgTwFromJson(data);

        if (cmd <= 0 || msgtw <= 0) {
            CLog.e(TAG, "error msg : " + cmd);
            if (hdListener != null) {
                hdListener.onSendFailed(data, CErrorCode.ERROR_SEND_PARAM_INVALIBLE);
            }
            return;
        }

        switch (msgtw) {

            case TW_APP_SET:
            case TW_APP_QUERY:
            case TW_APP_REPORT:
            case TW_APP_ALARM:
            case TW_APP_PASSTHROUGH:

                if (cmd == SDK_INIT) {

                    QXMessage<HDInitReq> qxMessage = QXJsonUtils.fromJsonToQXMessage(data, HDInitReq.class);
                    init(application, new QXCommonInitParam.Builder().appid(qxMessage.getContent().getAppid()).build(), hdListener);

                    if (QXSpController.getInstance().getIsActivite()) {
                        if (hdListener != null && !hasCallbackInit) {

                            qxMessage = QXMessageConverter.getInstance().getBackQxMsgByFromQxMsg(qxMessage);


                            DeveloperParam content = ParamManager.getInstance();
                            content.setResult(IDeveloper.Result.SUCCESS);


                            if (content.getUserId() != 0) {
                                UserBean userBean = getUserBean();
                                long userId = userBean.getUserId();
                                if (userId != 0) {
                                    boolean expired = userBean.isExpired(30 * 24 * 60 * 60 * 1000L);
                                    if (expired) {
                                        //失效
                                        CLog.e(TAG, "user login is expired ");
                                        QXUserManager.getInstance().onLogout();
                                        content.setUserId(0);
                                    } else {
                                        CLog.d(TAG, "user login is normal ");
                                    }
                                }
                            }

                            qxMessage.setContent(content);
                            hdListener.onHDMessageArrived(qxMessage.toJson());
                            hasCallbackInit = true;
                        }
                    }


                } else if (cmd == SDK_RELEASE) {
                    release();
                } else if (cmd == SDK_LOGOUT) {
                    logout();

                    QXMessage<HDLogoutResp> qxMessage = QXJsonUtils.fromJsonToQXMessage(data, HDLogoutResp.class);
                    qxMessage.getContent().setResult(IDeveloper.Result.SUCCESS);
                    if (hdListener != null) {
                        hdListener.onHDMessageArrived(qxMessage.toJson());
                    }

                } else if (cmd == SDK_SERVER_CONNECT_STATE) {
                    CLog.d(TAG, "cmd = SDK_SERVER_CONNECT_STATE");

                    QXMessage<HDServerConnectStateResp> qxMessage = QXJsonUtils.fromJsonToQXMessage(data, HDServerConnectStateResp.class);
                    qxMessage = QXMessageConverter.getInstance().getBackQxMsgByFromQxMsg(qxMessage);
                    MqttConnectState serverConnectState = getServerConnectState();

                    HDServerConnectStateResp content = qxMessage.getContent();
                    content.setServerConnectState(serverConnectState.name());
                    content.setResult(IDeveloper.Result.SUCCESS);
                    if (hdListener != null) {
                        hdListener.onHDMessageArrived(qxMessage.toJson());
                    }
                } else if (cmd == SDK_NETWORK_STATE) {

                    NetworkInfo.State networkState = getNetworkState();
                    String networkType = getNetworkType();

                    QXMessage<HDNetworkStateResp> qxMessage = QXJsonUtils.fromJsonToQXMessage(data, HDNetworkStateResp.class);
                    qxMessage = QXMessageConverter.getInstance().getBackQxMsgByFromQxMsg(qxMessage);
                    HDNetworkStateResp content = qxMessage.getContent();
                    content.setResult(IDeveloper.Result.SUCCESS);
                    content.setNetworkState(networkState.name());
                    content.setNetworkType(networkType);
                    if (hdListener != null) {
                        hdListener.onHDMessageArrived(qxMessage.toJson());
                    }

                } else if (cmd == SDK_TEXT_SPEAKER) {

                } else if (cmd == SDK_CAMERA_CODE_SCAN) {

                    QXMessage<HDCameraCodeScanResp> qxMessage = QXJsonUtils.fromJsonToQXMessage(data, HDCameraCodeScanResp.class);
                    final QXMessage<HDCameraCodeScanResp> qxMessageFinal = QXMessageConverter.getInstance().getBackQxMsgByFromQxMsg(qxMessage);
                    final HDCameraCodeScanResp content = qxMessageFinal.getContent();
                    hdCameraCodeScan(content, new HDCameraCodeScanCallback() {
                        @Override
                        public void onResult(String data) {

                            int result;
                            if (TextUtils.isEmpty(data)) {
                                result = 0x1002;
                            } else {
                                result = IDeveloper.Result.SUCCESS;
                            }

                            content.setResult(result);

                            List<ResultBean> scanResult = QXJsonUtils.fromJsonToList(data, ResultBean.class);
                            content.setScanResult(scanResult);

                            if (hdListener != null) {
                                hdListener.onHDCameraCodeScanResult(qxMessageFinal);
                            }

                        }
                    });

                } else {
                    CLog.e(TAG, "unsupport send cmd");
                    if (hdListener != null) {
                        hdListener.onSendFailed(data, QXErrorCode.ERROR_CMD);
                    }
                }
                break;
            case TW_APP_CLOUD_ALARM:
            case TW_APP_CLOUD_REPORT:
            case TW_APP_CLOUD_SET:
            case TW_APP_CLOUD_PASSTHROUGH:
            case TW_APP_CLOUD_QUERY:

            case TW_APP_CLOUD_THIRDCLOUD_ALARM:
            case TW_APP_CLOUD_THIRDCLOUD_SET:
            case TW_APP_CLOUD_THIRDCLOUD_QUERY:
            case TW_APP_CLOUD_THIRDCLOUD_PASSTHROUGH:
            case TW_APP_CLOUD_THIRDCLOUD_REPORT:

                BaseData baseData = new BaseData.Builder()
                        .channelMqtt()
                        .topic(TopicManager.getInstance().getCloudPubTopic())
                        .data(data.getBytes())
                        .build();
                doSend(baseData, new ICallListener() {
                    @Override
                    public void onSuccess() {

                    }

                    @Override
                    public void onFailed(int error) {
                        if (hdListener != null) {
                            hdListener.onSendFailed(data, error);
                        }
                    }
                });
                break;
            default:
                CLog.e(TAG, "unsupport msgtw");
                if (hdListener != null) {
                    hdListener.onSendFailed(data, QXErrorCode.ERROR_MSGTW);
                }
        }
    }


    @Override
    public void hdLogin(HDLoginReq req, ICallListener callListener) {


        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdUpdateUserLoginPwd(HDUpdateUserLoginPwdReq req, ICallListener callListener) {


        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetTeamInfo(HDGetTeamInfoReq req, ICallListener callListener) {


        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetTripRecord(HDGetTripRecordReq req, ICallListener callListener) {

        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetTripDetail(HDGetTripDetailReq req, ICallListener callListener) {

        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetUserInfo(HDGetUserInfoReq req, ICallListener callListener) {

        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetBranchOffice(HDGetBranchOfficeReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetDutyRouting(HDGetDutyRoutingReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetTrainGoodsList(HDGetTrainGoodsListReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdPlacingOrder(HDPlacingOrderReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetOrderPayState(HDGetOrderPayStateReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetOrderDetail(HDGetOrderDetailReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetOrderList(HDGetOrderListReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdChangeOrderState(HDChangeOrderStateReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdPutOnOffSale(HDPutOnOffSaleReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdCameraCodeScan(final HDCameraCodeScanReq req, final HDCameraCodeScanCallback callback) {

        CPermissionHelper.requestCamera(new CPermissionHelper.OnPermissionGrantedListener() {
            @Override
            public void onPermissionGranted() {

                Intent intent = new Intent(application, HDTrainScanScanActivity.class);
                ScanConfig config = new ScanConfig.Builder()
                        .scanPeroid(1500)
                        .scanType(req.getScanType())
                        .build();
                intent.putExtra(BaseScanActivity.EXTRA_SCAN_CONFIG, config);

                CActivityUtils.startActivityForResult(intent, new CActivityUtils.ResultCallback() {
                    @Override
                    public void onActivityResult(Intent data) {
                        String result = "";
                        if (data != null) {
                            result = data.getStringExtra("result");
                        }
                        CLog.d(TAG, "onActivityResult scan result = " + result);
                        callback.onResult(result);

                    }

                });


            }
        }, new CPermissionHelper.OnPermissionDeniedListener() {
            @Override
            public void onPermissionDenied() {
                callback.onResult(null);
            }
        });


    }

    @Override
    public void hdTrainerReviewRefund(HDTrainerReviewRefundReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetRefundList(HDGetRefundListReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetRefundDetail(HDGetRefundDetailReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdMamualDownTrip(HDManualDownTripReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdChangeTripMode(HDChangeTripModeReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetWarehouseList(HDGetWarehouseListReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdCaptainDownTrip(HDCaptainDownTripReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetWarehouseInventory(HDGetWarehouseInventoryReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);

    }

    @Override
    public void hdUse(HDUseReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);

    }

    @Override
    public void hdClearWarehouseStock(HDClearWarehouseStockReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);

    }

    @Override
    public void hdChangeShelvesMode(HDChangeShelvesModeReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdRejectionOrder(HDRejectionOrderReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);
    }

    @Override
    public void hdGetUnDoOrderNum(HDGetUnDoOrderNumReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);

    }

    @Override
    public void hdPayForOrder(HDPayForOrderReq req, ICallListener callListener) {
        doSendMqtt(HDDataCreater.getCloudBaseData(HDDataCreater.getAPP2Cloud2ThirdCloudQueryQXMsg(0, false, req)), callListener);

    }


}
