package cn.com.startai.qxcommon.busi.huadian;


import android.net.NetworkInfo;

import org.json.JSONObject;

import cn.com.startai.common.channel.mqtt.MqttConnectState;
import cn.com.startai.common.utils.CLog;
import cn.com.startai.qxcommon.busi.huadian.bean.HDCameraCodeScanResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDCaptainDownTripResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDChangeOrderStateResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDChangeShelvesModeResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDChangeTripModeResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDClearWarehouseStockResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetBranchOfficeResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetDutyRoutingResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetOrderDetailResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetOrderListResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetOrderPayStateResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetRefundDetailResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetRefundListResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTeamInfoResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTrainGoodsListResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTripDetailResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetTripRecordResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetUnDoOrderNumResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetUserInfoResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetWarehouseInventoryResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDGetWarehouseListResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDLoginResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDManualDownTripResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDNetworkStateResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDOrderReport;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPayForOrderResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPlacingOrderResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDPutOnOffSaleResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDRejectionOrderResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDServerConnectStateResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDTrainerReviewRefundResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDUpdateUserLoginPwdResp;
import cn.com.startai.qxcommon.busi.huadian.bean.HDUseResp;
import cn.com.startai.qxcommon.busi.qx.AQXBusiListener;
import cn.com.startai.qxcommon.db.UserBean;
import cn.com.startai.qxcommon.global.DeveloperParam;
import cn.com.startai.qxcommon.global.ParamManager;
import cn.com.startai.qxcommon.global.QXUserManager;
import cn.com.startai.qxcommon.link.BaseData;
import cn.com.startai.qxcommon.protocol.IDeveloper;
import cn.com.startai.qxcommon.protocol.MiofTag;
import cn.com.startai.qxcommon.protocol.QXDataCreater;
import cn.com.startai.qxcommon.protocol.QXMessage;
import cn.com.startai.qxcommon.utils.QXSpController;
import cn.com.startai.qxcommon.utils.gson.QXJsonUtils;

import static cn.com.startai.qxcommon.QXCommon.TAG;

/**
 * Created by Robin on 2019/5/22.
 * 419109715@qq.com 彬影
 */
public abstract class AHDTrainerListener extends AQXBusiListener implements HDCmd {


    // ---------- INetworkListener start ----------
    @Override
    public void onWifiConnected() {

    }

    @Override
    public void onMobileConnected() {

    }

    @Override
    public void onEthernetConnected() {

    }

    @Override
    public void onUnkownNetwork() {

    }

    @Override
    public void onNetworkStateChange(String s, NetworkInfo.State state) {
        callbackNetworkState(s, state);
    }

    // ---------- INetworkListener end ----------


    // ---------- IQXCommonListener start ----------


    @Override
    public void onServerConnected(String host) {
        if (QXSpController.getInstance().getIsActivite()) {
            if (!HDTrainer.getInstance().isHasCallbackInit()) {
                onInitSuccess(ParamManager.getInstance());
                HDTrainer.getInstance().setHasCallbackInit(true);
            }
            callbackServerConnectState(MqttConnectState.CONNECTED);
        }
    }

    @Override
    public void onServerDisconnected(int errorCode) {
        callbackServerConnectState(MqttConnectState.DISCONNECTED);
    }

    @Override
    public void onMessageArrived(BaseData baseData) {
        super.onMessageArrived(baseData);

        if (getCmd() > 0 && getMsgtw() > 0) {
            String json = getJson();
            sdkHandler(json);
            onHDMessageArrived(json);
        } else {
            CLog.e(TAG, "error data formate");
        }

    }

    private void sdkHandler(String json) {
        long cmd = getCmd();
        if (cmd == HD_LOGIN) {
            onHDLoginResult(QXJsonUtils.fromJsonToQXMessage(json, HDLoginResp.class));
        } else if (cmd == HD_UPDATE_USER_LOGIN_PWD) {
            onHDUpdateUserLoginPwdResult(QXJsonUtils.fromJsonToQXMessage(json, HDUpdateUserLoginPwdResp.class));
        } else if (cmd == HD_GET_TRIP_RECORD) {
            onHDGetTripRecordResult(QXJsonUtils.fromJsonToQXMessage(json, HDGetTripRecordResp.class));
        } else if (cmd == HD_GET_TRIP_DETAIL) {
            onHDGetTripDeatilResult(QXJsonUtils.fromJsonToQXMessage(json, HDGetTripDetailResp.class));
        } else if (cmd == HD_GET_TEAM_INFO) {
            onHDGetTeamInfoResult(QXJsonUtils.fromJsonToQXMessage(json, HDGetTeamInfoResp.class));
        } else if (cmd == HD_GET_USER_INFO) {
            onHDGetUserInfoResult(QXJsonUtils.fromJsonToQXMessage(json, HDGetUserInfoResp.class));
        } else if (cmd == HD_GET_BRANCH_OFFICE) {
            onHDGetBranchOfficeResult(QXJsonUtils.fromJsonToQXMessage(json, HDGetBranchOfficeResp.class));
        } else if (cmd == HD_GET_DUTY_ROUTING) {
            onHDGetDutyRoutingResult(QXJsonUtils.fromJsonToQXMessage(json, HDGetDutyRoutingResp.class));
        } else if (cmd == HD_GET_TRAIN_GOODS_LIST) {
            onHDGetTrainGoodsListResult(QXJsonUtils.fromJsonToQXMessage(json, HDGetTrainGoodsListResp.class));
        } else if (cmd == HD_PLACING_ORDER) {
            onHDPlacingOrderResult(QXJsonUtils.fromJsonToQXMessage(json, HDPlacingOrderResp.class));
        } else if (cmd == HD_GET_ORDER_PAY_STATE) {
            onHDGetOrderPayStateResult(QXJsonUtils.fromJsonToQXMessage(json, HDGetOrderPayStateResp.class));
        } else if (cmd == HD_GET_ORDER_DETAIL) {
            onHDGetOrderDetailResult(QXJsonUtils.fromJsonToQXMessage(json, HDGetOrderDetailResp.class));
        } else if (cmd == HD_GET_ORDER_LIST) {
            onHDGetOrderListResult(QXJsonUtils.fromJsonToQXMessage(json, HDGetOrderListResp.class));
        } else if (cmd == HD_CHANGE_ORDER_STATE) {
            onHDChangeOrderStateResult(QXJsonUtils.fromJsonToQXMessage(json, HDChangeOrderStateResp.class));
        } else if (cmd == HD_PUT_ON_OFF_SALE) {
            onHDPutOnOffSaleResult(QXJsonUtils.fromJsonToQXMessage(json, HDPutOnOffSaleResp.class));
        } else if (cmd == HD_ORDER_REPORT) {
            onHDOrderReport(QXJsonUtils.fromJsonToQXMessage(json, HDOrderReport.class));
        } else if (cmd == HD_GET_ORDER_REFUND_LIST) {
            onHDGetRefundListResult(QXJsonUtils.fromJsonToQXMessage(json, HDGetRefundListResp.class));
        } else if (cmd == HD_GET_ORDER_REFUND_DETAIL) {
            onHDGetRefundDetailResult(QXJsonUtils.fromJsonToQXMessage(json, HDGetRefundDetailResp.class));
        } else if (cmd == HD_TRAINER_REVIEW_REFUND) {
            onHDTrainerReviewRefundResult(QXJsonUtils.fromJsonToQXMessage(json, HDTrainerReviewRefundResp.class));
        } else if (cmd == HD_MANUAL_DOWN_TRIP) {
            onHDManualDownTripResult(QXJsonUtils.fromJsonToQXMessage(json, HDManualDownTripResp.class));
        } else if (cmd == HD_CHANGE_TRIP_MODE) {
            onHDChangeTripModeResult(QXJsonUtils.fromJsonToQXMessage(json, HDChangeTripModeResp.class));
        } else if (cmd == HD_GET_WAREHOUSE_LIST) {
            onHDGetWarehouseListResult(QXJsonUtils.fromJsonToQXMessage(json, HDGetWarehouseListResp.class));
        } else if (cmd == HD_CAPTAIN_DOWN_TRIP) {
            onHDCaptainDownTripResult(QXJsonUtils.fromJsonToQXMessage(json, HDCaptainDownTripResp.class));
        } else if (cmd == HD_GET_WARE_INVENTORY_INFO) {
            onHDGetWarehouseInventoryResult(QXJsonUtils.fromJsonToQXMessage(json, HDGetWarehouseInventoryResp.class));
        } else if (cmd == HD_USE) {
            onHDUseResult(QXJsonUtils.fromJsonToQXMessage(json, HDUseResp.class));
        } else if (cmd == HD_CLEAR_WAREHOUSE_STOCK) {
            onHDClearWarehouseStock(QXJsonUtils.fromJsonToQXMessage(json, HDClearWarehouseStockResp.class));
        } else if (cmd == HD_CHANGE_SHELVES_MODE) {
            onHDChangeShelvesMode(QXJsonUtils.fromJsonToQXMessage(json, HDChangeShelvesModeResp.class));
        } else if (cmd == HD_REJECTION_ORDER) {
            onHDRejectionOrderResult(QXJsonUtils.fromJsonToQXMessage(json, HDRejectionOrderResp.class));
        } else if (cmd == HD_UNDO_ORDER_NUM) {
            onHDGetUnDoOrderNumResult(QXJsonUtils.fromJsonToQXMessage(json, HDGetUnDoOrderNumResp.class));
        } else if (cmd == HD_PAY_FOR_ORDER) {

            onHDPayForOrderResult(QXJsonUtils.fromJsonToQXMessage(json, HDPayForOrderResp.class));
        } else {

        }
    }


    // ---------- IQXCommonListener end ----------


    // ---------- AQXBusiListener start ----------

    @Override
    public void onQXGetUserInfoResult() {

    }

    @Override
    public void onQXActivateResult() {

    }

    @Override
    public void onQXLoginResult() {

    }

    @Override
    public void onQXLogoutResult(boolean result) {

    }
    // ---------- AQXBusiListener end ----------

    // ---------- AHDTrainerListener start ----------

    public void onHDGetUserInfoResult(QXMessage<HDGetUserInfoResp> qxMessage) {
        if (qxMessage.getContent().getResult() == HDLoginResp.SUCCESS) {
            UserBean userBean = qxMessage.getContent().toUserBean();
            QXUserManager.getInstance().onUpdateUserInfo(userBean);

        }
    }


    public void onHDLoginResult(QXMessage<HDLoginResp> qxMessage) {
        if (qxMessage.getContent().getResult() == HDLoginResp.SUCCESS) {

            long l;
            try {
                l = Long.parseLong(qxMessage.getContent().getUserId());
            } catch (Exception e) {
                e.printStackTrace();
                CLog.e(TAG, "login failed user error");
                return;
            }
            UserBean userBean = new UserBean.Builder()
                    .userId(l)
                    .token(qxMessage.getContent().getToken())
                    .build();
            QXUserManager.getInstance().onLogin(userBean);
            ParamManager.getInstance().setUserId(userBean.getUserId());
        }

    }

    public void onHDPayForOrderResult(QXMessage<HDPayForOrderResp> qxMessage) {

    }

    public void onHDGetUnDoOrderNumResult(QXMessage<HDGetUnDoOrderNumResp> qxMessage) {

    }

    public void onHDRejectionOrderResult(QXMessage<HDRejectionOrderResp> qxMessage) {

    }


    public void onHDChangeShelvesMode(QXMessage<HDChangeShelvesModeResp> qxMessage) {

    }

    public void onHDClearWarehouseStock(QXMessage<HDClearWarehouseStockResp> qxMessage) {

    }

    public void onHDUseResult(QXMessage<HDUseResp> qxMessage) {


    }

    public void onHDGetWarehouseInventoryResult(QXMessage<HDGetWarehouseInventoryResp> qxMessage) {


    }

    public void onHDCaptainDownTripResult(QXMessage<HDCaptainDownTripResp> qxMessage) {


    }

    public void onHDGetWarehouseListResult(QXMessage<HDGetWarehouseListResp> qxMessage) {


    }

    public void onHDManualDownTripResult(QXMessage<HDManualDownTripResp> qxMessage) {


    }

    public void onHDChangeTripModeResult(QXMessage<HDChangeTripModeResp> qxMessage) {


    }


    public void onHDGetRefundDetailResult(QXMessage<HDGetRefundDetailResp> qxMessage) {


    }

    public void onHDTrainerReviewRefundResult(QXMessage<HDTrainerReviewRefundResp> qxMessage) {


    }


    public void onHDGetRefundListResult(QXMessage<HDGetRefundListResp> qxMessage) {


    }

    public void onHDChangeOrderStateResult(QXMessage<HDChangeOrderStateResp> qxMessage) {


    }

    public void onHDOrderReport(QXMessage<HDOrderReport> qxMessage) {


    }

    public void onHDPutOnOffSaleResult(QXMessage<HDPutOnOffSaleResp> qxMessage) {


    }

    public void onHDGetOrderListResult(QXMessage<HDGetOrderListResp> qxMessage) {


    }

    public void onHDGetOrderDetailResult(QXMessage<HDGetOrderDetailResp> qxMessage) {


    }

    public void onHDGetDutyRoutingResult(QXMessage<HDGetDutyRoutingResp> qxMessage) {


    }

    public void onHDGetBranchOfficeResult(QXMessage<HDGetBranchOfficeResp> qxMessage) {


    }

    public void onHDGetTripDeatilResult(QXMessage<HDGetTripDetailResp> qxMessage) {


    }


    public void onHDGetTripRecordResult(QXMessage<HDGetTripRecordResp> qxMessage) {

    }

    public void onHDGetTeamInfoResult(QXMessage<HDGetTeamInfoResp> qxMessage) {

    }

    public void onHDUpdateUserLoginPwdResult(QXMessage<HDUpdateUserLoginPwdResp> qxMessage) {


    }

    public void onHDGetTrainGoodsListResult(QXMessage<HDGetTrainGoodsListResp> qxMessage) {

    }

    public void onHDPlacingOrderResult(QXMessage<HDPlacingOrderResp> qxMessage) {

    }

    public void onHDGetOrderPayStateResult(QXMessage<HDGetOrderPayStateResp> qxMessage) {

    }

    /**
     * 条形码 二维码扫描
     */
    protected void onHDCameraCodeScanResult(QXMessage<HDCameraCodeScanResp> qxMessage) {
        onHDMessageArrived(qxMessage.toJson());
    }


    public void callbackNetworkState(String networkType, NetworkInfo.State netwrokState) {

        HDNetworkStateResp content = new HDNetworkStateResp(networkType, netwrokState.name());
        content.setResult(HDServerConnectStateResp.SUCCESS);
        QXMessage qxMessage = QXDataCreater.getAppReportQXMsg(0, content);
        onHDMessageArrived(qxMessage.toJson());

    }

    public void callbackServerConnectState(MqttConnectState mqttConnectState) {
        HDServerConnectStateResp content = new HDServerConnectStateResp(mqttConnectState.name());
        content.setResult(HDServerConnectStateResp.SUCCESS);
        QXMessage qxMessage = QXDataCreater.getAppReportQXMsg(0, content);
        onHDMessageArrived(qxMessage.toJson());
    }

    public void onInitSuccess(DeveloperParam content) {
        content.setCmd(HDCmd.SDK_INIT);
        content.setResult(IDeveloper.Result.SUCCESS);
        QXMessage qxMessage = QXDataCreater.getAppReportQXMsg(0, content);
        onHDMessageArrived(qxMessage.toJson());
    }

    public void onSendFailed(String data, int error) {
        try {
            JSONObject jsonObject = new JSONObject(data);
            JSONObject jsonContent = jsonObject.getJSONObject(MiofTag.TAG_CONTENT);
            jsonContent.put(MiofTag.TAG_RESULT, error);
            onHDMessageArrived(jsonObject.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract void onHDMessageArrived(String msg);

    // ---------- AHDTrainerListener end ----------
}

