package cn.com.startai.qxcommon.protocol;


import cn.com.startai.qxcommon.utils.gson.QXJsonUtils;

/**
 * startai miof 基础消息
 * Created by Robin on 2018/5/7.
 * qq: 419109715 彬影
 */

public class QXMessage<T extends QXBaseContent> extends QXBaseMessage {

    private T content;

    public QXMessage() {
    }

    private QXMessage(Builder builder) {
        setVer(builder.ver);
        setTs(builder.ts);
        setFrom(builder.from);
        setTo(builder.to);
        setSession(builder.session);
        setAppid(builder.appid);
        setMsgtw(builder.msgtw);
        setContent(builder.content);
    }

    public String toJson() {
        return QXJsonUtils.toJson(this);
    }

    @Override
    public String toString() {
        return "QXMessage{" +
                "content=" + content +
                ", ver=" + ver +
                ", ts=" + ts +
                ", from=" + from +
                ", to=" + to +
                ", session=" + session +
                ", appid=" + appid +
                ", msgtw=" + msgtw +
                '}';
    }

    public T getContent() {
        return content;
    }

    public void setContent(T content) {
        this.content = content;
    }

    public final class Builder {
        private int ver;
        private long ts;
        private long from;
        private long to;
        private int session;
        private long appid;
        private int msgtw;
        private T content;

        public Builder() {
        }

        public Builder ver(int val) {
            ver = val;
            return this;
        }

        public Builder ts(long val) {
            ts = val;
            return this;
        }


        public Builder from(long val) {
            from = val;
            return this;
        }

        public Builder to(long val) {
            to = val;
            return this;
        }

        public Builder session(int val) {
            session = val;
            return this;
        }

        public Builder appid(long val) {
            appid = val;
            return this;
        }

        public Builder msgtw(int val) {
            msgtw = val;
            return this;
        }

        public Builder content(T val) {
            content = val;
            return this;
        }

        public QXMessage build() {
            return new QXMessage(this);
        }
    }
}
