package cn.com.startai.qxcommon.link.mqtt.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import cn.com.startai.common.channel.mqtt.event.IMqttHeartListener;
import cn.com.startai.common.utils.CLog;
import cn.com.startai.qxcommon.link.mqtt.QXMqttConfig;
import cn.com.startai.qxcommon.link.mqtt.QXMqttHostManager;
import cn.com.startai.qxcommon.link.mqtt.QXMqttManager;
import cn.com.startai.qxcommon.link.mqtt.busi.bean.GetBrokerHostResp;

import static cn.com.startai.qxcommon.QXCommon.TAG;

/**
 * Created by Robin on 2019/5/20.
 * 419109715@qq.com 彬影
 */
public class MqttHeartListener implements IMqttHeartListener {

    private long lastHeartT;
    private int avarNum = 7;
    private ArrayList<Long> delayTimes = new ArrayList<>();


    @Override
    public void onHeartStart() {
        lastHeartT = System.currentTimeMillis();
        CLog.d(TAG, "onHeartStart");
    }

    @Override
    public void onHeartSuccess() {
        long delay = System.currentTimeMillis() - lastHeartT;

        //TODO:测试 写死延时
//        delay += 5000;

        CLog.d(TAG, "onHeartSuccess time delay = " + delay + " ms");
        if (QXMqttConfig.changeHostTimeDelay <= 0) {
            CLog.d(TAG, "There is no weight value reduce setting");
            return;
        }
        GetBrokerHostResp cacheBrokerHost = QXMqttHostManager.getInstance().getCacheBrokerHost();
        GetBrokerHostResp spBrokerHost = QXMqttHostManager.getInstance().getSpBrokerHost();
        if ((cacheBrokerHost == null && spBrokerHost == null) || spBrokerHost.getNode().size() <= 1) {

        }

        if (delay > 60 * 1000) {
            CLog.d(TAG, "invalid time delay " + delay);
            return;
        }

        delayTimes.add(delay);
        if (delayTimes.size() > avarNum) {
            delayTimes.remove(0);
        }

        CLog.d(TAG, delayTimes.toString());
        if (delayTimes.size() == avarNum) {
            //满了七个 就清除一次时延队列

            CLog.d(TAG, "Start calculating the average delay");
            int i = toCalculationAverageDelayTime(delayTimes);
            delayTimes.clear();

            CLog.d(TAG, "near " + avarNum + " times average time delay is " + i + " ms(Remove the highest and lowest )   , The setting value is  " + QXMqttConfig.changeHostTimeDelay + " ms ");
            if (i > QXMqttConfig.changeHostTimeDelay) {
                //计算权值，如果有必要需要更换节点
                calculationWeight(i);
            } else {
                CLog.d(TAG, "Time delay normal ");
            }

        }

    }


    @Override
    public void onHeartFailed(Throwable throwable) {
        CLog.d(TAG, "onHeartFailed");
    }


    /**
     * 计算权值，如果有必要需要更换节点
     */
    public void calculationWeight(long delay) {
        GetBrokerHostResp cacheBrokerHost = QXMqttHostManager.getInstance().getCacheBrokerHost();
        if (cacheBrokerHost != null && cacheBrokerHost.getNode().size() != 0) {
            List<GetBrokerHostResp.NodeBean> nodes = cacheBrokerHost.getNode();
            for (GetBrokerHostResp.NodeBean nodeBean : nodes) {
                //当前的节点
                String host = QXMqttManager.getInstance().getHost();
                if (host.contains(nodeBean.getServer_domain())) {
                    double weight = nodeBean.getWeight();
                    CLog.d(TAG, "The time delay is High, now start reduce weight value, current node  " + host + " weight = " + weight);
                    double v = delay * 1.0 / 1000;
                    double delayDou = (double) Math.round(v * 100) / 100;
                    CLog.d(TAG, "delayDou = " + delayDou);
                    double v1 = 0.2 * delayDou;
                    weight -= v1;
                    weight = (double) Math.round(weight * 100) / 100;
                    nodeBean.setWeight(weight);
                    CLog.d(TAG, "Weight reduce " + v1 + " , After reduce weight value is " + weight);
                    if (weight <= 0) {
                        CLog.d(TAG, "current node  " + host + " weight is < 0 ,will change host");
                        //需要更换节点
                        QXMqttManager.getInstance().changeHost();
                        break;
                    }
                }
            }
        } else {
            CLog.d(TAG, "There is no node weight information locally and requests are required ");

            QXMqttManager.getInstance().checkAreNode();
        }


    }


    /**
     * 计算近几次的平均时延 去掉最高及最低值
     *
     * @param list
     * @return
     */
    private int toCalculationAverageDelayTime(ArrayList<Long> list) {

        ArrayList<Long> temp = null;
        int all1 = 0;
        try {
            temp = new ArrayList<>();
            temp.addAll(list);
            //升序
            Collections.sort(temp, new Comparator<Long>() {
                @Override
                public int compare(Long o1, Long o2) {
                    if (o1 > o2) {
                        return 1;
                    } else {
                        return -1;
                    }
                }
            });
            temp.remove(temp.size() - 1);
            temp.remove(0);
            all1 = 0;
            for (Long aLong : temp) {
                all1 += aLong;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return all1 / temp.size();
    }

    public void onReset() {
        lastHeartT = 0;
        delayTimes.clear();
    }

}
