package cn.com.startai.qxcommon.link.mqtt;

import android.support.annotation.NonNull;
import android.text.TextUtils;

import java.util.ArrayList;
import java.util.List;

import cn.com.startai.common.utils.CLog;
import cn.com.startai.qxcommon.link.mqtt.busi.bean.GetBrokerHostResp;
import cn.com.startai.qxcommon.utils.QXSpController;
import cn.com.startai.qxcommon.utils.location.AreaLocation;
import cn.com.startai.qxcommon.utils.location.QXLocationManager;

import static cn.com.startai.qxcommon.QXCommon.TAG;

/**
 * Created by Robin on 2019/5/12.
 * 419109715@qq.com 彬影
 */
public class QXMqttHostManager {

    private QXMqttHostManager() {
    }

    public static QXMqttHostManager getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }

    private static class SingleTonHoulder {
        private static final QXMqttHostManager singleTonInstance = new QXMqttHostManager();
    }

    public static final String HOST_CN = "ssl://cn.startai.net:8883";
    public static final String HOST_US = "ssl://us.startai.net:8883";

    public static String HOST_FORCE;

    private static String currentHost;

    private GetBrokerHostResp brokerHost;

    public GetBrokerHostResp getCacheBrokerHost() {
        return brokerHost;
    }

    public void setCacheBrokerHost(GetBrokerHostResp brokerHost) {
        this.brokerHost = brokerHost;
    }

    public GetBrokerHostResp getSpBrokerHost() {
        GetBrokerHostResp brokerHost = QXSpController.getInstance().getBrokerHost();
//        //默认初始化两个节点到本地sp
//        if (brokerHost == null) {
//            brokerHost = new GetBrokerHostResp();
//            brokerHost.setCycle(30);
//            List<GetBrokerHostResp.NodeBean> nodes = new ArrayList<>();
//            nodes.add(new GetBrokerHostResp.NodeBean("亚洲", "中国", "47.106.45.110", 8883, "ssl", "ssl://cn.startai.net:8883", 1));
//            nodes.add(new GetBrokerHostResp.NodeBean("北美洲", "美国", "47.252.50.56", 8883, "ssl", "ssl://us.startai.net:8883", 1));
//            brokerHost.setNode(nodes);
//            setSpBrokerHost(brokerHost);
//        }
        return brokerHost;
    }

    public void setSpBrokerHost(GetBrokerHostResp areaNodes) {
        QXSpController.getInstance().setBrokerHost(areaNodes);
    }

    public void release() {
        CLog.d(TAG, "QXMqttHostManager release");
        this.brokerHost = null;
        this.currentHost = null;
    }


    public String getHostFromDefaultByCountryCode(@NonNull String countryCode) {
        String host = null;
        List<String> defaulthosts = getDefaulthosts();
        for (String defaulthost : defaulthosts) {
            if (defaulthost.toUpperCase().contains("ssl://" + countryCode.toUpperCase())) {
                host = defaulthost;
            }
        }
        if (TextUtils.isEmpty(host)) {
            host = HOST_CN;
        }
        return host;
    }

    public List<String> getDefaulthosts() {
        List list = new ArrayList();
        list.add(HOST_CN);
        list.add(HOST_US);
        return list;
    }


    private void callbackOnGeOptimalHost(String host, OnGetOptimalHostListener listener) {

        List<String> defaulthosts = getDefaulthosts();
        if (defaulthosts.contains(host)) {
            defaulthosts.remove(host);
        }

        defaulthosts.add(0, host);

        String[] hosts = new String[defaulthosts.size()];
        hosts = defaulthosts.toArray(hosts);
        listener.onGetOptimalHost(hosts);
    }

    public void getOptimalHost(@NonNull final OnGetOptimalHostListener listener) {

        if (!TextUtils.isEmpty(HOST_FORCE)) {
            listener.onGetOptimalHost(new String[]{HOST_FORCE});
            return;
        }

        GetBrokerHostResp cacheBrokerHost = getCacheBrokerHost();
        GetBrokerHostResp spBrokerHost = getSpBrokerHost();
        //首次启动应用
        if (cacheBrokerHost == null && spBrokerHost == null) {
            CLog.d(TAG, "first luncher app or no available broker node");
            //定位匹配节点
            QXLocationManager.getInstance().getLocation(new QXLocationManager.LocationCallback() {
                @Override
                public void onLocationSuccess(AreaLocation location) {
                    if (location != null) {
                        String host = QXMqttHostManager.getInstance().getHostFromDefaultByCountryCode(location.getCountryCode());
                        callbackOnGeOptimalHost(host, listener);
                    } else {
                        callbackOnGeOptimalHost(HOST_CN, listener);
                    }
                }

                @Override
                public void onLocationFailed() {

                    callbackOnGeOptimalHost(HOST_CN, listener);
                }
            });

        } else {//再次启动应用
            if (cacheBrokerHost == null) {
                CLog.d(TAG, "again  luncherapp or disconnect and reconnect");
                QXMqttHostManager.getInstance().setCacheBrokerHost(spBrokerHost);
                cacheBrokerHost = spBrokerHost;
            } else {
                CLog.d(TAG, "just break and reconnecting");
                GetBrokerHostResp.NodeBean nodeByHost = cacheBrokerHost.getNodeByHost(currentHost);

                if (nodeByHost == null || nodeByHost.getWeight() <= 0) {
                    GetBrokerHostResp.NodeBean optimalNode = cacheBrokerHost.getOptimalNode();
                    if (optimalNode == null) {
                        CLog.e(TAG, "All node weight is  < 0 ,reset all host weight,Recalculation time delay");
                        QXMqttHostManager.getInstance().setCacheBrokerHost(spBrokerHost);
                        cacheBrokerHost = spBrokerHost;
                    }
                }
            }
            String optimalHost;
            GetBrokerHostResp.NodeBean optimalNode = cacheBrokerHost.getOptimalNode();
            if (optimalNode != null && optimalNode.getWeight() > 0) {
                optimalHost = optimalNode.getServer_domain();
                CLog.d(TAG, "find optimal host = " + optimalHost);
            } else {
                optimalHost = HOST_CN;
            }
            callbackOnGeOptimalHost(optimalHost, listener);
        }

    }


    interface OnGetOptimalHostListener {
        void onGetOptimalHost(String[] hosts);
    }

    public void onServerConnected(String host) {
        this.currentHost = host;
    }


}
