package cn.com.startai.qxcommon.global;

import cn.com.startai.qxcommon.link.mqtt.TopicManager;
import cn.com.startai.qxcommon.protocol.IDeveloper;
import cn.com.startai.qxcommon.utils.QXSpController;
import cn.com.startai.qxcommon.utils.SnUtils;

/**
 * Created by Robin on 2019/5/12.
 * 419109715@qq.com 彬影
 */
public class ParamManager implements IDeveloper {


    private ParamManager() {
    }

    public static ParamManager getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }


    private static class SingleTonHoulder {
        private static final ParamManager singleTonInstance = new ParamManager();
    }

    private DeveloperParam developerParam;

    public DeveloperParam getDeveloperParam() {
        if (developerParam == null) {
            this.developerParam = new DeveloperParam();
        }
        return developerParam;
    }

    public void setDeveloperParam(DeveloperParam developerParam) {
        this.developerParam = developerParam;
    }

    public long getAppid() {
        return getDeveloperParam().getAppid();
    }

    public void init(long appid) {
        initParam(appid);
    }

    public void release() {
        this.developerParam = null;
    }

    private void initParam(long appid) {
        getDeveloperParam().setAppid(appid);
        getDeveloperParam().setThirdCloudAppid(QXSpController.getInstance().getThirdCloudAppid());
        getDeveloperParam().setCustom(QXSpController.getInstance().getCustom());
        getDeveloperParam().setProduct(QXSpController.getInstance().getProduct());
        getDeveloperParam().setSn(SnUtils.getInstance().getSn(appid));
        getDeveloperParam().setUserId(QXUserManager.getInstance().getUserId());
        getDeveloperParam().setTagToService(SnUtils.getInstance().getQXEncodeHash(TopicManager.CLOUD_TOID));
    }

    public void setAppid(long appid) {
        getDeveloperParam().setAppid(appid);
    }

    public long getThirdCloudAppid() {
        if (getDeveloperParam().getThirdCloudAppid() == 0) {
            getDeveloperParam().setThirdCloudAppid(QXSpController.getInstance().getThirdCloudAppid());
        }
        return getDeveloperParam().getThirdCloudAppid();
    }

    public void setThirdCloudAppid(long thirdCloudAppid) {
        getDeveloperParam().setThirdCloudAppid(thirdCloudAppid);
        QXSpController.getInstance().setThirdCloudAppid(thirdCloudAppid);
    }

    public int getCustom() {
        return getDeveloperParam().getCustom();
    }

    public void setCustom(int custom) {
        getDeveloperParam().setCustom(custom);

    }

    public int getProduct() {
        return getDeveloperParam().getProduct();
    }

    public void setProduct(int product) {
        getDeveloperParam().setProduct(product);

    }

    public long getSn() {
        return getDeveloperParam().getSn();
    }

    public void setSn(long sn) {
        getDeveloperParam().setSn(sn);

    }

    public long getUserId() {
        return getDeveloperParam().getUserId();
    }

    public void setUserId(long userId) {
        getDeveloperParam().setUserId(userId);
    }

    public long getTagToService() {
        return getDeveloperParam().getTagToService();
    }

    public void setTagToService(long tagToService) {
        this.getDeveloperParam().setTagToService(tagToService);
    }

    public boolean isHuadianTrainer() {
        return getDeveloperParam().getAppid() == Appid.huadianTrainer;
    }


}
