package cn.com.startai.qxcommon.busi.qx;

import android.app.Application;
import android.net.NetworkInfo;

import java.util.ArrayList;
import java.util.List;

import cn.com.startai.common.channel.ICallListener;
import cn.com.startai.common.channel.mqtt.MqttConnectState;
import cn.com.startai.common.utils.network.CNetworkManager;
import cn.com.startai.qxcommon.QXCommonInitParam;
import cn.com.startai.qxcommon.busi.CommonBusi;
import cn.com.startai.qxcommon.busi.qx.bean.LoginReq;
import cn.com.startai.qxcommon.db.UserBean;
import cn.com.startai.qxcommon.global.QXUserManager;
import cn.com.startai.qxcommon.link.mqtt.QXMqttManager;
import cn.com.startai.qxcommon.link.mqtt.TopicManager;
import cn.com.startai.qxcommon.link.mqtt.busi.bean.ActivateReq;
import cn.com.startai.qxcommon.protocol.QXDataCreater;
import cn.com.startai.qxcommon.protocol.QXMessage;

/**
 * Created by Robin on 2019/5/23.
 * 419109715@qq.com 彬影
 */
public class QxBusi extends CommonBusi implements IQxBusi {
    protected AQXBusiListener qxBusiListener;

    @Override
    public void init(Application application, QXCommonInitParam initParam, AQXBusiListener commonListener) {
        this.qxBusiListener = commonListener;
        CNetworkManager.getInstance().addNetworkListener(qxBusiListener);
        super.init(application, initParam, qxBusiListener);
    }


    @Override
    public void release() {
        this.qxBusiListener = null;
        CNetworkManager.getInstance().removeNetworkListener(qxBusiListener);
        super.release();
    }

    @Override
    public void logout() {

        QXUserManager.getInstance().onLogout();

        if (qxBusiListener != null) {
            qxBusiListener.onQXLogoutResult(true);
        }

    }

    @Override
    public void activate(ActivateReq req, ICallListener callListener) {
        QXMessage app2CloudSetQXMsg = QXDataCreater.getApp2CloudSetQXMsg(0, false, req);
        doSend(QXDataCreater.getCloudBaseData(app2CloudSetQXMsg), callListener);
    }

    @Override
    public void login(LoginReq req, ICallListener callListener) {
        QXMessage app2CloudSetQXMsg = QXDataCreater.getApp2CloudSetQXMsg(0, false, req);
        doSend(QXDataCreater.getCloudBaseData(app2CloudSetQXMsg), callListener);
    }


    @Override
    public MqttConnectState getServerConnectState() {
        return QXMqttManager.getInstance().getMqttConnectState();
    }

    @Override
    public NetworkInfo.State getNetworkState() {
        return CNetworkManager.getInstance().getState();
    }

    @Override
    public String getNetworkType() {
        return CNetworkManager.getInstance().getNetworkType();
    }

    @Override
    public UserBean getUserBean() {
        return QXUserManager.getInstance().getUserBean();
    }


}
